/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import io.vertx.core.Vertx;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import java.security.KeyStore;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.camel.component.vertx.websocket.VertxWebsocketConfiguration;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHostKey;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.TrustManagersParameters;

public final class VertxWebsocketHelper {
    private VertxWebsocketHelper() {
    }

    public static void setupSSLOptions(SSLContextParameters sslContextParameters, TCPSSLOptions options) throws Exception {
        options.setSsl(true);
        options.setKeyCertOptions((KeyCertOptions)new KeyManagerFactoryOptions(VertxWebsocketHelper.createKeyManagerFactory(sslContextParameters)));
        options.setTrustOptions((TrustOptions)new TrustManagerFactoryOptions(VertxWebsocketHelper.createTrustManagerFactory(sslContextParameters)));
    }

    public static int extractPortNumber(String remaining) {
        int index1 = remaining.indexOf(58);
        int index2 = remaining.indexOf(47);
        if (index1 != -1 && index2 != -1) {
            String result = remaining.substring(index1 + 1, index2);
            if (result.isEmpty()) {
                throw new IllegalArgumentException("Unable to resolve port from URI: " + remaining);
            }
            try {
                return Integer.parseInt(result);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unable to parse port: " + result);
            }
        }
        return 0;
    }

    public static String extractHostName(String remaining) {
        int index = remaining.indexOf(58);
        if (index != -1) {
            return remaining.substring(0, index);
        }
        return "0.0.0.0";
    }

    public static String extractPath(String remaining) {
        int index = remaining.indexOf(47);
        if (index != -1) {
            return remaining.substring(index);
        }
        return "/" + remaining;
    }

    public static VertxWebsocketHostKey createHostKey(VertxWebsocketConfiguration configuration) {
        return new VertxWebsocketHostKey(configuration.getHost(), configuration.getPort());
    }

    private static KeyManagerFactory createKeyManagerFactory(SSLContextParameters sslContextParameters) throws Exception {
        KeyManagersParameters keyManagers = sslContextParameters.getKeyManagers();
        if (keyManagers == null) {
            return null;
        }
        String kmfAlgorithm = keyManagers.getAlgorithm();
        if (kmfAlgorithm == null) {
            kmfAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        KeyManagerFactory kmf = keyManagers.getProvider() == null ? KeyManagerFactory.getInstance(kmfAlgorithm) : KeyManagerFactory.getInstance(kmfAlgorithm, keyManagers.getProvider());
        char[] kmfPassword = null;
        if (keyManagers.getKeyPassword() != null) {
            kmfPassword = keyManagers.getKeyPassword().toCharArray();
        }
        KeyStore ks = keyManagers.getKeyStore() == null ? null : keyManagers.getKeyStore().createKeyStore();
        kmf.init(ks, kmfPassword);
        return kmf;
    }

    private static TrustManagerFactory createTrustManagerFactory(SSLContextParameters sslContextParameters) throws Exception {
        TrustManagersParameters trustManagers = sslContextParameters.getTrustManagers();
        if (trustManagers == null) {
            return null;
        }
        TrustManagerFactory tmf = null;
        if (trustManagers.getKeyStore() != null) {
            String tmfAlgorithm = trustManagers.getAlgorithm();
            if (tmfAlgorithm == null) {
                tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            tmf = trustManagers.getProvider() == null ? TrustManagerFactory.getInstance(tmfAlgorithm) : TrustManagerFactory.getInstance(tmfAlgorithm, trustManagers.getProvider());
            KeyStore ks = trustManagers.getKeyStore() == null ? null : trustManagers.getKeyStore().createKeyStore();
            tmf.init(ks);
        }
        return tmf;
    }

    private static class TrustManagerFactoryOptions
    implements TrustOptions {
        private final TrustManagerFactory trustManagerFactory;

        public TrustManagerFactoryOptions(TrustManagerFactory trustManagerFactory) {
            this.trustManagerFactory = trustManagerFactory;
        }

        private TrustManagerFactoryOptions(TrustManagerFactoryOptions other) {
            this.trustManagerFactory = other.trustManagerFactory;
        }

        public TrustOptions copy() {
            return new TrustManagerFactoryOptions(this);
        }

        public TrustManagerFactory getTrustManagerFactory(Vertx vertx) {
            return this.trustManagerFactory;
        }

        public Function<String, TrustManager[]> trustManagerMapper(Vertx vertx) {
            return serverName -> this.trustManagerFactory.getTrustManagers();
        }
    }

    private static class KeyManagerFactoryOptions
    implements KeyCertOptions {
        private final KeyManagerFactory keyManagerFactory;

        public KeyManagerFactoryOptions(KeyManagerFactory keyManagerFactory) {
            this.keyManagerFactory = keyManagerFactory;
        }

        private KeyManagerFactoryOptions(KeyManagerFactoryOptions other) {
            this.keyManagerFactory = other.keyManagerFactory;
        }

        public KeyCertOptions copy() {
            return new KeyManagerFactoryOptions(this);
        }

        public KeyManagerFactory getKeyManagerFactory(Vertx vertx) {
            return this.keyManagerFactory;
        }

        public Function<String, X509KeyManager> keyManagerMapper(Vertx vertx) {
            return this.keyManagerFactory.getKeyManagers()[0] instanceof X509KeyManager ? serverName -> (X509KeyManager)this.keyManagerFactory.getKeyManagers()[0] : null;
        }
    }
}

