/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketBase;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.vertx.websocket.VertxWebsocketEndpoint;
import org.apache.camel.component.vertx.websocket.VertxWebsocketResultHandler;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxWebsocketProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(VertxWebsocketProducer.class);

    public VertxWebsocketProducer(VertxWebsocketEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public VertxWebsocketEndpoint getEndpoint() {
        return (VertxWebsocketEndpoint)super.getEndpoint();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Message in = exchange.getIn();
            Object message = in.getBody();
            if (message == null) {
                callback.done(true);
                return true;
            }
            Map<String, WebSocketBase> connectedPeers = this.getConnectedPeers(exchange);
            VertxWebsocketResultHandler vertxWebsocketResultHandler = new VertxWebsocketResultHandler(exchange, callback, connectedPeers.keySet());
            if (connectedPeers.isEmpty()) {
                callback.done(true);
            }
            connectedPeers.forEach((connectionKey, webSocket) -> {
                Handler handler = result -> {
                    if (!result.succeeded()) {
                        vertxWebsocketResultHandler.onError((String)connectionKey, result.cause());
                    }
                    vertxWebsocketResultHandler.onResult((String)connectionKey);
                };
                if (webSocket != null) {
                    if (webSocket.isClosed()) {
                        LOG.warn("WebSocket peer connection with key {} is already closed", connectionKey);
                        vertxWebsocketResultHandler.onResult((String)connectionKey);
                    } else if (message instanceof String) {
                        webSocket.writeTextMessage((String)message, handler);
                    } else if (message instanceof byte[]) {
                        webSocket.writeBinaryMessage(Buffer.buffer((byte[])((byte[])message)), handler);
                    } else {
                        webSocket.writeTextMessage((String)in.getBody(String.class), handler);
                    }
                } else {
                    LOG.warn("No WebSocket peer connection found for connection key {}", connectionKey);
                    vertxWebsocketResultHandler.onResult((String)connectionKey);
                }
            });
            return false;
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    private Map<String, WebSocketBase> getConnectedPeers(Exchange exchange) throws Exception {
        HashMap<String, WebSocketBase> connectedPeers = new HashMap<String, WebSocketBase>();
        VertxWebsocketEndpoint endpoint = this.getEndpoint();
        Message message = exchange.getMessage();
        boolean isSendToAll = (Boolean)message.getHeader("CamelVertxWebsocket.sendToAll", (Object)endpoint.getConfiguration().isSendToAll(), Boolean.TYPE);
        if (isSendToAll) {
            Map<String, ServerWebSocket> peers = endpoint.findPeersForHostPort();
            if (ObjectHelper.isNotEmpty(peers)) {
                connectedPeers.putAll(peers);
            }
        } else {
            String connectionKey = (String)message.getHeader("CamelVertxWebsocket.connectionKey", String.class);
            if (connectionKey != null && endpoint.isManagedPort()) {
                Stream.of(connectionKey.split(",")).forEach(key -> connectedPeers.put((String)key, (WebSocketBase)endpoint.findPeerForConnectionKey((String)key)));
            } else {
                connectedPeers.put(UUID.randomUUID().toString(), (WebSocketBase)endpoint.getWebSocket(exchange));
            }
        }
        return connectedPeers;
    }
}

