/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.vertx.websocket.VertxWebsocketComponent;
import org.apache.camel.component.vertx.websocket.VertxWebsocketEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxWebsocketConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(VertxWebsocketConsumer.class);
    private final VertxWebsocketEndpoint endpoint;

    public VertxWebsocketConsumer(VertxWebsocketEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.getComponent().connectConsumer(this);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.getComponent().disconnectConsumer(this);
        super.doStop();
    }

    public VertxWebsocketEndpoint getEndpoint() {
        return this.endpoint;
    }

    public VertxWebsocketComponent getComponent() {
        return this.endpoint.getComponent();
    }

    public void onMessage(String connectionKey, Object message) {
        final Exchange exchange = this.endpoint.createExchange();
        exchange.getMessage().setHeader("CamelVertxWebsocket.connectionKey", (Object)connectionKey);
        exchange.getMessage().setBody(message);
        this.getAsyncProcessor().process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (exchange.getException() != null) {
                    VertxWebsocketConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
            }
        });
    }

    public void onException(String connectionKey, Throwable cause) {
        Exchange exchange = this.endpoint.createExchange();
        exchange.getMessage().setHeader("CamelVertxWebsocket.connectionKey", (Object)connectionKey);
        this.getExceptionHandler().handleException("Error processing exchange", exchange, cause);
    }
}

