/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import java.net.URI;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.jsse.SSLContextParameters;

@UriParams
public class VertxWebsocketConfiguration {
    private URI websocketURI;
    @UriPath
    @Metadata(required=true)
    private String host;
    @UriPath
    @Metadata(required=true)
    private int port;
    @UriPath
    private String path;
    @UriParam(label="consumer")
    private String allowedOriginPattern;
    @UriParam(label="consumer")
    private Router router;
    @UriParam(label="consumer")
    private HttpServerOptions serverOptions;
    @UriParam(label="consumer")
    private boolean consumeAsClient;
    @UriParam(label="consumer", defaultValue="0")
    private int reconnectInitialDelay;
    @UriParam(label="consumer", defaultValue="1000")
    private int reconnectInterval = 1000;
    @UriParam(label="consumer", defaultValue="0")
    private int maxReconnectAttempts;
    @UriParam(label="producer")
    private HttpClientOptions clientOptions;
    @UriParam(label="producer")
    private boolean sendToAll;
    @UriParam(label="producer")
    private String clientSubProtocols;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;

    public void setWebsocketURI(URI websocketURI) {
        this.websocketURI = websocketURI;
        this.host = websocketURI.getHost();
        this.port = websocketURI.getPort();
        this.path = websocketURI.getPath();
    }

    public URI getWebsocketURI() {
        return this.websocketURI;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setClientOptions(HttpClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public HttpServerOptions getServerOptions() {
        return this.serverOptions;
    }

    public void setServerOptions(HttpServerOptions serverOptions) {
        this.serverOptions = serverOptions;
    }

    public boolean isConsumeAsClient() {
        return this.consumeAsClient;
    }

    public int getReconnectInitialDelay() {
        return this.reconnectInitialDelay;
    }

    public void setReconnectInitialDelay(int reconnectInitialDelay) {
        this.reconnectInitialDelay = reconnectInitialDelay;
    }

    public int getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(int reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public void setConsumeAsClient(boolean consumeAsClient) {
        this.consumeAsClient = consumeAsClient;
    }

    public HttpClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public void setSendToAll(boolean sendToAll) {
        this.sendToAll = sendToAll;
    }

    public boolean isSendToAll() {
        return this.sendToAll;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public String getAllowedOriginPattern() {
        return this.allowedOriginPattern;
    }

    public void setAllowedOriginPattern(String allowedOriginPattern) {
        this.allowedOriginPattern = allowedOriginPattern;
    }

    public Router getRouter() {
        return this.router;
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public void setClientSubProtocols(String clientSubProtocols) {
        this.clientSubProtocols = clientSubProtocols;
    }

    public String getClientSubProtocols() {
        return this.clientSubProtocols;
    }
}

