/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CorsHandler;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.component.vertx.common.VertxHelper;
import org.apache.camel.component.vertx.websocket.VertxWebsocketConfiguration;
import org.apache.camel.component.vertx.websocket.VertxWebsocketConsumer;
import org.apache.camel.component.vertx.websocket.VertxWebsocketEndpoint;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHostConfiguration;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHostKey;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxWebsocketHost {
    private static final Logger LOG = LoggerFactory.getLogger(VertxWebsocketHost.class);
    private static final Pattern PATH_PARAMETER_PATTERN = Pattern.compile("\\{([^/}]+)\\}");
    private final VertxWebsocketHostConfiguration hostConfiguration;
    private final VertxWebsocketHostKey hostKey;
    private final Map<String, Route> routeRegistry = new HashMap<String, Route>();
    private final Map<String, ServerWebSocket> connectedPeers = new ConcurrentHashMap<String, ServerWebSocket>();
    private final CamelContext camelContext;
    private HttpServer server;
    private int port = 0;

    public VertxWebsocketHost(CamelContext camelContext, VertxWebsocketHostConfiguration websocketHostConfiguration, VertxWebsocketHostKey key) {
        this.camelContext = camelContext;
        this.hostConfiguration = websocketHostConfiguration;
        this.hostKey = key;
    }

    public void connect(VertxWebsocketConsumer consumer) {
        VertxWebsocketEndpoint endpoint = consumer.getEndpoint();
        VertxWebsocketConfiguration configuration = endpoint.getConfiguration();
        URI websocketURI = configuration.getWebsocketURI();
        String path = PATH_PARAMETER_PATTERN.matcher(websocketURI.getPath()).replaceAll(":$1");
        Router router = this.hostConfiguration.getRouter();
        Route route = router.route(path);
        LOG.info("Connected consumer for path {}", (Object)path);
        if (!ObjectHelper.isEmpty((String)configuration.getAllowedOriginPattern())) {
            CorsHandler corsHandler = CorsHandler.create().addRelativeOrigin(configuration.getAllowedOriginPattern());
            route.handler((Handler)corsHandler);
        }
        route.handler(routingContext -> {
            HttpServerRequest request = routingContext.request();
            String connectionHeader = request.headers().get(HttpHeaders.CONNECTION);
            if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
                routingContext.response().setStatusCode(400);
                routingContext.response().end("Can \"Upgrade\" only to \"WebSocket\".");
            } else {
                boolean parseEnded = request.isEnded();
                if (!parseEnded) {
                    request.pause();
                }
                request.toWebSocket(toWebSocket -> {
                    if (toWebSocket.succeeded()) {
                        if (!parseEnded) {
                            request.resume();
                        }
                        ServerWebSocket webSocket = (ServerWebSocket)toWebSocket.result();
                        SocketAddress socketAddress = webSocket.localAddress();
                        SocketAddress remote = webSocket.remoteAddress();
                        String connectionKey = UUID.randomUUID().toString();
                        this.connectedPeers.put(connectionKey, webSocket);
                        if (LOG.isDebugEnabled() && socketAddress != null) {
                            LOG.debug("WebSocket peer {} connected from {}", (Object)connectionKey, (Object)socketAddress.host());
                        }
                        webSocket.textMessageHandler(message -> consumer.onMessage(connectionKey, message, remote, (RoutingContext)routingContext));
                        webSocket.binaryMessageHandler(message -> consumer.onMessage(connectionKey, message.getBytes(), remote, (RoutingContext)routingContext));
                        webSocket.exceptionHandler(exception -> consumer.onException(connectionKey, (Throwable)exception, remote, (RoutingContext)routingContext));
                        webSocket.closeHandler(closeEvent -> {
                            if (LOG.isDebugEnabled() && socketAddress != null) {
                                LOG.debug("WebSocket peer {} disconnected from {}", (Object)connectionKey, (Object)socketAddress.host());
                            }
                            this.connectedPeers.remove(connectionKey);
                        });
                    } else {
                        routingContext.fail(toWebSocket.cause());
                    }
                });
            }
        });
        this.routeRegistry.put(websocketURI.getPath(), route);
    }

    public void disconnect(String path) {
        LOG.info("Disconnected consumer for path {}", (Object)path);
        Route route = this.routeRegistry.remove(path);
        route.remove();
        if (this.routeRegistry.isEmpty()) {
            try {
                this.stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void start() throws Exception {
        if (this.server == null) {
            Vertx vertx = this.hostConfiguration.getVertx();
            Router router = this.hostConfiguration.getRouter();
            HttpServerOptions options = this.hostConfiguration.getServerOptions();
            SSLContextParameters sslContextParameters = this.hostConfiguration.getSslContextParameters();
            if (sslContextParameters != null) {
                if (options == null) {
                    options = new HttpServerOptions();
                }
                VertxHelper.setupSSLOptions((CamelContext)this.camelContext, (SSLContextParameters)sslContextParameters, (TCPSSLOptions)options);
            }
            this.server = options != null ? vertx.createHttpServer(options) : vertx.createHttpServer();
            CompletableFuture future = new CompletableFuture();
            this.server.requestHandler((Handler)router).listen(this.hostKey.getPort(), this.hostKey.getHost(), result -> {
                if (!result.failed()) {
                    this.port = ((HttpServer)result.result()).actualPort();
                    future.complete(null);
                    LOG.info("Vert.x HTTP server started on {}:{}", (Object)this.hostKey.getHost(), (Object)this.port);
                } else {
                    future.completeExceptionally(result.cause());
                }
            });
            future.get();
        }
    }

    public void stop() throws ExecutionException, InterruptedException {
        if (this.server != null) {
            LOG.info("Stopping server");
            try {
                CompletableFuture future = new CompletableFuture();
                this.server.close(result -> {
                    if (result.failed()) {
                        future.completeExceptionally(result.cause());
                        return;
                    }
                    LOG.info("Vert.x HTTP server stopped");
                    future.complete(null);
                });
                future.get();
            }
            finally {
                this.server = null;
            }
        }
        this.connectedPeers.clear();
        this.routeRegistry.clear();
        this.port = 0;
    }

    public Map<String, ServerWebSocket> getConnectedPeers() {
        return this.connectedPeers;
    }

    public int getPort() {
        return this.port;
    }
}

