/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import io.vertx.core.http.impl.HttpUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHostKey;
import org.apache.camel.util.ObjectHelper;

public final class VertxWebsocketHelper {
    private VertxWebsocketHelper() {
    }

    public static VertxWebsocketHostKey createHostKey(URI websockerURI) {
        return new VertxWebsocketHostKey(websockerURI.getHost(), websockerURI.getPort());
    }

    public static void appendHeader(Map<String, Object> headers, String key, Object value) {
        if (headers.containsKey(key)) {
            ArrayList<Object> list;
            Object existing = headers.get(key);
            if (existing instanceof List) {
                list = (ArrayList<Object>)existing;
            } else {
                list = new ArrayList<Object>();
                list.add(existing);
            }
            list.add(value);
            value = list;
        }
        headers.put(key, value);
    }

    public static boolean webSocketHostPathMatches(String hostPath, String targetPath) {
        boolean exactPathMatch = true;
        if (ObjectHelper.isEmpty((String)hostPath) || ObjectHelper.isEmpty((String)targetPath)) {
            return false;
        }
        if (hostPath.endsWith("*")) {
            exactPathMatch = false;
            hostPath = hostPath.substring(0, hostPath.lastIndexOf(42));
        }
        String normalizedHostPath = HttpUtils.normalizePath((String)(hostPath + "/"));
        String normalizedTargetPath = HttpUtils.normalizePath((String)(targetPath + "/"));
        String[] hostPathElements = normalizedHostPath.split("/");
        String[] targetPathElements = normalizedTargetPath.split("/");
        if (exactPathMatch && hostPathElements.length != targetPathElements.length) {
            return false;
        }
        if (normalizedHostPath.contains("{")) {
            for (int i = 0; i < hostPathElements.length; ++i) {
                String hostPathElement = hostPathElements[i];
                String targetPathElement = targetPathElements[i];
                if (hostPathElement.startsWith("{") || hostPathElement.endsWith("}") || hostPathElement.equals(targetPathElement)) continue;
                return false;
            }
        } else {
            if (exactPathMatch) {
                return normalizedHostPath.equals(normalizedTargetPath);
            }
            return normalizedTargetPath.startsWith(normalizedHostPath);
        }
        return true;
    }
}

