/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.util;

import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.management.ManagedManagementStrategy;
import org.apache.camel.web.util.RouteStatistics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMXRouteStatistics
implements RouteStatistics {
    private static final Log LOG = LogFactory.getLog(JMXRouteStatistics.class);

    public Object getRouteStatistic(CamelContext camelContext, String routeID, String attribute) {
        if (!(camelContext.getManagementStrategy() instanceof ManagedManagementStrategy)) {
            return null;
        }
        try {
            MBeanServer server = camelContext.getManagementStrategy().getManagementAgent().getMBeanServer();
            String domain = camelContext.getManagementStrategy().getManagementAgent().getMBeanObjectDomainName();
            ObjectName objName2 = new ObjectName(domain + ":type=routes,*");
            LinkedList<ObjectName> cacheList = new LinkedList<ObjectName>(server.queryNames(objName2, null));
            for (ObjectName objName2 : cacheList) {
                String keyProps = objName2.getCanonicalKeyPropertyListString();
                ObjectName objectInfoName = new ObjectName(domain + ":" + keyProps);
                String currentRouteID = (String)server.getAttribute(objectInfoName, "RouteId");
                if (!currentRouteID.equals(routeID)) continue;
                Object value = server.getAttribute(objectInfoName, attribute);
                if (value instanceof Date) {
                    DateFormat df = DateFormat.getDateTimeInstance(3, 3);
                    return df.format(value);
                }
                return value;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting route statistic from JMX. This exception will be ignored.", (Throwable)e);
        }
        return null;
    }
}

