/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.web3j;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.component.web3j.Web3jConfiguration;
import org.apache.camel.component.web3j.Web3jEndpoint;
import org.apache.camel.component.web3j.Web3jHelper;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.support.HeaderSelectorProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.request.ShhFilter;
import org.web3j.protocol.core.methods.request.ShhPost;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.DbGetHex;
import org.web3j.protocol.core.methods.response.DbGetString;
import org.web3j.protocol.core.methods.response.DbPutHex;
import org.web3j.protocol.core.methods.response.DbPutString;
import org.web3j.protocol.core.methods.response.EthAccounts;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthCoinbase;
import org.web3j.protocol.core.methods.response.EthCompileLLL;
import org.web3j.protocol.core.methods.response.EthCompileSerpent;
import org.web3j.protocol.core.methods.response.EthCompileSolidity;
import org.web3j.protocol.core.methods.response.EthEstimateGas;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetBlockTransactionCountByHash;
import org.web3j.protocol.core.methods.response.EthGetBlockTransactionCountByNumber;
import org.web3j.protocol.core.methods.response.EthGetCode;
import org.web3j.protocol.core.methods.response.EthGetCompilers;
import org.web3j.protocol.core.methods.response.EthGetStorageAt;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthGetUncleCountByBlockHash;
import org.web3j.protocol.core.methods.response.EthGetUncleCountByBlockNumber;
import org.web3j.protocol.core.methods.response.EthGetWork;
import org.web3j.protocol.core.methods.response.EthHashrate;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.EthMining;
import org.web3j.protocol.core.methods.response.EthProtocolVersion;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.EthSign;
import org.web3j.protocol.core.methods.response.EthSubmitHashrate;
import org.web3j.protocol.core.methods.response.EthSubmitWork;
import org.web3j.protocol.core.methods.response.EthSyncing;
import org.web3j.protocol.core.methods.response.EthTransaction;
import org.web3j.protocol.core.methods.response.EthUninstallFilter;
import org.web3j.protocol.core.methods.response.NetListening;
import org.web3j.protocol.core.methods.response.NetPeerCount;
import org.web3j.protocol.core.methods.response.NetVersion;
import org.web3j.protocol.core.methods.response.ShhAddToGroup;
import org.web3j.protocol.core.methods.response.ShhHasIdentity;
import org.web3j.protocol.core.methods.response.ShhMessages;
import org.web3j.protocol.core.methods.response.ShhNewFilter;
import org.web3j.protocol.core.methods.response.ShhNewGroup;
import org.web3j.protocol.core.methods.response.ShhNewIdentity;
import org.web3j.protocol.core.methods.response.ShhUninstallFilter;
import org.web3j.protocol.core.methods.response.ShhVersion;
import org.web3j.protocol.core.methods.response.VoidResponse;
import org.web3j.protocol.core.methods.response.Web3ClientVersion;
import org.web3j.protocol.core.methods.response.Web3Sha3;
import org.web3j.quorum.Quorum;
import org.web3j.quorum.methods.request.PrivateTransaction;
import org.web3j.quorum.methods.response.BlockMaker;
import org.web3j.quorum.methods.response.CanonicalHash;
import org.web3j.quorum.methods.response.MakeBlock;
import org.web3j.quorum.methods.response.PrivatePayload;
import org.web3j.quorum.methods.response.QuorumNodeInfo;
import org.web3j.quorum.methods.response.Vote;
import org.web3j.quorum.methods.response.Voter;

public class Web3jProducer
extends HeaderSelectorProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Web3jProducer.class);
    private Web3j web3j;
    private Quorum quorum;
    private Web3jConfiguration configuration;

    public Web3jProducer(Web3jEndpoint endpoint, Web3jConfiguration configuration) {
        super((Endpoint)endpoint, "OPERATION", () -> configuration.getOperationOrDefault(), false);
        this.web3j = endpoint.getWeb3j();
        this.configuration = configuration;
        if (this.web3j instanceof Quorum) {
            this.quorum = (Quorum)this.web3j;
        }
    }

    public Web3jEndpoint getEndpoint() {
        return (Web3jEndpoint)super.getEndpoint();
    }

    @InvokeOnHeader(value="WEB3_CLIENT_VERSION")
    void web3ClientVersion(Message message) throws IOException {
        Request web3ClientVersionRequest = this.web3j.web3ClientVersion();
        this.setRequestId(message, web3ClientVersionRequest);
        Web3ClientVersion response = (Web3ClientVersion)web3ClientVersionRequest.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getWeb3ClientVersion());
        }
    }

    @InvokeOnHeader(value="WEB3_SHA3")
    void web3Sha3(Message message) throws IOException {
        Request web3Sha3Request = this.web3j.web3Sha3((String)message.getBody(String.class));
        this.setRequestId(message, web3Sha3Request);
        Web3Sha3 response = (Web3Sha3)web3Sha3Request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody(response.getResult());
        }
    }

    @InvokeOnHeader(value="NET_VERSION")
    void netVersion(Message message) throws IOException {
        Request netVersionRequest = this.web3j.netVersion();
        this.setRequestId(message, netVersionRequest);
        NetVersion response = (NetVersion)netVersionRequest.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getNetVersion());
        }
    }

    @InvokeOnHeader(value="NET_LISTENING")
    void netListening(Message message) throws IOException {
        Request netListeningRequest = this.web3j.netListening();
        this.setRequestId(message, netListeningRequest);
        NetListening response = (NetListening)netListeningRequest.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.isListening());
        }
    }

    @InvokeOnHeader(value="NET_PEER_COUNT")
    void netPeerCount(Message message) throws IOException {
        Request request = this.web3j.netPeerCount();
        this.setRequestId(message, request);
        NetPeerCount response = (NetPeerCount)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getQuantity());
        }
    }

    @InvokeOnHeader(value="ethProtocolVersion")
    void ethProtocolVersion(Message message) throws IOException {
        Request request = this.web3j.ethProtocolVersion();
        this.setRequestId(message, request);
        EthProtocolVersion response = (EthProtocolVersion)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getProtocolVersion());
        }
    }

    @InvokeOnHeader(value="ETH_SYNCING")
    void ethSyncing(Message message) throws IOException {
        Request request = this.web3j.ethSyncing();
        this.setRequestId(message, request);
        EthSyncing response = (EthSyncing)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.isSyncing());
        }
    }

    @InvokeOnHeader(value="ETH_COINBASE")
    void ethCoinbase(Message message) throws IOException {
        Request request = this.web3j.ethCoinbase();
        this.setRequestId(message, request);
        EthCoinbase response = (EthCoinbase)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getAddress());
        }
    }

    @InvokeOnHeader(value="ETH_MINING")
    void ethMining(Message message) throws IOException {
        Request request = this.web3j.ethMining();
        this.setRequestId(message, request);
        EthMining response = (EthMining)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.isMining());
        }
    }

    @InvokeOnHeader(value="ETH_HASHRATE")
    void ethHashrate(Message message) throws IOException {
        Request request = this.web3j.ethHashrate();
        this.setRequestId(message, request);
        EthHashrate response = (EthHashrate)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getHashrate());
        }
    }

    @InvokeOnHeader(value="ETH_GAS_PRICE")
    void ethGasPrice(Message message) throws IOException {
        Request request = this.web3j.ethGasPrice();
        this.setRequestId(message, request);
        EthGasPrice response = (EthGasPrice)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getGasPrice());
        }
    }

    @InvokeOnHeader(value="ETH_ACCOUNTS")
    void ethAccounts(Message message) throws IOException {
        Request request = this.web3j.ethAccounts();
        this.setRequestId(message, request);
        EthAccounts response = (EthAccounts)request.send();
        message.setBody((Object)response.getAccounts());
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getAccounts());
        }
    }

    @InvokeOnHeader(value="ETH_BLOCK_NUMBER")
    void ethBlockNumber(Message message) throws IOException {
        Request request = this.web3j.ethBlockNumber();
        this.setRequestId(message, request);
        EthBlockNumber response = (EthBlockNumber)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getBlockNumber());
        }
    }

    @InvokeOnHeader(value="ETH_GET_BALANCE")
    void ethGetBalance(Message message) throws IOException {
        String address = (String)message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter((String)message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        Request request = this.web3j.ethGetBalance(address, atBlock);
        this.setRequestId(message, request);
        EthGetBalance response = (EthGetBalance)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getBalance());
        }
    }

    @InvokeOnHeader(value="ETH_GET_STORAGE_AT")
    void ethGetStorageAt(Message message) throws IOException {
        String address = (String)message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter((String)message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        BigInteger position = (BigInteger)message.getHeader("POSITION", this.configuration::getPosition, BigInteger.class);
        Request request = this.web3j.ethGetStorageAt(address, position, atBlock);
        this.setRequestId(message, request);
        EthGetStorageAt response = (EthGetStorageAt)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getData());
        }
    }

    @InvokeOnHeader(value="ETH_GET_TRANSACTION_COUNT")
    void ethGetTransactionCount(Message message) throws IOException {
        String address = (String)message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter((String)message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        Request request = this.web3j.ethGetTransactionCount(address, atBlock);
        this.setRequestId(message, request);
        EthGetTransactionCount response = (EthGetTransactionCount)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getTransactionCount());
        }
    }

    @InvokeOnHeader(value="ETH_GET_BLOCK_TRANSACTION_COUNT_BY_HASH")
    void ethGetBlockTransactionCountByHash(Message message) throws IOException {
        String blockHash = (String)message.getHeader("BLOCK_HASH", this.configuration::getBlockHash, String.class);
        Request request = this.web3j.ethGetBlockTransactionCountByHash(blockHash);
        this.setRequestId(message, request);
        EthGetBlockTransactionCountByHash response = (EthGetBlockTransactionCountByHash)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getTransactionCount());
        }
    }

    @InvokeOnHeader(value="ETH_GET_BLOCK_TRANSACTION_COUNT_BY_NUMBER")
    void ethGetBlockTransactionCountByNumber(Message message) throws IOException {
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter((String)message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        Request request = this.web3j.ethGetBlockTransactionCountByNumber(atBlock);
        this.setRequestId(message, request);
        EthGetBlockTransactionCountByNumber response = (EthGetBlockTransactionCountByNumber)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getTransactionCount());
        }
    }

    @InvokeOnHeader(value="ETH_GET_UNCLE_COUNT_BY_BLOCK_HASH")
    void ethGetUncleCountByBlockHash(Message message) throws IOException {
        String blockHash = (String)message.getHeader("BLOCK_HASH", this.configuration::getBlockHash, String.class);
        Request request = this.web3j.ethGetUncleCountByBlockHash(blockHash);
        this.setRequestId(message, request);
        EthGetUncleCountByBlockHash response = (EthGetUncleCountByBlockHash)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getUncleCount());
        }
    }

    @InvokeOnHeader(value="ETH_GET_UNCLE_COUNT_BY_BLOCK_NUMBER")
    void ethGetUncleCountByBlockNumber(Message message) throws IOException {
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter((String)message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        Request request = this.web3j.ethGetUncleCountByBlockNumber(atBlock);
        this.setRequestId(message, request);
        EthGetUncleCountByBlockNumber response = (EthGetUncleCountByBlockNumber)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getUncleCount());
        }
    }

    @InvokeOnHeader(value="ETH_GET_CODE")
    void ethGetCode(Message message) throws IOException {
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter((String)message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        String address = (String)message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        Request request = this.web3j.ethGetCode(address, atBlock);
        this.setRequestId(message, request);
        EthGetCode response = (EthGetCode)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getCode());
        }
    }

    @InvokeOnHeader(value="ETH_SIGN")
    void ethSign(Message message) throws IOException {
        String address = (String)message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        String sha3HashOfDataToSign = (String)message.getHeader("SHA3_HASH_OF_DATA_TO_SIGN", this.configuration::getSha3HashOfDataToSign, String.class);
        Request request = this.web3j.ethSign(address, sha3HashOfDataToSign);
        this.setRequestId(message, request);
        EthSign response = (EthSign)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getSignature());
        }
    }

    @InvokeOnHeader(value="ETH_SEND_TRANSACTION")
    void ethSendTransaction(Message message) throws IOException {
        String fromAddress = (String)message.getHeader("FROM_ADDRESS", this.configuration::getFromAddress, String.class);
        String toAddress = (String)message.getHeader("TO_ADDRESS", this.configuration::getToAddress, String.class);
        BigInteger nonce = (BigInteger)message.getHeader("NONCE", this.configuration::getNonce, BigInteger.class);
        BigInteger gasPrice = (BigInteger)message.getHeader("GAS_PRICE", this.configuration::getGasPrice, BigInteger.class);
        BigInteger gasLimit = (BigInteger)message.getHeader("GAS_LIMIT", this.configuration::getGasLimit, BigInteger.class);
        BigInteger value = (BigInteger)message.getHeader("VALUE", this.configuration::getValue, BigInteger.class);
        String data = (String)message.getHeader("DATA", this.configuration::getData, String.class);
        Transaction transaction = new Transaction(fromAddress, nonce, gasPrice, gasLimit, toAddress, value, data);
        Request request = this.web3j.ethSendTransaction(transaction);
        this.setRequestId(message, request);
        EthSendTransaction response = (EthSendTransaction)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getTransactionHash());
        }
    }

    @InvokeOnHeader(value="ETH_SEND_RAW_TRANSACTION")
    void ethSendRawTransaction(Message message) throws IOException {
        String signedTransactionData = (String)message.getHeader("SIGNED_TRANSACTION_DATA", this.configuration::getSignedTransactionData, String.class);
        Request request = this.web3j.ethSendRawTransaction(signedTransactionData);
        this.setRequestId(message, request);
        EthSendTransaction response = (EthSendTransaction)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getTransactionHash());
        }
    }

    @InvokeOnHeader(value="ETH_CALL")
    void ethCall(Message message) throws IOException {
        String fromAddress = (String)message.getHeader("FROM_ADDRESS", this.configuration::getFromAddress, String.class);
        String toAddress = (String)message.getHeader("TO_ADDRESS", this.configuration::getToAddress, String.class);
        BigInteger nonce = (BigInteger)message.getHeader("NONCE", this.configuration::getNonce, BigInteger.class);
        BigInteger gasPrice = (BigInteger)message.getHeader("GAS_PRICE", this.configuration::getGasPrice, BigInteger.class);
        BigInteger gasLimit = (BigInteger)message.getHeader("GAS_LIMIT", this.configuration::getGasLimit, BigInteger.class);
        BigInteger value = (BigInteger)message.getHeader("VALUE", this.configuration::getValue, BigInteger.class);
        String data = (String)message.getHeader("DATA", this.configuration::getData, String.class);
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter((String)message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        Transaction transaction = new Transaction(fromAddress, nonce, gasPrice, gasLimit, toAddress, value, data);
        Request request = this.web3j.ethCall(transaction, atBlock);
        this.setRequestId(message, request);
        EthCall response = (EthCall)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getValue());
        }
    }

    @InvokeOnHeader(value="ETH_ESTIMATE_GAS")
    void ethEstimateGas(Message message) throws IOException {
        String fromAddress = (String)message.getHeader("FROM_ADDRESS", this.configuration::getFromAddress, String.class);
        String toAddress = (String)message.getHeader("TO_ADDRESS", this.configuration::getToAddress, String.class);
        String data = (String)message.getHeader("DATA", this.configuration::getData, String.class);
        Transaction transaction = new Transaction(fromAddress, null, null, null, toAddress, null, data);
        Request request = this.web3j.ethEstimateGas(transaction);
        this.setRequestId(message, request);
        EthEstimateGas response = (EthEstimateGas)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getAmountUsed());
        }
    }

    @InvokeOnHeader(value="ETH_GET_BLOCK_BY_HASH")
    void ethGetBlockByHash(Message message) throws IOException {
        Boolean fullTransactionObjects = (Boolean)message.getHeader("FULL_TRANSACTION_OBJECTS", this.configuration::isFullTransactionObjects, Boolean.class);
        String blockHash = (String)message.getHeader("BLOCK_HASH", this.configuration::getBlockHash, String.class);
        Request request = this.web3j.ethGetBlockByHash(blockHash, fullTransactionObjects.booleanValue());
        this.setRequestId(message, request);
        EthBlock response = (EthBlock)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getBlock());
        }
    }

    @InvokeOnHeader(value="ETH_GET_BLOCK_BY_NUMBER")
    void ethGetBlockByNumber(Message message) throws IOException {
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter((String)message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        Boolean fullTransactionObjects = (Boolean)message.getHeader("FULL_TRANSACTION_OBJECTS", this.configuration::isFullTransactionObjects, Boolean.class);
        Request request = this.web3j.ethGetBlockByNumber(atBlock, fullTransactionObjects.booleanValue());
        this.setRequestId(message, request);
        EthBlock response = (EthBlock)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getBlock());
        }
    }

    @InvokeOnHeader(value="ETH_GET_TRANSACTION_BY_HASH")
    void ethGetTransactionByHash(Message message) throws IOException {
        String transactionHash = (String)message.getHeader("TRANSACTION_HASH", this.configuration::getTransactionHash, String.class);
        Request request = this.web3j.ethGetTransactionByHash(transactionHash);
        this.setRequestId(message, request);
        EthTransaction response = (EthTransaction)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody(response.getTransaction().isPresent() ? response.getTransaction().get() : null);
        }
    }

    @InvokeOnHeader(value="ETH_GET_TRANSACTION_BY_BLOCK_HASH_AND_INDEX")
    void ethGetTransactionByBlockHashAndIndex(Message message) throws IOException {
        String blockHash = (String)message.getHeader("BLOCK_HASH", this.configuration::getBlockHash, String.class);
        BigInteger transactionIndex = (BigInteger)message.getHeader("INDEX", this.configuration::getIndex, BigInteger.class);
        Request request = this.web3j.ethGetTransactionByBlockHashAndIndex(blockHash, transactionIndex);
        this.setRequestId(message, request);
        EthTransaction response = (EthTransaction)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody(response.getTransaction().isPresent() ? response.getTransaction().get() : null);
        }
    }

    @InvokeOnHeader(value="ETH_GET_TRANSACTION_BY_BLOCK_NUMBER_AND_INDEX")
    void ethGetTransactionByBlockNumberAndIndex(Message message) throws IOException {
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter((String)message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        BigInteger transactionIndex = (BigInteger)message.getHeader("INDEX", this.configuration::getIndex, BigInteger.class);
        Request request = this.web3j.ethGetTransactionByBlockNumberAndIndex(atBlock, transactionIndex);
        this.setRequestId(message, request);
        EthTransaction response = (EthTransaction)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody(response.getTransaction().isPresent() ? response.getTransaction().get() : null);
        }
    }

    @InvokeOnHeader(value="ETH_GET_UNCLE_BY_BLOCK_HASH_AND_INDEX")
    void ethGetUncleByBlockHashAndIndex(Message message) throws IOException {
        String blockHash = (String)message.getHeader("BLOCK_HASH", this.configuration::getBlockHash, String.class);
        BigInteger uncleIndex = (BigInteger)message.getHeader("INDEX", this.configuration::getIndex, BigInteger.class);
        Request request = this.web3j.ethGetUncleByBlockHashAndIndex(blockHash, uncleIndex);
        this.setRequestId(message, request);
        EthBlock response = (EthBlock)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getBlock());
        }
    }

    @InvokeOnHeader(value="ETH_GET_UNCLE_BY_BLOCK_NUMBER_AND_INDEX")
    void ethGetUncleByBlockNumberAndIndex(Message message) throws IOException {
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter((String)message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        BigInteger uncleIndex = (BigInteger)message.getHeader("INDEX", this.configuration::getIndex, BigInteger.class);
        Request request = this.web3j.ethGetUncleByBlockNumberAndIndex(atBlock, uncleIndex);
        this.setRequestId(message, request);
        EthBlock response = (EthBlock)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getBlock());
        }
    }

    @InvokeOnHeader(value="ETH_GET_TRANSACTION_RECEIPT")
    void ethGetTransactionReceipt(Message message) throws IOException {
        String transactionHash = (String)message.getHeader("TRANSACTION_HASH", this.configuration::getTransactionHash, String.class);
        Request request = this.web3j.ethGetTransactionReceipt(transactionHash);
        this.setRequestId(message, request);
        EthGetTransactionReceipt response = (EthGetTransactionReceipt)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getTransactionReceipt());
        }
    }

    @InvokeOnHeader(value="ETH_GET_COMPILERS")
    void ethGetCompilers(Message message) throws IOException {
        Request request = this.web3j.ethGetCompilers();
        this.setRequestId(message, request);
        EthGetCompilers response = (EthGetCompilers)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getCompilers());
        }
    }

    @InvokeOnHeader(value="ETH_COMPILE_LLL")
    void ethCompileLLL(Message message) throws IOException {
        String sourceCode = (String)message.getHeader("SOURCE_CODE", this.configuration::getSourceCode, String.class);
        Request request = this.web3j.ethCompileLLL(sourceCode);
        this.setRequestId(message, request);
        EthCompileLLL response = (EthCompileLLL)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getCompiledSourceCode());
        }
    }

    @InvokeOnHeader(value="ETH_COMPILE_SOLIDITY")
    void ethCompileSolidity(Message message) throws IOException {
        String sourceCode = (String)message.getHeader("SOURCE_CODE", this.configuration::getSourceCode, String.class);
        Request request = this.web3j.ethCompileSolidity(sourceCode);
        this.setRequestId(message, request);
        EthCompileSolidity response = (EthCompileSolidity)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getCompiledSolidity());
        }
    }

    @InvokeOnHeader(value="ETH_COMPILE_SERPENT")
    void ethCompileSerpent(Message message) throws IOException {
        String sourceCode = (String)message.getHeader("SOURCE_CODE", this.configuration::getSourceCode, String.class);
        Request request = this.web3j.ethCompileSerpent(sourceCode);
        this.setRequestId(message, request);
        EthCompileSerpent response = (EthCompileSerpent)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getCompiledSourceCode());
        }
    }

    @InvokeOnHeader(value="ETH_NEW_FILTER")
    void ethNewFilter(Message message) throws IOException {
        DefaultBlockParameter fromBlock = Web3jHelper.toDefaultBlockParameter((String)message.getHeader("FROM_BLOCK", this.configuration::getFromBlock, String.class));
        DefaultBlockParameter toBlock = Web3jHelper.toDefaultBlockParameter((String)message.getHeader("TO_BLOCK", this.configuration::getToBlock, String.class));
        List addresses = (List)message.getHeader("ADDRESSES", this.configuration::getAddresses, List.class);
        List topics = (List)message.getHeader("TOPICS", this.configuration::getTopics, List.class);
        EthFilter ethFilter = Web3jEndpoint.buildEthFilter(fromBlock, toBlock, addresses, topics);
        Request request = this.web3j.ethNewFilter(ethFilter);
        this.setRequestId(message, request);
        org.web3j.protocol.core.methods.response.EthFilter response = (org.web3j.protocol.core.methods.response.EthFilter)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getFilterId());
        }
    }

    @InvokeOnHeader(value="ETH_NEW_BLOCK_FILTER")
    void ethNewBlockFilter(Message message) throws IOException {
        Request request = this.web3j.ethNewBlockFilter();
        this.setRequestId(message, request);
        org.web3j.protocol.core.methods.response.EthFilter response = (org.web3j.protocol.core.methods.response.EthFilter)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getFilterId());
        }
    }

    @InvokeOnHeader(value="ETH_NEW_PENDING_TRANSACTION_FILTER")
    void ethNewPendingTransactionFilter(Message message) throws IOException {
        Request request = this.web3j.ethNewPendingTransactionFilter();
        this.setRequestId(message, request);
        org.web3j.protocol.core.methods.response.EthFilter response = (org.web3j.protocol.core.methods.response.EthFilter)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getFilterId());
        }
    }

    @InvokeOnHeader(value="ETH_UNINSTALL_FILTER")
    void ethUninstallFilter(Message message) throws IOException {
        BigInteger filterId = (BigInteger)message.getHeader("FILTER_ID", this.configuration::getFilterId, BigInteger.class);
        Request request = this.web3j.ethUninstallFilter(filterId);
        this.setRequestId(message, request);
        EthUninstallFilter response = (EthUninstallFilter)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.isUninstalled());
        }
    }

    @InvokeOnHeader(value="ETH_GET_FILTER_CHANGES")
    void ethGetFilterChanges(Message message) throws IOException {
        BigInteger filterId = (BigInteger)message.getHeader("FILTER_ID", this.configuration::getFilterId, BigInteger.class);
        Request request = this.web3j.ethGetFilterChanges(filterId);
        this.setRequestId(message, request);
        EthLog response = (EthLog)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getLogs());
        }
    }

    @InvokeOnHeader(value="ETH_GET_FILTER_LOGS")
    void ethGetFilterLogs(Message message) throws IOException {
        BigInteger filterId = (BigInteger)message.getHeader("FILTER_ID", this.configuration::getFilterId, BigInteger.class);
        Request request = this.web3j.ethGetFilterLogs(filterId);
        this.setRequestId(message, request);
        EthLog response = (EthLog)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getLogs());
        }
    }

    @InvokeOnHeader(value="ETH_GET_LOGS")
    void ethGetLogs(Message message) throws IOException {
        DefaultBlockParameter fromBlock = Web3jHelper.toDefaultBlockParameter((String)message.getHeader("FROM_BLOCK", this.configuration::getFromBlock, String.class));
        DefaultBlockParameter toBlock = Web3jHelper.toDefaultBlockParameter((String)message.getHeader("TO_BLOCK", this.configuration::getToBlock, String.class));
        List addresses = (List)message.getHeader("ADDRESSES", this.configuration::getAddresses, List.class);
        List topics = (List)message.getHeader("TOPICS", this.configuration::getTopics, List.class);
        EthFilter ethFilter = Web3jEndpoint.buildEthFilter(fromBlock, toBlock, addresses, topics);
        Request request = this.web3j.ethGetLogs(ethFilter);
        this.setRequestId(message, request);
        EthLog response = (EthLog)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getLogs());
        }
    }

    @InvokeOnHeader(value="ETH_GET_WORK")
    void ethGetWork(Message message) throws IOException {
        Request request = this.web3j.ethGetWork();
        this.setRequestId(message, request);
        EthGetWork response = (EthGetWork)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody(response.getResult());
        }
    }

    @InvokeOnHeader(value="ETH_SUBMIT_WORK")
    void ethSubmitWork(Message message) throws IOException {
        String nonce = (String)message.getHeader("NONCE", this.configuration::getNonce, String.class);
        String headerPowHash = (String)message.getHeader("HEADER_POW_HASH", this.configuration::getHeaderPowHash, String.class);
        String mixDigest = (String)message.getHeader("MIX_DIGEST", this.configuration::getMixDigest, String.class);
        Request request = this.web3j.ethSubmitWork(nonce, headerPowHash, mixDigest);
        this.setRequestId(message, request);
        EthSubmitWork response = (EthSubmitWork)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.solutionValid());
        }
    }

    @InvokeOnHeader(value="ETH_SUBMIT_HASHRATE")
    void ethSubmitHashrate(Message message) throws IOException {
        String hashrate = (String)message.getHeader("ETH_HASHRATE", this.configuration::getHashrate, String.class);
        String clientId = (String)message.getHeader("CLIENT_ID", this.configuration::getClientId, String.class);
        Request request = this.web3j.ethSubmitHashrate(hashrate, clientId);
        this.setRequestId(message, request);
        EthSubmitHashrate response = (EthSubmitHashrate)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.submissionSuccessful());
        }
    }

    @InvokeOnHeader(value="DB_PUT_STRING")
    void dbPutString(Message message) throws IOException {
        String databaseName = (String)message.getHeader("DATABASE_NAME", this.configuration::getDatabaseName, String.class);
        String keyName = (String)message.getHeader("KEY_NAME", this.configuration::getKeyName, String.class);
        Request request = this.web3j.dbPutString(databaseName, keyName, (String)message.getBody(String.class));
        this.setRequestId(message, request);
        DbPutString response = (DbPutString)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.valueStored());
        }
    }

    @InvokeOnHeader(value="DB_GET_STRING")
    void dbGetString(Message message) throws IOException {
        String databaseName = (String)message.getHeader("DATABASE_NAME", this.configuration::getDatabaseName, String.class);
        String keyName = (String)message.getHeader("KEY_NAME", this.configuration::getKeyName, String.class);
        Request request = this.web3j.dbGetString(databaseName, keyName);
        this.setRequestId(message, request);
        DbGetString response = (DbGetString)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getStoredValue());
        }
    }

    @InvokeOnHeader(value="DB_PUT_HEX")
    void dbPutHex(Message message) throws IOException {
        String databaseName = (String)message.getHeader("DATABASE_NAME", this.configuration::getDatabaseName, String.class);
        String keyName = (String)message.getHeader("KEY_NAME", this.configuration::getKeyName, String.class);
        Request request = this.web3j.dbPutHex(databaseName, keyName, (String)message.getBody(String.class));
        this.setRequestId(message, request);
        DbPutHex response = (DbPutHex)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.valueStored());
        }
    }

    @InvokeOnHeader(value="DB_GET_HEX")
    void dbGetHex(Message message) throws IOException {
        String databaseName = (String)message.getHeader("DATABASE_NAME", this.configuration::getDatabaseName, String.class);
        String keyName = (String)message.getHeader("KEY_NAME", this.configuration::getKeyName, String.class);
        Request request = this.web3j.dbGetHex(databaseName, keyName);
        this.setRequestId(message, request);
        DbGetHex response = (DbGetHex)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getStoredValue());
        }
    }

    @InvokeOnHeader(value="SHH_VERSION")
    void shhVersion(Message message) throws IOException {
        Request request = this.web3j.shhVersion();
        this.setRequestId(message, request);
        ShhVersion response = (ShhVersion)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getVersion());
        }
    }

    @InvokeOnHeader(value="SHH_POST")
    void shhPost(Message message) throws IOException {
        String fromAddress = (String)message.getHeader("FROM_ADDRESS", this.configuration::getFromAddress, String.class);
        String toAddress = (String)message.getHeader("TO_ADDRESS", this.configuration::getToAddress, String.class);
        List topics = (List)message.getHeader("TOPICS", this.configuration::getTopics, List.class);
        String data = (String)message.getHeader("DATA", this.configuration::getData, String.class);
        BigInteger priority = (BigInteger)message.getHeader("PRIORITY", this.configuration::getPriority, BigInteger.class);
        BigInteger ttl = (BigInteger)message.getHeader("TTL", this.configuration::getTtl, BigInteger.class);
        ShhPost shhPost = new ShhPost(fromAddress, toAddress, topics, data, priority, ttl);
        Request request = this.web3j.shhPost(shhPost);
        this.setRequestId(message, request);
        org.web3j.protocol.core.methods.response.ShhPost response = (org.web3j.protocol.core.methods.response.ShhPost)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.messageSent());
        }
    }

    @InvokeOnHeader(value="SHH_NEW_IDENTITY")
    void shhNewIdentity(Message message) throws IOException {
        Request request = this.web3j.shhNewIdentity();
        this.setRequestId(message, request);
        ShhNewIdentity response = (ShhNewIdentity)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getAddress());
        }
    }

    @InvokeOnHeader(value="SHH_HAS_IDENTITY")
    void shhHasIdentity(Message message) throws IOException {
        String identityAddress = (String)message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        Request request = this.web3j.shhHasIdentity(identityAddress);
        this.setRequestId(message, request);
        ShhHasIdentity response = (ShhHasIdentity)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.hasPrivateKeyForIdentity());
        }
    }

    @InvokeOnHeader(value="SHH_NEW_GROUP")
    void shhNewGroup(Message message) throws IOException {
        Request request = this.web3j.shhNewGroup();
        this.setRequestId(message, request);
        ShhNewGroup response = (ShhNewGroup)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getAddress());
        }
    }

    @InvokeOnHeader(value="SHH_ADD_TO_GROUP")
    void shhAddToGroup(Message message) throws IOException {
        String identityAddress = (String)message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        Request request = this.web3j.shhAddToGroup(identityAddress);
        this.setRequestId(message, request);
        ShhAddToGroup response = (ShhAddToGroup)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.addedToGroup());
        }
    }

    @InvokeOnHeader(value="SHH_NEW_FILTER")
    void shhNewFilter(Message message) throws IOException {
        String data = (String)message.getHeader("DATA", this.configuration::getData, String.class);
        List topics = (List)message.getHeader("TOPICS", this.configuration::getTopics, List.class);
        ShhFilter shhFilter = Web3jEndpoint.buildShhFilter(data, topics);
        Request request = this.web3j.shhNewFilter(shhFilter);
        this.setRequestId(message, request);
        ShhNewFilter response = (ShhNewFilter)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getFilterId());
        }
    }

    @InvokeOnHeader(value="SHH_UNINSTALL_FILTER")
    void shhUninstallFilter(Message message) throws IOException {
        BigInteger filterId = (BigInteger)message.getHeader("FILTER_ID", this.configuration::getFilterId, BigInteger.class);
        Request request = this.web3j.shhUninstallFilter(filterId);
        this.setRequestId(message, request);
        ShhUninstallFilter response = (ShhUninstallFilter)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.isUninstalled());
        }
    }

    @InvokeOnHeader(value="SHH_GET_FILTER_CHANGES")
    void shhGetFilterChanges(Message message) throws IOException {
        BigInteger filterId = (BigInteger)message.getHeader("FILTER_ID", this.configuration::getFilterId, BigInteger.class);
        Request request = this.web3j.shhGetFilterChanges(filterId);
        this.setRequestId(message, request);
        ShhMessages response = (ShhMessages)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getMessages());
        }
    }

    @InvokeOnHeader(value="SHH_GET_MESSAGES")
    void shhGetMessages(Message message) throws IOException {
        BigInteger filterId = (BigInteger)message.getHeader("FILTER_ID", this.configuration::getFilterId, BigInteger.class);
        Request request = this.web3j.shhGetMessages(filterId);
        this.setRequestId(message, request);
        ShhMessages response = (ShhMessages)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getMessages());
        }
    }

    @InvokeOnHeader(value="QUORUM_NODE_INFO")
    void quorumNodeInfo(Message message) throws IOException {
        if (this.quorum == null) {
            this.setQuorumEndpointError(message);
            return;
        }
        Request request = this.quorum.quorumNodeInfo();
        this.setRequestId(message, request);
        QuorumNodeInfo response = (QuorumNodeInfo)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getNodeInfo());
        }
    }

    @InvokeOnHeader(value="QUORUM_CANONICAL_HASH")
    void quorumCanonicalHash(Message message) throws IOException {
        if (this.quorum == null) {
            this.setQuorumEndpointError(message);
            return;
        }
        Request request = this.quorum.quorumCanonicalHash((BigInteger)message.getBody(BigInteger.class));
        this.setRequestId(message, request);
        CanonicalHash response = (CanonicalHash)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getCanonicalHash());
        }
    }

    @InvokeOnHeader(value="QUORUM_VOTE")
    void quorumVote(Message message) throws IOException {
        if (this.quorum == null) {
            this.setQuorumEndpointError(message);
            return;
        }
        String blockHash = (String)message.getHeader("BLOCK_HASH", this.configuration::getBlockHash, String.class);
        Request request = this.quorum.quorumVote(blockHash);
        this.setRequestId(message, request);
        Vote response = (Vote)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getTransactionHash());
        }
    }

    @InvokeOnHeader(value="QUORUM_MAKE_BLOCK")
    void quorumMakeBlock(Message message) throws IOException {
        if (this.quorum == null) {
            this.setQuorumEndpointError(message);
            return;
        }
        Request request = this.quorum.quorumMakeBlock();
        this.setRequestId(message, request);
        MakeBlock response = (MakeBlock)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getBlockHash());
        }
    }

    @InvokeOnHeader(value="QUORUM_PAUSE_BLOCK_MAKER")
    void quorumPauseBlockMaker(Message message) throws IOException {
        if (this.quorum == null) {
            this.setQuorumEndpointError(message);
            return;
        }
        Request request = this.quorum.quorumPauseBlockMaker();
        this.setRequestId(message, request);
        VoidResponse response = (VoidResponse)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.isValid());
        }
    }

    @InvokeOnHeader(value="QUORUM_RESUME_BLOCK_MAKER")
    void quorumResumeBlockMaker(Message message) throws IOException {
        if (this.quorum == null) {
            this.setQuorumEndpointError(message);
            return;
        }
        Request request = this.quorum.quorumResumeBlockMaker();
        this.setRequestId(message, request);
        VoidResponse response = (VoidResponse)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.isValid());
        }
    }

    @InvokeOnHeader(value="QUORUM_IS_BLOCK_MAKER")
    void quorumIsBlockMaker(Message message) throws IOException {
        if (this.quorum == null) {
            this.setQuorumEndpointError(message);
            return;
        }
        String address = (String)message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        Request request = this.quorum.quorumIsBlockMaker(address);
        this.setRequestId(message, request);
        BlockMaker response = (BlockMaker)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.isBlockMaker());
        }
    }

    @InvokeOnHeader(value="QUORUM_IS_VOTER")
    void quorumIsVoter(Message message) throws IOException {
        if (this.quorum == null) {
            this.setQuorumEndpointError(message);
            return;
        }
        String address = (String)message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        Request request = this.quorum.quorumIsVoter(address);
        this.setRequestId(message, request);
        Voter response = (Voter)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.isVoter());
        }
    }

    @InvokeOnHeader(value="QUORUM_GET_PRIVATE_PAYLOAD")
    void quorumGetPrivatePayload(Message message) throws IOException {
        if (this.quorum == null) {
            this.setQuorumEndpointError(message);
            return;
        }
        Request request = this.quorum.quorumGetPrivatePayload((String)message.getBody(String.class));
        this.setRequestId(message, request);
        PrivatePayload response = (PrivatePayload)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getPrivatePayload());
        }
    }

    @InvokeOnHeader(value="QUORUM_ETH_SEND_TRANSACTION")
    void quorumEthSendTransaction(Message message) throws IOException {
        if (this.quorum == null) {
            this.setQuorumEndpointError(message);
            return;
        }
        String fromAddress = (String)message.getHeader("FROM_ADDRESS", this.configuration::getFromAddress, String.class);
        String toAddress = (String)message.getHeader("TO_ADDRESS", this.configuration::getToAddress, String.class);
        BigInteger nonce = (BigInteger)message.getHeader("NONCE", this.configuration::getNonce, BigInteger.class);
        BigInteger gasLimit = (BigInteger)message.getHeader("GAS_LIMIT", this.configuration::getGasLimit, BigInteger.class);
        BigInteger value = (BigInteger)message.getHeader("VALUE", this.configuration::getValue, BigInteger.class);
        String data = (String)message.getHeader("DATA", this.configuration::getData, String.class);
        List privateFor = (List)message.getHeader("PRIVATE_FOR", this.configuration::getPrivateFor, List.class);
        PrivateTransaction transaction = new PrivateTransaction(fromAddress, nonce, gasLimit, toAddress, value, data, privateFor);
        Request request = this.quorum.ethSendTransaction(transaction);
        this.setRequestId(message, request);
        EthSendTransaction response = (EthSendTransaction)request.send();
        boolean hasError = this.checkForError(message, (Response)response);
        if (!hasError) {
            message.setBody((Object)response.getTransactionHash());
        }
    }

    private void setRequestId(Message message, Request request) {
        Long id = (Long)message.getHeader("ID", Long.class);
        LOG.debug("setRequestId {}", (Object)id);
        if (id != null) {
            request.setId(id.longValue());
        }
    }

    private boolean checkForError(Message message, Response response) {
        if (response.hasError()) {
            int code = response.getError().getCode();
            String data = response.getError().getData();
            String messages = response.getError().getMessage();
            message.setHeader("ERROR_CODE", (Object)code);
            message.setHeader("ERROR_DATA", (Object)data);
            message.setHeader("ERROR_MESSAGE", (Object)messages);
            message.getExchange().setException((Throwable)new CamelExchangeException("Web3j failed. Error code: " + code + " data: " + data + " messages: " + messages, message.getExchange()));
            return true;
        }
        return false;
    }

    private void setQuorumEndpointError(Message message) {
        message.getExchange().setException((Throwable)new CamelExchangeException("This is not a Quorum endpoint. Create one by specifying quorumAPI=true", message.getExchange()));
    }
}

