/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.web3j;

import java.util.List;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.web3j.Web3jComponent;
import org.apache.camel.component.web3j.Web3jConfiguration;
import org.apache.camel.component.web3j.Web3jConstants;
import org.apache.camel.component.web3j.Web3jConsumer;
import org.apache.camel.component.web3j.Web3jProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.request.Filter;
import org.web3j.protocol.core.methods.request.ShhFilter;
import org.web3j.protocol.http.HttpService;
import org.web3j.protocol.ipc.UnixIpcService;
import org.web3j.protocol.ipc.WindowsIpcService;
import org.web3j.quorum.Quorum;

@UriEndpoint(firstVersion="2.22.0", scheme="web3j", title="Web3j Ethereum Blockchain", syntax="web3j:nodeAddress", category={Category.BLOCKCHAIN}, headersClass=Web3jConstants.class)
public class Web3jEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(Web3jEndpoint.class);
    private Web3j web3j;
    @UriPath
    @Metadata(required=true)
    private String nodeAddress;
    @UriParam
    private final Web3jConfiguration configuration;

    public Web3jEndpoint(String uri, String remaining, Web3jComponent component, Web3jConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.nodeAddress = remaining;
    }

    protected void doStart() throws Exception {
        this.web3j = this.buildService(this.nodeAddress, this.configuration);
        super.doStart();
    }

    public Web3jConfiguration getConfiguration() {
        return this.configuration;
    }

    public Producer createProducer() throws Exception {
        return new Web3jProducer(this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Web3jConsumer consumer = new Web3jConsumer(this, processor, this.configuration);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Web3j getWeb3j() {
        return this.web3j;
    }

    private Web3j buildService(String clientAddress, Web3jConfiguration configuration) {
        LOG.info("Building service for endpoint: {}", (Object)(clientAddress + configuration));
        if (configuration.getWeb3j() != null) {
            return configuration.getWeb3j();
        }
        Object web3jService = clientAddress == null || clientAddress.isEmpty() ? new HttpService() : (clientAddress.startsWith("http") ? new HttpService(clientAddress) : (System.getProperty("os.name").regionMatches(true, 0, "win", 0, "win".length()) ? new WindowsIpcService(clientAddress) : new UnixIpcService(clientAddress)));
        if (configuration.isQuorumAPI()) {
            return Quorum.build((Web3jService)web3jService);
        }
        return Web3j.build((Web3jService)web3jService);
    }

    public String getNodeAddress() {
        return this.nodeAddress;
    }

    public void setNodeAddress(String nodeAddress) {
        this.nodeAddress = nodeAddress;
    }

    public static EthFilter buildEthFilter(DefaultBlockParameter fromBlock, DefaultBlockParameter toBlock, List<String> addresses, List<String> topics) {
        EthFilter filter = new EthFilter(fromBlock, toBlock, addresses);
        Web3jEndpoint.addTopics(filter, topics);
        return filter;
    }

    public static ShhFilter buildShhFilter(String data, List<String> topics) {
        ShhFilter filter = new ShhFilter(data);
        Web3jEndpoint.addTopics(filter, topics);
        return filter;
    }

    private static void addTopics(Filter<?> filter, List<String> topics) {
        if (topics != null) {
            for (String topic : topics) {
                if (topic != null && topic.length() > 0) {
                    filter.addSingleTopic(topic);
                    continue;
                }
                filter.addNullTopic();
            }
        }
    }
}

