/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.webhook;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.webhook.MultiRestConsumer;
import org.apache.camel.component.webhook.WebhookCapableEndpoint;
import org.apache.camel.component.webhook.WebhookComponent;
import org.apache.camel.component.webhook.WebhookConfiguration;
import org.apache.camel.component.webhook.WebhookUtils;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="3.0.0", scheme="webhook", title="Webhook", syntax="webhook:endpointUri", consumerOnly=true, label="cloud", lenientProperties=true)
public class WebhookEndpoint
extends DefaultEndpoint
implements DelegateEndpoint {
    private WebhookCapableEndpoint delegateEndpoint;
    @UriParam(label="advanced")
    private WebhookConfiguration configuration;

    public WebhookEndpoint(String uri, WebhookComponent component, WebhookConfiguration configuration, String delegateUri) {
        super(uri, (Component)component);
        this.configuration = configuration;
        Endpoint delegate = this.getCamelContext().getEndpoint(delegateUri);
        if (!(delegate instanceof WebhookCapableEndpoint)) {
            throw new IllegalArgumentException("The provided endpoint is not capable of being used in webhook mode: " + delegateUri);
        }
        this.delegateEndpoint = (WebhookCapableEndpoint)delegate;
        this.delegateEndpoint.setWebhookConfiguration(configuration);
    }

    public Producer createProducer() {
        throw new UnsupportedOperationException("You cannot create a producer with the webhook endpoint.");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        RestConsumerFactory factory = WebhookUtils.locateRestConsumerFactory(this.getCamelContext(), this.configuration);
        String path = this.configuration.computeFullPath(false);
        String serverUrl = this.configuration.computeServerUriPrefix();
        String url = serverUrl + path;
        Processor handler = this.delegateEndpoint.createWebhookHandler(processor);
        return new MultiRestConsumer(this.getCamelContext(), factory, (Endpoint)this, handler, this.delegateEndpoint.getWebhookMethods(), url, path, this.configuration.getRestConfiguration(), arg_0 -> ((WebhookEndpoint)this).configureConsumer(arg_0));
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.configuration.isWebhookAutoRegister()) {
            this.log.info("Registering webhook for endpoint {}", (Object)this.delegateEndpoint);
            this.delegateEndpoint.registerWebhook();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.configuration.isWebhookAutoRegister()) {
            this.log.info("Unregistering webhook for endpoint {}", (Object)this.delegateEndpoint);
            this.delegateEndpoint.unregisterWebhook();
        }
    }

    public WebhookConfiguration getConfiguration() {
        return this.configuration;
    }

    public WebhookCapableEndpoint getEndpoint() {
        return this.delegateEndpoint;
    }
}

