/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.webhook;

import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.webhook.WebhookAction;
import org.apache.camel.component.webhook.WebhookCapableEndpoint;
import org.apache.camel.component.webhook.WebhookEndpoint;
import org.apache.camel.support.RoutePolicySupport;

class WebhookRoutePolicy
extends RoutePolicySupport {
    private final CamelContext context;
    private final WebhookAction action;

    public WebhookRoutePolicy(CamelContext context, WebhookAction action) {
        this.context = context;
        this.action = action;
    }

    public void onInit(Route route) {
        super.onInit(route);
        route.setAutoStartup(Boolean.valueOf(false));
        if (route.getEndpoint() instanceof WebhookEndpoint) {
            WebhookEndpoint webhook = (WebhookEndpoint)route.getEndpoint();
            if (webhook.getConfiguration() != null && webhook.getConfiguration().isWebhookAutoRegister()) {
                throw new IllegalStateException("Webhook auto-register is enabled on endpoint " + (Object)((Object)webhook) + ": it must be disabled when the WebhookRoutePolicy is active");
            }
            this.executeWebhookAction(webhook.getEndpoint());
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.context.getExecutorServiceManager().newThread("terminator", () -> ((CamelContext)this.context).stop()).start();
    }

    private void executeWebhookAction(WebhookCapableEndpoint endpoint) {
        switch (this.action) {
            case REGISTER: {
                try {
                    endpoint.registerWebhook();
                }
                catch (Exception ex) {
                    throw new RuntimeCamelException("Unable to register webhook for endpoint " + endpoint, (Throwable)ex);
                }
                return;
            }
            case UNREGISTER: {
                try {
                    endpoint.unregisterWebhook();
                }
                catch (Exception ex) {
                    throw new RuntimeCamelException("Unable to unregister webhook for endpoint " + endpoint, (Throwable)ex);
                }
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported webhook action type: " + (Object)((Object)this.action));
    }
}

