/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.webhook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.service.ServiceHelper;

public class MultiRestConsumer
extends DefaultConsumer {
    private List<Consumer> delegateConsumers = new ArrayList<Consumer>();

    public MultiRestConsumer(CamelContext context, RestConsumerFactory factory, Endpoint endpoint, Processor processor, List<String> methods, String url, String path, RestConfiguration config, ConsumerConfigurer configurer) throws Exception {
        super(endpoint, processor);
        for (String method : methods) {
            Consumer consumer = factory.createConsumer(context, processor, method, path, null, null, null, config, Collections.emptyMap());
            configurer.configure(consumer);
            context.getRestRegistry().addRestService(consumer, url, url, path, null, method, null, null, null, null, null, null);
            this.delegateConsumers.add(consumer);
        }
    }

    protected void doInit() {
        for (Consumer consumer : this.delegateConsumers) {
            consumer.init();
        }
    }

    public void doStart() throws Exception {
        super.doStart();
        for (Consumer consumer : this.delegateConsumers) {
            ServiceHelper.startService((Object)consumer);
        }
    }

    public void doStop() throws Exception {
        for (Consumer consumer : this.delegateConsumers) {
            ServiceHelper.stopService((Object)consumer);
        }
        super.doStop();
    }

    protected void doShutdown() throws Exception {
        for (Consumer consumer : this.delegateConsumers) {
            ServiceHelper.stopAndShutdownService((Object)consumer);
        }
        super.doShutdown();
    }

    @FunctionalInterface
    static interface ConsumerConfigurer {
        public void configure(Consumer var1) throws Exception;
    }
}

