/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.webhook;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.webhook.WebhookComponent;
import org.apache.camel.component.webhook.WebhookConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class WebhookComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private WebhookConfiguration getOrCreateConfiguration(WebhookComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new WebhookConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        WebhookComponent target = (WebhookComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)WebhookComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)WebhookComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((WebhookConfiguration)WebhookComponentConfigurer.property((CamelContext)camelContext, WebhookConfiguration.class, (Object)value));
                return true;
            }
            case "webhookautoregister": 
            case "webhookAutoRegister": {
                this.getOrCreateConfiguration(target).setWebhookAutoRegister((Boolean)WebhookComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "webhookbasepath": 
            case "webhookBasePath": {
                this.getOrCreateConfiguration(target).setWebhookBasePath((String)WebhookComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "webhookcomponentname": 
            case "webhookComponentName": {
                this.getOrCreateConfiguration(target).setWebhookComponentName((String)WebhookComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "webhookexternalurl": 
            case "webhookExternalUrl": {
                this.getOrCreateConfiguration(target).setWebhookExternalUrl((String)WebhookComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "webhookpath": 
            case "webhookPath": {
                this.getOrCreateConfiguration(target).setWebhookPath((String)WebhookComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        WebhookComponent target = (WebhookComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "webhookautoregister": 
            case "webhookAutoRegister": {
                return this.getOrCreateConfiguration(target).isWebhookAutoRegister();
            }
            case "webhookbasepath": 
            case "webhookBasePath": {
                return this.getOrCreateConfiguration(target).getWebhookBasePath();
            }
            case "webhookcomponentname": 
            case "webhookComponentName": {
                return this.getOrCreateConfiguration(target).getWebhookComponentName();
            }
            case "webhookexternalurl": 
            case "webhookExternalUrl": {
                return this.getOrCreateConfiguration(target).getWebhookExternalUrl();
            }
            case "webhookpath": 
            case "webhookPath": {
                return this.getOrCreateConfiguration(target).getWebhookPath();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("webhookAutoRegister", Boolean.TYPE);
        map.put("webhookBasePath", String.class);
        map.put("webhookComponentName", String.class);
        map.put("webhookExternalUrl", String.class);
        map.put("webhookPath", String.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("configuration", WebhookConfiguration.class);
        ALL_OPTIONS = map;
    }
}

