/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.webhook;

import java.net.URISyntaxException;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.webhook.WebhookConfiguration;
import org.apache.camel.component.webhook.WebhookEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

@Component(value="webhook")
public class WebhookComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private WebhookConfiguration configuration = new WebhookConfiguration();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String delegateUri = remaining;
        if (ObjectHelper.isEmpty((Object)delegateUri)) {
            throw new IllegalArgumentException("Wrong uri syntax : webhook:uri, got " + remaining);
        }
        WebhookConfiguration config = this.configuration != null ? this.configuration.copy() : new WebhookConfiguration();
        RestConfiguration restConfig = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), (String)config.getWebhookComponentName());
        config.storeConfiguration(restConfig);
        WebhookEndpoint endpoint = new WebhookEndpoint(uri, this, config);
        this.setProperties((Endpoint)endpoint, parameters);
        if (parameters != null && !parameters.isEmpty()) {
            delegateUri = delegateUri + "?" + this.resolveDelegateUriQuery(uri, parameters);
        }
        endpoint.getConfiguration().setEndpointUri(delegateUri);
        return endpoint;
    }

    private String resolveDelegateUriQuery(String uri, Map<String, Object> parameters) throws URISyntaxException {
        String query = uri.substring(uri.indexOf(63) + 1);
        Map rawParameters = URISupport.parseQuery((String)query, (boolean)true);
        Map<String, Object> filtered = rawParameters.entrySet().stream().filter(e -> parameters.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return URISupport.createQueryString(filtered);
    }

    public boolean useRawUri() {
        return true;
    }

    public WebhookConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(WebhookConfiguration configuration) {
        this.configuration = configuration;
    }
}

