/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.webhook;

import org.apache.camel.AfterPropertiesConfigured;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.webhook.MultiRestConsumer;
import org.apache.camel.component.webhook.WebhookCapableEndpoint;
import org.apache.camel.component.webhook.WebhookComponent;
import org.apache.camel.component.webhook.WebhookConfiguration;
import org.apache.camel.component.webhook.WebhookUtils;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.0.0", scheme="webhook", title="Webhook", syntax="webhook:endpointUri", consumerOnly=true, category={Category.CLOUD}, lenientProperties=true)
public class WebhookEndpoint
extends DefaultEndpoint
implements DelegateEndpoint,
AfterPropertiesConfigured {
    private static final Logger LOG = LoggerFactory.getLogger(WebhookEndpoint.class);
    private WebhookCapableEndpoint delegateEndpoint;
    @UriParam(label="advanced")
    private WebhookConfiguration configuration;

    public WebhookEndpoint(String uri, WebhookComponent component, WebhookConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() {
        throw new UnsupportedOperationException("You cannot create a producer with the webhook endpoint.");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        RestConsumerFactory factory = WebhookUtils.locateRestConsumerFactory(this.getCamelContext(), this.configuration);
        String path = this.configuration.computeFullPath(false);
        String serverUrl = this.configuration.computeServerUriPrefix();
        String url = serverUrl + path;
        Processor handler = this.delegateEndpoint.createWebhookHandler(processor);
        return new MultiRestConsumer(this.getCamelContext(), factory, (Endpoint)this, handler, this.delegateEndpoint.getWebhookMethods(), url, path, this.configuration.retrieveRestConfiguration(), x$0 -> this.configureConsumer(x$0));
    }

    public void afterPropertiesConfigured(CamelContext camelContext) {
        Endpoint delegate = this.getCamelContext().getEndpoint(this.configuration.getEndpointUri());
        if (!(delegate instanceof WebhookCapableEndpoint)) {
            throw new IllegalArgumentException("The provided endpoint is not capable of being used in webhook mode: " + this.configuration.getEndpointUri());
        }
        this.delegateEndpoint = (WebhookCapableEndpoint)delegate;
        this.delegateEndpoint.setWebhookConfiguration(this.configuration);
    }

    protected void doInit() throws Exception {
        super.doInit();
        ServiceHelper.initService((Object)this.delegateEndpoint);
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object)this.delegateEndpoint);
        if (this.configuration.isWebhookAutoRegister()) {
            LOG.info("Registering webhook for endpoint: {}", (Object)this.delegateEndpoint);
            this.delegateEndpoint.registerWebhook();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.configuration.isWebhookAutoRegister() && this.delegateEndpoint != null) {
            LOG.info("Unregistering webhook for endpoint: {}", (Object)this.delegateEndpoint);
            this.delegateEndpoint.unregisterWebhook();
        }
        ServiceHelper.stopService((Object)this.delegateEndpoint);
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        ServiceHelper.stopAndShutdownService((Object)this.delegateEndpoint);
    }

    public WebhookConfiguration getConfiguration() {
        return this.configuration;
    }

    public WebhookCapableEndpoint getEndpoint() {
        return this.delegateEndpoint;
    }

    public boolean isLenientProperties() {
        return true;
    }
}

