/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.websocket;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.camel.component.websocket.DefaultWebsocket;
import org.apache.camel.component.websocket.NodeSynchronization;
import org.apache.camel.component.websocket.WebSocketFactory;
import org.apache.camel.component.websocket.WebsocketConsumer;
import org.apache.camel.component.websocket.WebsocketEndpoint;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketComponentServlet
extends WebSocketServlet {
    public static final String UNSPECIFIED_SUBPROTOCOL = "default";
    public static final String ANY_SUBPROTOCOL = "any";
    private static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final NodeSynchronization sync;
    private WebsocketConsumer consumer;
    private String pathSpec;
    private ConcurrentMap<String, WebsocketConsumer> consumers = new ConcurrentHashMap<String, WebsocketConsumer>();
    private Map<String, WebSocketFactory> socketFactory;

    public WebsocketComponentServlet(NodeSynchronization sync, String pathSpec, Map<String, WebSocketFactory> socketFactory) {
        this.sync = sync;
        this.socketFactory = socketFactory;
        this.pathSpec = pathSpec;
    }

    public WebsocketConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(WebsocketConsumer consumer) {
        this.consumer = consumer;
    }

    public void connect(WebsocketConsumer consumer) {
        this.log.debug("Connecting consumer: {}", (Object)consumer);
        this.consumers.put(consumer.getPath(), consumer);
    }

    public void disconnect(WebsocketConsumer consumer) {
        this.log.debug("Disconnecting consumer: {}", (Object)consumer);
        this.consumers.remove(consumer.getPath());
    }

    public DefaultWebsocket doWebSocketConnect(ServletUpgradeRequest request, ServletUpgradeResponse resp) {
        String relativePath;
        WebSocketFactory factory;
        String subprotocol = this.negotiateSubprotocol(request, this.consumer);
        if (subprotocol == null) {
            return null;
        }
        if (this.socketFactory.containsKey(subprotocol)) {
            factory = this.socketFactory.get(subprotocol);
        } else {
            this.log.debug("No factory found for the socket subprotocol: {}, using default implementation", (Object)subprotocol);
            factory = this.socketFactory.get(UNSPECIFIED_SUBPROTOCOL);
        }
        if (subprotocol.equals(UNSPECIFIED_SUBPROTOCOL)) {
            subprotocol = null;
        } else {
            resp.setHeader("Sec-WebSocket-Protocol", subprotocol);
        }
        if (this.pathSpec != null && this.pathSpec.endsWith("*")) {
            String prefix = this.pathSpec.substring(0, this.pathSpec.length() - 1);
            String reqPath = request.getRequestPath();
            relativePath = reqPath.startsWith(prefix) && reqPath.length() > prefix.length() ? reqPath.substring(prefix.length()) : null;
        } else {
            relativePath = null;
        }
        return factory.newInstance(request, this.pathSpec, this.sync, this.consumer, subprotocol, relativePath);
    }

    private String negotiateSubprotocol(ServletUpgradeRequest request, WebsocketConsumer consumer) {
        String[] supportedSubprotocols = Optional.ofNullable(consumer).map(WebsocketConsumer::getEndpoint).map(WebsocketEndpoint::getSubprotocol).map(String::trim).filter(value -> !value.isEmpty()).map(subprotocols -> subprotocols.split(",")).orElse(new String[]{ANY_SUBPROTOCOL});
        List proposedSubprotocols = Optional.ofNullable(request.getHeaders("Sec-WebSocket-Protocol")).map(list -> list.stream().map(String::trim).filter(value -> !value.isEmpty()).map(header -> header.split(",")).map(array -> Arrays.stream(array).map(String::trim).filter(value -> !value.isEmpty()).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList())).orElse(Collections.emptyList());
        for (String s : supportedSubprotocols) {
            String supportedSubprotocol = s.trim();
            if (supportedSubprotocol.equalsIgnoreCase(ANY_SUBPROTOCOL)) {
                return UNSPECIFIED_SUBPROTOCOL;
            }
            if (!proposedSubprotocols.contains(supportedSubprotocol)) continue;
            return supportedSubprotocol;
        }
        this.log.debug("no agreeable subprotocol could be negotiated, server supports {} but client proposes {}", (Object)supportedSubprotocols, proposedSubprotocols);
        return null;
    }

    public Map<String, WebSocketFactory> getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(Map<String, WebSocketFactory> socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void configure(WebSocketServletFactory factory) {
        factory.setCreator(this::doWebSocketConnect);
    }
}

