/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xj;

import com.fasterxml.jackson.core.JsonFactory;
import org.apache.camel.Component;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.xj.JsonFileResultHandlerFactory;
import org.apache.camel.component.xj.JsonSourceHandlerFactoryImpl;
import org.apache.camel.component.xj.JsonStreamResultHandlerFactory;
import org.apache.camel.component.xj.JsonStringResultHandlerFactory;
import org.apache.camel.component.xj.TransformDirection;
import org.apache.camel.component.xslt.ResultHandlerFactory;
import org.apache.camel.component.xslt.SourceHandlerFactory;
import org.apache.camel.component.xslt.XsltBuilder;
import org.apache.camel.component.xslt.saxon.XsltSaxonBuilder;
import org.apache.camel.component.xslt.saxon.XsltSaxonEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed XJEndpoint")
@UriEndpoint(firstVersion="3.0.0", scheme="xj", title="XJ", syntax="xj:resourceUri", producerOnly=true, label="transformation")
public class XJEndpoint
extends XsltSaxonEndpoint {
    private final JsonFactory jsonFactory = new JsonFactory();
    @UriParam
    @Metadata(required=true, description="Transform direction. Either XML2JSON or JSON2XML")
    private TransformDirection transformDirection;

    public XJEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    @ManagedAttribute(description="Transform direction")
    public TransformDirection getTransformDirection() {
        return this.transformDirection;
    }

    public void setTransformDirection(TransformDirection transformDirection) {
        this.transformDirection = transformDirection;
    }

    protected void doStart() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.getResourceUri())) {
            this.setResourceUri("org/apache/camel/component/xj/identity.xsl");
        }
        super.doStart();
    }

    protected XsltSaxonBuilder createXsltBuilder() throws Exception {
        XsltSaxonBuilder xsltBuilder = super.createXsltBuilder();
        xsltBuilder.setAllowStAX(true);
        this.configureInput((XsltBuilder)xsltBuilder);
        return xsltBuilder;
    }

    protected void configureInput(XsltBuilder xsltBuilder) {
        if (TransformDirection.JSON2XML == this.transformDirection) {
            JsonSourceHandlerFactoryImpl sourceHandlerFactory = new JsonSourceHandlerFactoryImpl(this.jsonFactory);
            sourceHandlerFactory.setFailOnNullBody(this.isFailOnNullBody());
            xsltBuilder.setSourceHandlerFactory((SourceHandlerFactory)sourceHandlerFactory);
        }
    }

    protected void configureOutput(XsltBuilder xsltBuilder, String output) throws Exception {
        switch (this.transformDirection) {
            case JSON2XML: {
                super.configureOutput(xsltBuilder, output);
                break;
            }
            case XML2JSON: {
                this.configureJsonOutput(xsltBuilder, output);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown transformation direction: " + (Object)((Object)this.transformDirection));
            }
        }
    }

    protected void configureJsonOutput(XsltBuilder xsltBuilder, String output) {
        if ("DOM".equals(output)) {
            throw new UnsupportedOperationException("DOM output not supported when transforming to json");
        }
        if ("bytes".equals(output)) {
            xsltBuilder.setResultHandlerFactory((ResultHandlerFactory)new JsonStreamResultHandlerFactory(this.jsonFactory));
        } else if ("file".equals(output)) {
            xsltBuilder.setResultHandlerFactory((ResultHandlerFactory)new JsonFileResultHandlerFactory(this.jsonFactory));
        } else {
            xsltBuilder.setResultHandlerFactory((ResultHandlerFactory)new JsonStringResultHandlerFactory(this.jsonFactory));
        }
    }
}

