/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.xml.io;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.apache.camel.dsl.support.RouteBuilderLoaderSupport;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteConfigurationsDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.CachedResource;
import org.apache.camel.xml.in.ModelParser;

@ManagedResource(description="Managed XML RoutesBuilderLoader")
@RoutesLoader(value="xml")
public class XmlRoutesBuilderLoader
extends RouteBuilderLoaderSupport {
    public static final String EXTENSION = "xml";
    public static final String NAMESPACE = "http://camel.apache.org/schema/spring";
    private static final List<String> NAMESPACES = List.of("", "http://camel.apache.org/schema/spring");

    public XmlRoutesBuilderLoader() {
        super(EXTENSION);
    }

    public RouteBuilder doLoadRouteBuilder(final Resource input) throws Exception {
        return new RouteConfigurationBuilder(){
            final Resource resource;
            {
                this.resource = new CachedResource(input);
            }

            public void configure() throws Exception {
                for (String ns : NAMESPACES) {
                    new ModelParser(this.resource, ns).parseRouteTemplatesDefinition().ifPresent(arg_0 -> (this).setRouteTemplateCollection(arg_0));
                    new ModelParser(this.resource, ns).parseTemplatedRoutesDefinition().ifPresent(arg_0 -> (this).setTemplatedRouteCollection(arg_0));
                    new ModelParser(this.resource, ns).parseRestsDefinition().ifPresent(arg_0 -> (this).setRestCollection(arg_0));
                    new ModelParser(this.resource, ns).parseRoutesDefinition().ifPresent(this::addRoutes);
                }
            }

            public void configuration() throws Exception {
                for (String ns : NAMESPACES) {
                    new ModelParser(this.resource, ns).parseRouteConfigurationsDefinition().ifPresent(this::addConfigurations);
                }
            }

            private void addRoutes(RoutesDefinition routes) {
                CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                for (RouteDefinition route : routes.getRoutes()) {
                    this.getRouteCollection().route(route);
                }
            }

            private void addConfigurations(RouteConfigurationsDefinition configurations) {
                CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                for (RouteConfigurationDefinition config : configurations.getRouteConfigurations()) {
                    ((ModelCamelContext)this.getCamelContext()).addRouteConfiguration(config);
                }
            }
        };
    }
}

