/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.xml.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.apache.camel.dsl.support.RouteBuilderLoaderSupport;
import org.apache.camel.dsl.xml.io.XmlModelParser;
import org.apache.camel.model.BeanFactoryDefinition;
import org.apache.camel.model.BeanModelHelper;
import org.apache.camel.model.Model;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteConfigurationsDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.model.TemplatedRoutesDefinition;
import org.apache.camel.model.app.BeansDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.CachedResource;
import org.apache.camel.support.scan.PackageScanHelper;
import org.apache.camel.xml.io.util.XmlStreamDetector;
import org.apache.camel.xml.io.util.XmlStreamInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ManagedResource(description="Managed XML RoutesBuilderLoader")
@RoutesLoader(value="xml")
public class XmlRoutesBuilderLoader
extends RouteBuilderLoaderSupport {
    public static final Logger LOG = LoggerFactory.getLogger(XmlRoutesBuilderLoader.class);
    public static final String EXTENSION = "xml";
    private final Map<String, Boolean> preparseDone = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Resource> resourceCache = new ConcurrentHashMap<String, Resource>();
    private final Map<String, XmlStreamInfo> xmlInfoCache = new ConcurrentHashMap<String, XmlStreamInfo>();
    private final Map<String, BeansDefinition> camelAppCache = new ConcurrentHashMap<String, BeansDefinition>();
    private final List<BeanFactoryDefinition<?>> delayedRegistrations = new ArrayList();
    private final AtomicInteger counter = new AtomicInteger(0);

    public XmlRoutesBuilderLoader() {
        super(EXTENSION);
    }

    XmlRoutesBuilderLoader(String extension) {
        super(extension);
    }

    public void preParseRoute(Resource resource) throws Exception {
        String root;
        if (this.preparseDone.getOrDefault(resource.getLocation(), false).booleanValue()) {
            return;
        }
        XmlStreamInfo xmlInfo = this.xmlInfo(resource);
        if (xmlInfo.isValid() && ("beans".equals(root = xmlInfo.getRootElementName()) || "blueprint".equals(root) || "camel".equals(root))) {
            new XmlModelParser(resource, xmlInfo.getRootElementNamespace()).parseBeansDefinition().ifPresent(bd -> {
                this.registerBeans(resource, (BeansDefinition)bd);
                this.camelAppCache.put(resource.getLocation(), (BeansDefinition)bd);
            });
        }
        this.preparseDone.put(resource.getLocation(), true);
    }

    public RouteBuilder doLoadRouteBuilder(final Resource input) throws Exception {
        final Resource resource = this.resource(input);
        final XmlStreamInfo xmlInfo = this.xmlInfo(input);
        if (!xmlInfo.isValid()) {
            LOG.warn("Invalid XML document: {}", (Object)xmlInfo.getProblem().getMessage());
            return null;
        }
        return new RouteConfigurationBuilder(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void configure() throws Exception {
                String resourceLocation = input.getLocation();
                try {
                    switch (xmlInfo.getRootElementName()) {
                        case "beans": 
                        case "blueprint": 
                        case "camel": {
                            BeansDefinition def = XmlRoutesBuilderLoader.this.camelAppCache.get(resourceLocation);
                            if (def != null) {
                                this.configureCamel(def);
                                return;
                            }
                            new XmlModelParser(resource, xmlInfo.getRootElementNamespace()).parseBeansDefinition().ifPresent(this::configureCamel);
                            return;
                        }
                        case "routeTemplate": 
                        case "routeTemplates": {
                            new XmlModelParser(resource, xmlInfo.getRootElementNamespace()).parseRouteTemplatesDefinition().ifPresent(arg_0 -> (this).setRouteTemplateCollection(arg_0));
                            return;
                        }
                        case "templatedRoutes": 
                        case "templatedRoute": {
                            new XmlModelParser(resource, xmlInfo.getRootElementNamespace()).parseTemplatedRoutesDefinition().ifPresent(arg_0 -> (this).setTemplatedRouteCollection(arg_0));
                            return;
                        }
                        case "rests": 
                        case "rest": {
                            new XmlModelParser(resource, xmlInfo.getRootElementNamespace()).parseRestsDefinition().ifPresent(arg_0 -> (this).setRestCollection(arg_0));
                            return;
                        }
                        case "routes": 
                        case "route": {
                            new XmlModelParser(resource, xmlInfo.getRootElementNamespace()).parseRoutesDefinition().ifPresent(this::addRoutes);
                            return;
                        }
                    }
                    return;
                }
                finally {
                    XmlRoutesBuilderLoader.this.resourceCache.remove(resourceLocation);
                    XmlRoutesBuilderLoader.this.xmlInfoCache.remove(resourceLocation);
                    XmlRoutesBuilderLoader.this.camelAppCache.remove(resourceLocation);
                    XmlRoutesBuilderLoader.this.preparseDone.remove(resourceLocation);
                }
            }

            public void configuration() throws Exception {
                switch (xmlInfo.getRootElementName()) {
                    case "beans": 
                    case "blueprint": 
                    case "camel": 
                    case "routeConfigurations": 
                    case "routeConfiguration": {
                        BeansDefinition bp = XmlRoutesBuilderLoader.this.camelAppCache.get(input.getLocation());
                        if (bp != null) {
                            bp.getRouteConfigurations().forEach(rc -> {
                                rc.setResource(this.getResource());
                                ArrayList<RouteConfigurationDefinition> list = new ArrayList<RouteConfigurationDefinition>();
                                list.add((RouteConfigurationDefinition)rc);
                                RouteConfigurationsDefinition def = new RouteConfigurationsDefinition();
                                def.setResource(this.getResource());
                                def.setRouteConfigurations(list);
                                this.addConfigurations(def);
                            });
                            bp.getRouteConfigurations().clear();
                        }
                        new XmlModelParser(resource, xmlInfo.getRootElementNamespace()).parseRouteConfigurationsDefinition().ifPresent(this::addConfigurations);
                    }
                }
            }

            private void configureCamel(BeansDefinition app) {
                if (!XmlRoutesBuilderLoader.this.delayedRegistrations.isEmpty()) {
                    for (BeanFactoryDefinition<?> def : XmlRoutesBuilderLoader.this.delayedRegistrations) {
                        def.setResource(this.getResource());
                        XmlRoutesBuilderLoader.this.registerBeanDefinition(def, false);
                    }
                    XmlRoutesBuilderLoader.this.delayedRegistrations.clear();
                }
                if (app.getRestConfigurations().size() > 1) {
                    throw new RuntimeException("There should only be one <restConfiguration>");
                }
                if (app.getRestConfigurations().size() == 1) {
                    RestConfigurationDefinition config = (RestConfigurationDefinition)app.getRestConfigurations().get(0);
                    try {
                        config.asRestConfiguration(this.getCamelContext(), this.getCamelContext().getRestConfiguration());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                app.getRests().forEach(r -> {
                    r.setResource(this.getResource());
                    ArrayList<RestDefinition> list = new ArrayList<RestDefinition>();
                    list.add((RestDefinition)r);
                    RestsDefinition def = new RestsDefinition();
                    def.setResource(this.getResource());
                    def.setRests(list);
                    this.setRestCollection(def);
                });
                app.getRouteConfigurations().forEach(rc -> {
                    rc.setResource(this.getResource());
                    ArrayList<RouteConfigurationDefinition> list = new ArrayList<RouteConfigurationDefinition>();
                    list.add((RouteConfigurationDefinition)rc);
                    RouteConfigurationsDefinition def = new RouteConfigurationsDefinition();
                    def.setResource(this.getResource());
                    def.setRouteConfigurations(list);
                    this.addConfigurations(def);
                });
                app.getRouteTemplates().forEach(rt -> {
                    rt.setResource(this.getResource());
                    ArrayList<RouteTemplateDefinition> list = new ArrayList<RouteTemplateDefinition>();
                    list.add((RouteTemplateDefinition)rt);
                    RouteTemplatesDefinition def = new RouteTemplatesDefinition();
                    def.setResource(this.getResource());
                    def.setRouteTemplates(list);
                    this.setRouteTemplateCollection(def);
                });
                app.getTemplatedRoutes().forEach(tr -> {
                    tr.setResource(this.getResource());
                    ArrayList<TemplatedRouteDefinition> list = new ArrayList<TemplatedRouteDefinition>();
                    list.add((TemplatedRouteDefinition)tr);
                    TemplatedRoutesDefinition def = new TemplatedRoutesDefinition();
                    def.setResource(this.getResource());
                    def.setTemplatedRoutes(list);
                    this.setTemplatedRouteCollection(def);
                });
                app.getRoutes().forEach(r -> {
                    r.setResource(this.getResource());
                    ArrayList<RouteDefinition> list = new ArrayList<RouteDefinition>();
                    list.add((RouteDefinition)r);
                    RoutesDefinition def = new RoutesDefinition();
                    def.setResource(this.getResource());
                    def.setRoutes(list);
                    this.addRoutes(def);
                });
            }

            private void addRoutes(RoutesDefinition routes) {
                CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                for (RouteDefinition route : routes.getRoutes()) {
                    this.getRouteCollection().route(route);
                }
            }

            private void addConfigurations(RouteConfigurationsDefinition configurations) {
                CamelContextAware.trySetCamelContext((Object)configurations, (CamelContext)this.getCamelContext());
                for (RouteConfigurationDefinition config : configurations.getRouteConfigurations()) {
                    this.getRouteConfigurationCollection().routeConfiguration(config);
                }
            }
        };
    }

    private Resource resource(Resource resource) {
        return this.resourceCache.computeIfAbsent(resource.getLocation(), l -> new CachedResource(resource));
    }

    private XmlStreamInfo xmlInfo(Resource resource) {
        return this.xmlInfoCache.computeIfAbsent(resource.getLocation(), l -> {
            try {
                XmlStreamDetector detector = new XmlStreamDetector(resource.getInputStream());
                return detector.information();
            }
            catch (IOException e) {
                XmlStreamInfo invalid = new XmlStreamInfo();
                invalid.setProblem((Throwable)e);
                return invalid;
            }
        });
    }

    private void registerBeans(Resource resource, BeansDefinition app) {
        String id;
        Document doc;
        LinkedHashSet packagesToScan = new LinkedHashSet();
        app.getComponentScanning().forEach(cs -> packagesToScan.add(cs.getBasePackage()));
        PackageScanHelper.registerBeans((CamelContext)this.getCamelContext(), packagesToScan);
        for (BeanFactoryDefinition def : app.getBeans()) {
            def.setResource(resource);
            this.registerBeanDefinition(def, true);
        }
        if (!app.getSpringBeans().isEmpty()) {
            doc = ((Element)app.getSpringBeans().get(0)).getOwnerDocument();
            id = String.format("camel-xml-io-dsl-spring-xml:%05d:%s", this.counter.incrementAndGet(), resource.getLocation());
            this.getCamelContext().getRegistry().bind(id, (Object)doc);
        }
        if (!app.getBlueprintBeans().isEmpty()) {
            doc = ((Element)app.getBlueprintBeans().get(0)).getOwnerDocument();
            id = String.format("camel-xml-io-dsl-blueprint-xml:%05d:%s", this.counter.incrementAndGet(), resource.getLocation());
            this.getCamelContext().getRegistry().bind(id, (Object)doc);
        }
    }

    private void registerBeanDefinition(BeanFactoryDefinition<?> def, boolean delayIfFailed) {
        String name = def.getName();
        String type = def.getType();
        try {
            Object target = BeanModelHelper.newInstance(def, (CamelContext)this.getCamelContext());
            this.bindBean(def, name, target);
        }
        catch (Exception e) {
            if (delayIfFailed) {
                this.delayedRegistrations.add(def);
            }
            String msg = name != null ? "Error creating bean: " + name + " of type: " + type : "Error creating bean: " + type;
            throw new RuntimeException(msg, e);
        }
    }

    protected void bindBean(BeanFactoryDefinition<?> def, String name, Object target) throws Exception {
        this.getCamelContext().getRegistry().unbind(name);
        this.getCamelContext().getRegistry().bind(name, target, def.getInitMethod(), def.getDestroyMethod());
        Model model = (Model)this.getCamelContext().getCamelContextExtension().getContextPlugin(Model.class);
        model.addCustomBean(def);
    }
}

