/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.in;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.xml.io.MXParser;
import org.apache.camel.xml.io.XmlPullParser;
import org.apache.camel.xml.io.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseParser {
    private static final Logger LOG = LoggerFactory.getLogger(BaseParser.class);
    protected final MXParser parser = new MXParser();
    protected String namespace;

    public BaseParser(InputStream input) throws IOException, XmlPullParserException {
        this(input, null);
    }

    public BaseParser(Reader reader) throws IOException, XmlPullParserException {
        this(reader, null);
    }

    public BaseParser(InputStream input, String namespace) throws IOException, XmlPullParserException {
        this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        this.parser.setInput(input, null);
        this.namespace = namespace != null ? namespace : "";
    }

    public BaseParser(Reader reader, String namespace) throws IOException, XmlPullParserException {
        this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        this.parser.setInput(reader);
        this.namespace = namespace != null ? namespace : "";
    }

    protected <T> T doParse(T definition, AttributeHandler<T> attributeHandler, ElementHandler<T> elementHandler, ValueHandler<T> valueHandler) throws IOException, XmlPullParserException {
        int event;
        if (definition instanceof NamespaceAware) {
            LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
            for (int i = 0; i < this.parser.getNamespaceCount(this.parser.getDepth()); ++i) {
                String prefix = this.parser.getNamespacePrefix(i);
                if (prefix == null) continue;
                namespaces.put(prefix, this.parser.getNamespaceUri(i));
            }
            ((NamespaceAware)definition).setNamespaces(namespaces);
        }
        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
            String name = this.parser.getAttributeName(i);
            String ns = this.parser.getAttributeNamespace(i);
            String val = this.parser.getAttributeValue(i);
            if (Objects.equals(ns, "") || Objects.equals(ns, this.namespace)) {
                if (attributeHandler != null && attributeHandler.accept(definition, name, val)) continue;
                this.handleUnexpectedAttribute(this.namespace, name);
                continue;
            }
            this.handleOtherAttribute(definition, name, ns, val);
        }
        while (true) {
            if ((event = this.parser.next()) == 4) {
                if (this.parser.isWhitespace()) continue;
                valueHandler.accept(definition, this.parser.getText());
                continue;
            }
            if (event != 2) break;
            String ns = this.parser.getNamespace();
            String name = this.parser.getName();
            if (Objects.equals(ns, this.namespace)) {
                if (elementHandler != null && elementHandler.accept(definition, name)) continue;
                this.handleUnexpectedElement(this.namespace, name);
                continue;
            }
            this.handleUnexpectedElement(ns, name);
        }
        if (event == 3) {
            return definition;
        }
        throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[event], this.parser, null);
    }

    protected Class<?> asClass(String val) throws XmlPullParserException {
        try {
            return Class.forName(val);
        }
        catch (ClassNotFoundException e) {
            throw new XmlPullParserException("Unable to load class " + val, this.parser, e);
        }
    }

    protected Class<?>[] asClassArray(String val) throws XmlPullParserException {
        String[] vals = val.split(" ");
        Class[] cls = new Class[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            cls[i] = this.asClass(vals[i]);
        }
        return cls;
    }

    protected byte[] asByteArray(String val) {
        return Base64.getDecoder().decode(val);
    }

    protected List<String> asStringList(String val) {
        return new ArrayList<String>(Arrays.asList(val.split(" ")));
    }

    protected Set<String> asStringSet(String val) {
        return new LinkedHashSet<String>(Arrays.asList(val.split(" ")));
    }

    protected <T> void doAdd(T element, List<T> existing, Consumer<List<T>> setter) {
        if (existing == null) {
            existing = new ArrayList<T>();
            setter.accept(existing);
        }
        existing.add(element);
    }

    protected <T> void doAdd(T element, T[] existing, Consumer<T[]> setter) {
        int len = existing != null ? existing.length : 0;
        Object[] newArray = (Object[])Array.newInstance(element.getClass(), len + 1);
        if (len > 0) {
            System.arraycopy(existing, 0, newArray, 0, len);
        }
        newArray[len] = element;
        setter.accept(newArray);
    }

    protected String doParseText() throws IOException, XmlPullParserException {
        String s = "";
        int e = this.parser.next();
        if (e == 4) {
            s = this.parser.getText();
            e = this.parser.next();
        }
        if (e != 3) {
            throw new XmlPullParserException("Expected text element");
        }
        return s;
    }

    protected boolean handleUnexpectedAttribute(String namespace, String name) throws XmlPullParserException {
        throw new XmlPullParserException("Unexpected attribute '{" + namespace + "}" + name + "'");
    }

    protected boolean handleUnexpectedElement(String namespace, String name) throws XmlPullParserException {
        throw new XmlPullParserException("Unexpected element '{" + namespace + "}" + name + "'");
    }

    protected void handleUnexpectedText(String text) throws XmlPullParserException {
        throw new XmlPullParserException("Unexpected text '" + text + "'");
    }

    protected void expectTag(String name) throws XmlPullParserException, IOException {
        if (this.parser.nextTag() != 2) {
            throw new XmlPullParserException("Expected starting tag '{" + this.namespace + "}" + name + "', read ending tag '{" + this.parser.getNamespace() + "}" + this.parser.getName() + "' instead");
        }
        if (!Objects.equals(name, this.parser.getName()) || !Objects.equals(this.namespace, this.parser.getNamespace())) {
            throw new XmlPullParserException("Expected starting tag '{" + this.namespace + "}" + name + "', read starting tag '{" + this.parser.getNamespace() + "}" + this.parser.getName() + "' instead");
        }
    }

    protected boolean hasTag(String name) throws XmlPullParserException, IOException {
        if (this.parser.nextTag() != 2) {
            throw new XmlPullParserException("Expected starting tag");
        }
        return Objects.equals(name, this.parser.getName()) && Objects.equals(this.namespace, this.parser.getNamespace());
    }

    protected String getNextTag(String name, String name2) throws XmlPullParserException, IOException {
        boolean match;
        if (this.parser.nextTag() != 2) {
            throw new XmlPullParserException("Expected starting tag");
        }
        String pn = this.parser.getName();
        boolean bl = match = Objects.equals(name, pn) || Objects.equals(name2, pn);
        if (!match || !Objects.equals(this.namespace, this.parser.getNamespace())) {
            return "";
        }
        return pn;
    }

    protected void handleOtherAttribute(Object definition, String name, String ns, String val) throws XmlPullParserException {
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns)) {
            return;
        }
        String fqn = ns.isEmpty() ? name : "{" + ns + "}" + name;
        throw new XmlPullParserException("Unsupported attribute '" + fqn + "'");
    }

    protected <T> AttributeHandler<T> noAttributeHandler() {
        return null;
    }

    protected <T> ElementHandler<T> noElementHandler() {
        return (def, name) -> this.handleUnexpectedElement(this.namespace, name);
    }

    protected <T> ValueHandler<T> noValueHandler() {
        return (def, text) -> this.handleUnexpectedText(text);
    }

    protected <T extends ExpressionDefinition> ValueHandler<T> expressionDefinitionValueHandler() {
        return ExpressionDefinition::setExpression;
    }

    static interface ValueHandler<T> {
        public void accept(T var1, String var2) throws IOException, XmlPullParserException;
    }

    static interface ElementHandler<T> {
        public boolean accept(T var1, String var2) throws IOException, XmlPullParserException;
    }

    static interface AttributeHandler<T> {
        public boolean accept(T var1, String var2, String var3) throws IOException, XmlPullParserException;
    }
}

