/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.in;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.camel.LineNumberAware;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.spi.Resource;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.xml.io.MXParser;
import org.apache.camel.xml.io.XmlPullParser;
import org.apache.camel.xml.io.XmlPullParserException;
import org.apache.camel.xml.io.XmlPullParserLocationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class BaseParser {
    protected final MXParser parser;
    protected String namespace;
    protected final Set<String> secondaryNamespaces = new HashSet<String>();
    protected Resource resource;

    public BaseParser(Resource resource) throws IOException, XmlPullParserException {
        this(resource.getInputStream(), null);
        this.resource = resource;
    }

    public BaseParser(Resource resource, String namespace) throws IOException, XmlPullParserException {
        this(resource.getInputStream(), namespace);
        this.resource = resource;
    }

    public BaseParser(InputStream input) throws IOException, XmlPullParserException {
        this(input, null);
    }

    public BaseParser(Reader reader) throws IOException, XmlPullParserException {
        this(reader, null);
    }

    public BaseParser(InputStream input, String namespace) throws IOException, XmlPullParserException {
        this.parser = new MXParser();
        this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        this.parser.setInput(input, null);
        this.namespace = namespace != null ? namespace : "";
    }

    public BaseParser(Reader reader, String namespace) throws IOException, XmlPullParserException {
        this.parser = new MXParser();
        this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        this.parser.setInput(reader);
        this.namespace = namespace != null ? namespace : "";
    }

    public void addSecondaryNamespace(String namespace) {
        this.secondaryNamespaces.add(namespace);
    }

    protected <T> T doParse(T definition, AttributeHandler<T> attributeHandler, ElementHandler<T> elementHandler, ValueHandler<T> valueHandler) throws IOException, XmlPullParserException {
        return this.doParse(definition, attributeHandler, elementHandler, valueHandler, false);
    }

    protected <T> T doParse(T definition, AttributeHandler<T> attributeHandler, ElementHandler<T> elementHandler, ValueHandler<T> valueHandler, boolean supportsExternalNamespaces) throws IOException, XmlPullParserException {
        try {
            return this.doParseXml(definition, attributeHandler, elementHandler, valueHandler, supportsExternalNamespaces);
        }
        catch (Exception e) {
            if (e instanceof XmlPullParserLocationException) {
                throw e;
            }
            String msg = e.getMessage();
            Throwable cause = e;
            if (e instanceof XmlPullParserException && e.getCause() != null) {
                cause = e.getCause();
                msg = e.getCause().getMessage();
            }
            throw new XmlPullParserLocationException(msg, this.resource, this.parser.getLineNumber(), this.parser.getColumnNumber(), cause);
        }
    }

    protected <T> T doParseXml(T definition, AttributeHandler<T> attributeHandler, ElementHandler<T> elementHandler, ValueHandler<T> valueHandler, boolean supportsExternalNamespaces) throws IOException, XmlPullParserException {
        int event;
        block14: {
            if (definition instanceof LineNumberAware) {
                int line = this.parser.getStartLineNumber();
                if (line == -1) {
                    line = this.parser.getLineNumber();
                }
                ((LineNumberAware)definition).setLineNumber(line);
                if (this.resource != null) {
                    ((LineNumberAware)definition).setLocation(this.resource.getLocation());
                }
            }
            if (definition instanceof NamespaceAware) {
                LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
                for (int i = 0; i < this.parser.getNamespaceCount(this.parser.getDepth()); ++i) {
                    String prefix = this.parser.getNamespacePrefix(i);
                    if (prefix == null) continue;
                    namespaces.put(prefix, this.parser.getNamespaceUri(i));
                }
                ((NamespaceAware)definition).setNamespaces(namespaces);
            }
            for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                String name = this.parser.getAttributeName(i);
                String ns = this.parser.getAttributeNamespace(i);
                String val = this.parser.getAttributeValue(i);
                if (name.equals("uri") || name.endsWith("Uri")) {
                    val = URISupport.removeNoiseFromUri((String)val);
                }
                if (this.matchNamespace(ns, true)) {
                    if (attributeHandler != null && attributeHandler.accept(definition, name, val)) continue;
                    this.handleUnexpectedAttribute(ns, name);
                    continue;
                }
                this.handleOtherAttribute(definition, name, ns, val);
            }
            while (true) {
                String name;
                if ((event = this.parser.next()) == 4) {
                    if (this.parser.isWhitespace()) continue;
                    valueHandler.accept(definition, this.parser.getText());
                    continue;
                }
                if (event == 2) {
                    String ns = this.parser.getNamespace();
                    name = this.parser.getName();
                    if (supportsExternalNamespaces) {
                        if (elementHandler != null && elementHandler.accept(definition, name)) continue;
                        this.handleUnexpectedElement(ns, name);
                        continue;
                    }
                    if (this.matchNamespace(ns, false)) {
                        if (elementHandler != null && elementHandler.accept(definition, name)) continue;
                        this.handleUnexpectedElement(this.namespace, name);
                        continue;
                    }
                    this.handleUnexpectedElement(ns, name);
                    continue;
                }
                if (event != 3) break block14;
                String ns = this.parser.getNamespace();
                name = this.parser.getName();
                boolean ignore = false;
                if (supportsExternalNamespaces) {
                    ignore = this.ignoreUnexpectedElement(ns, name);
                }
                if (!ignore) break;
            }
            return definition;
        }
        throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[event], this.parser, null);
    }

    protected <T> List<T> doParseValue(Supplier<T> definitionSupplier, ValueHandler<T> valueHandler) throws IOException, XmlPullParserException {
        int event;
        block7: {
            ArrayList<T> answer = new ArrayList<T>();
            while (true) {
                String ns;
                if ((event = this.parser.next()) == 4) {
                    if (this.parser.isWhitespace()) continue;
                    T definition = definitionSupplier.get();
                    if (definition instanceof LineNumberAware) {
                        int line = this.parser.getStartLineNumber();
                        if (line == -1) {
                            line = this.parser.getLineNumber();
                        }
                        ((LineNumberAware)definition).setLineNumber(line);
                        if (this.resource != null) {
                            ((LineNumberAware)definition).setLocation(this.resource.getLocation());
                        }
                    }
                    valueHandler.accept(definition, this.parser.getText());
                    answer.add(definition);
                    continue;
                }
                if (event == 2) {
                    ns = this.parser.getNamespace();
                    String name = this.parser.getName();
                    if (this.matchNamespace(ns, false)) {
                        if ("value".equals(name)) continue;
                        this.handleUnexpectedElement(ns, name);
                        continue;
                    }
                    this.handleUnexpectedElement(ns, name);
                    continue;
                }
                if (event != 3) break block7;
                ns = this.parser.getNamespace();
                String name = this.parser.getName();
                if (!this.matchNamespace(ns, false) || !"value".equals(name)) break;
            }
            return answer;
        }
        throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[event], this.parser, null);
    }

    protected Class<?> asClass(String val) throws XmlPullParserException {
        try {
            return Class.forName(val);
        }
        catch (ClassNotFoundException e) {
            throw new XmlPullParserException("Unable to load class " + val, this.parser, e);
        }
    }

    protected Class<?>[] asClassArray(String val) throws XmlPullParserException {
        String[] vals = val.split(" ");
        Class[] cls = new Class[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            cls[i] = this.asClass(vals[i]);
        }
        return cls;
    }

    protected byte[] asByteArray(String val) {
        return Base64.getDecoder().decode(val);
    }

    protected List<String> asStringList(String val) {
        return new ArrayList<String>(Arrays.asList(val.split(" ")));
    }

    protected Set<String> asStringSet(String val) {
        return new LinkedHashSet<String>(Arrays.asList(val.split(" ")));
    }

    protected <T> void doAdd(T element, List<T> existing, Consumer<List<T>> setter) {
        if (existing == null) {
            existing = new ArrayList<T>();
            setter.accept(existing);
        }
        existing.add(element);
    }

    protected <T> void doAddValues(List<T> elements, List<T> existing, Consumer<List<T>> setter) {
        if (existing == null) {
            existing = new ArrayList<T>();
            setter.accept(existing);
        }
        existing.addAll(elements);
    }

    protected String doParseText() throws IOException, XmlPullParserException {
        String s = "";
        int e = this.parser.next();
        if (e == 4) {
            s = this.parser.getText();
            e = this.parser.next();
        }
        if (e != 3) {
            throw new XmlPullParserException("Expected text element");
        }
        return s;
    }

    protected Element doParseDOMElement(String rootElementName, String namespace, List<Element> existing) throws XmlPullParserException, IOException {
        Document doc = null;
        if (existing != null && !existing.isEmpty()) {
            doc = existing.get(0).getOwnerDocument();
        } else {
            try {
                doc = BaseParser.createDocumentBuilderFactory().newDocumentBuilder().newDocument();
                Element rootElement = doc.createElementNS(namespace, rootElementName);
                doc.appendChild(rootElement);
            }
            catch (ParserConfigurationException e) {
                throw new XmlPullParserException("Problem handling external element '{" + namespace + "}" + this.parser.getName() + ": " + e.getMessage());
            }
        }
        if (doc == null) {
            return null;
        }
        Element element = doc.createElementNS(namespace, this.parser.getName());
        doc.getDocumentElement().appendChild(element);
        this.doParse(element, this.domAttributeHandler(), this.domElementHandler(), this.domValueHandler(), true);
        return element;
    }

    protected void doAddElement(Element element, List<Element> existing, Consumer<List<Element>> setter) {
        if (existing == null) {
            existing = new ArrayList<Element>();
            setter.accept(existing);
        }
        existing.add(element);
    }

    protected boolean handleUnexpectedAttribute(String namespace, String name) throws XmlPullParserException {
        throw new XmlPullParserException("Unexpected attribute '{" + namespace + "}" + name + "'");
    }

    protected boolean handleUnexpectedElement(String namespace, String name) throws XmlPullParserException {
        throw new XmlPullParserException("Unexpected element '{" + namespace + "}" + name + "'");
    }

    protected void handleUnexpectedText(String text) throws XmlPullParserException {
        throw new XmlPullParserException("Unexpected text '" + text + "'");
    }

    protected boolean ignoreUnexpectedElement(String namespace, String name) throws XmlPullParserException {
        return false;
    }

    protected void expectTag(String name) throws XmlPullParserException, IOException {
        if (this.parser.nextTag() != 2) {
            throw new XmlPullParserException("Expected starting tag '{" + this.namespace + "}" + name + "', read ending tag '{" + this.parser.getNamespace() + "}" + this.parser.getName() + "' instead");
        }
        if (!Objects.equals(name, this.parser.getName()) || !Objects.equals(this.namespace, this.parser.getNamespace())) {
            throw new XmlPullParserException("Expected starting tag '{" + this.namespace + "}" + name + "', read starting tag '{" + this.parser.getNamespace() + "}" + this.parser.getName() + "' instead");
        }
    }

    protected boolean hasTag(String name) throws XmlPullParserException, IOException {
        if (this.parser.nextTag() != 2) {
            throw new XmlPullParserException("Expected starting tag");
        }
        return Objects.equals(name, this.parser.getName()) && BaseParser.matchNamespace(this.namespace, this.parser.getNamespace(), null, false);
    }

    protected String getNextTag(String name, String name2) throws XmlPullParserException, IOException {
        boolean match;
        if (this.parser.nextTag() != 2) {
            throw new XmlPullParserException("Expected starting tag");
        }
        String pn = this.parser.getName();
        boolean bl = match = Objects.equals(name, pn) || Objects.equals(name2, pn);
        if (!match || !BaseParser.matchNamespace(this.namespace, this.parser.getNamespace(), null, false)) {
            return "";
        }
        return pn;
    }

    protected String getNextTag(String name, String name2, String name3) throws XmlPullParserException, IOException {
        boolean match;
        if (this.parser.nextTag() != 2) {
            throw new XmlPullParserException("Expected starting tag");
        }
        String pn = this.parser.getName();
        boolean bl = match = Objects.equals(name, pn) || Objects.equals(name2, pn) || Objects.equals(name3, pn);
        if (!match || !BaseParser.matchNamespace(this.namespace, this.parser.getNamespace(), null, false)) {
            return "";
        }
        return pn;
    }

    protected void handleOtherAttribute(Object definition, String name, String ns, String val) throws XmlPullParserException {
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns)) {
            return;
        }
        String fqn = ns.isEmpty() ? name : "{" + ns + "}" + name;
        throw new XmlPullParserException("Unsupported attribute '" + fqn + "'");
    }

    protected <T> AttributeHandler<T> noAttributeHandler() {
        return null;
    }

    protected <T> ElementHandler<T> noElementHandler() {
        return (def, name) -> this.handleUnexpectedElement(this.namespace, name);
    }

    protected <T> ValueHandler<T> noValueHandler() {
        return (def, text) -> this.handleUnexpectedText(text);
    }

    protected AttributeHandler<Element> domAttributeHandler() {
        return (el, name, value) -> {
            el.setAttributeNS(null, name, value);
            return true;
        };
    }

    protected ElementHandler<Element> domElementHandler() {
        return (def, name) -> {
            Element child = def.getOwnerDocument().createElementNS(this.parser.getNamespace(), name);
            def.appendChild(child);
            this.doParse(child, this.domAttributeHandler(), this.domElementHandler(), this.domValueHandler(), true);
            return true;
        };
    }

    protected ValueHandler<Element> domValueHandler() {
        return (def, text) -> {
            Text txt = def.getOwnerDocument().createTextNode(text);
            def.appendChild(txt);
        };
    }

    protected <T extends ExpressionDefinition> ValueHandler<T> expressionDefinitionValueHandler() {
        return ExpressionDefinition::setExpression;
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            Class smClass = ObjectHelper.loadClass((String)"org.apache.xerces.util.SecurityManager");
            if (smClass != null) {
                Object sm = smClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                factory.setAttribute("http://apache.org/xml/properties/security-manager", sm);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return factory;
    }

    protected boolean matchNamespace(String ns, boolean optional) {
        return BaseParser.matchNamespace(ns, this.namespace, this.secondaryNamespaces, optional);
    }

    protected static boolean matchNamespace(String ns, String namespace, Set<String> secondaryNamespaces, boolean optional) {
        if (optional && ns.isEmpty()) {
            return true;
        }
        if (Objects.equals(ns, namespace)) {
            return true;
        }
        for (String second : secondaryNamespaces) {
            if (!Objects.equals(ns, second)) continue;
            return true;
        }
        return false;
    }

    static interface AttributeHandler<T> {
        public boolean accept(T var1, String var2, String var3) throws IOException, XmlPullParserException;
    }

    static interface ElementHandler<T> {
        public boolean accept(T var1, String var2) throws IOException, XmlPullParserException;
    }

    static interface ValueHandler<T> {
        public void accept(T var1, String var2) throws IOException, XmlPullParserException;
    }
}

