/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.xml.jaxb;

import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.apache.camel.dsl.support.RouteBuilderLoaderSupport;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteConfigurationsDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.TemplatedRoutesDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.xml.jaxb.JaxbHelper;

@ManagedResource(description="Managed JAXB XML RoutesBuilderLoader")
@RoutesLoader(value="xml")
public class JaxbXmlRoutesBuilderLoader
extends RouteBuilderLoaderSupport {
    public static final String EXTENSION = "xml";

    public JaxbXmlRoutesBuilderLoader() {
        super(EXTENSION);
    }

    JaxbXmlRoutesBuilderLoader(String extension) {
        super(extension);
    }

    public RouteBuilder doLoadRouteBuilder(final Resource resource) throws Exception {
        return new RouteConfigurationBuilder(){

            public void configure() throws Exception {
                RouteTemplatesDefinition templates;
                try (InputStream is = JaxbXmlRoutesBuilderLoader.this.resourceInputStream(resource);){
                    templates = JaxbHelper.loadRouteTemplatesDefinition((CamelContext)this.getCamelContext(), (InputStream)is);
                    if (templates != null) {
                        this.setRouteTemplateCollection(templates);
                    }
                }
                is = JaxbXmlRoutesBuilderLoader.this.resourceInputStream(resource);
                try {
                    templates = JaxbHelper.loadTemplatedRoutesDefinition((CamelContext)this.getCamelContext(), (InputStream)is);
                    if (templates != null) {
                        this.setTemplatedRouteCollection((TemplatedRoutesDefinition)templates);
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
                is = JaxbXmlRoutesBuilderLoader.this.resourceInputStream(resource);
                try {
                    RestsDefinition rests = JaxbHelper.loadRestsDefinition((CamelContext)this.getCamelContext(), (InputStream)is);
                    if (rests != null) {
                        this.setRestCollection(rests);
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
                is = JaxbXmlRoutesBuilderLoader.this.resourceInputStream(resource);
                try {
                    RoutesDefinition routes = JaxbHelper.loadRoutesDefinition((CamelContext)this.getCamelContext(), (InputStream)is);
                    if (routes != null) {
                        for (RouteDefinition route : routes.getRoutes()) {
                            CamelContextAware.trySetCamelContext((Object)route, (CamelContext)this.getCamelContext());
                            this.getRouteCollection().route(route);
                        }
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }

            public void configuration() throws Exception {
                try (InputStream is = JaxbXmlRoutesBuilderLoader.this.resourceInputStream(resource);){
                    RouteConfigurationsDefinition configurations = JaxbHelper.loadRouteConfigurationsDefinition((CamelContext)this.getCamelContext(), (InputStream)is);
                    if (configurations != null) {
                        for (RouteConfigurationDefinition config : configurations.getRouteConfigurations()) {
                            CamelContextAware.trySetCamelContext((Object)config, (CamelContext)this.getCamelContext());
                            this.getRouteConfigurationCollection().routeConfiguration(config);
                        }
                    }
                }
            }
        };
    }
}

