/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.xml.jaxb;

import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.StartupStep;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.RoutesBuilderLoaderSupport;
import org.apache.camel.xml.jaxb.JaxbHelper;

@ManagedResource(description="Managed JAXB XML RoutesBuilderLoader")
@RoutesLoader(value="xml")
public class JaxbXmlRoutesBuilderLoader
extends RoutesBuilderLoaderSupport {
    public static final String EXTENSION = "xml";
    private StartupStepRecorder recorder;

    protected void doBuild() throws Exception {
        super.doBuild();
        this.recorder = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getStartupStepRecorder();
    }

    @ManagedAttribute(description="Supported file extension")
    public String getSupportedExtension() {
        return EXTENSION;
    }

    public RoutesBuilder loadRoutesBuilder(final Resource resource) throws Exception {
        return new RouteBuilder(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void configure() throws Exception {
                StartupStep step = JaxbXmlRoutesBuilderLoader.this.recorder != null ? JaxbXmlRoutesBuilderLoader.this.recorder.beginStep(JaxbXmlRoutesBuilderLoader.class, resource.getLocation(), "Loading and Parsing XML routes") : null;
                try {
                    try (InputStream is = resource.getInputStream();){
                        RouteTemplatesDefinition templates = JaxbHelper.loadRouteTemplatesDefinition((CamelContext)JaxbXmlRoutesBuilderLoader.this.getCamelContext(), (InputStream)is);
                        if (templates != null) {
                            this.setRouteTemplateCollection(templates);
                        }
                    }
                    is = resource.getInputStream();
                    var3_3 = null;
                    try {
                        RestsDefinition rests = JaxbHelper.loadRestsDefinition((CamelContext)JaxbXmlRoutesBuilderLoader.this.getCamelContext(), (InputStream)is);
                        if (rests != null) {
                            this.setRestCollection(rests);
                        }
                    }
                    catch (Throwable rests) {
                        var3_3 = rests;
                        throw rests;
                    }
                    finally {
                        if (is != null) {
                            if (var3_3 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable rests) {
                                    var3_3.addSuppressed(rests);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                    is = resource.getInputStream();
                    var3_3 = null;
                    try {
                        RoutesDefinition routes = JaxbHelper.loadRoutesDefinition((CamelContext)JaxbXmlRoutesBuilderLoader.this.getCamelContext(), (InputStream)is);
                        if (routes != null) {
                            this.setRouteCollection(routes);
                        }
                    }
                    catch (Throwable throwable) {
                        var3_3 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            if (var3_3 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    var3_3.addSuppressed(throwable);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                finally {
                    if (JaxbXmlRoutesBuilderLoader.this.recorder != null) {
                        JaxbXmlRoutesBuilderLoader.this.recorder.endStep(step);
                    }
                }
            }
        };
    }
}

