/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.transform.TransformerException;
import org.apache.camel.CamelContext;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.NamedNode;
import org.apache.camel.TypeConversionException;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.xml.XmlLineNumberParser;
import org.apache.camel.xml.jaxb.JaxbHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@JdkService(value="modelxml-dumper")
public class JaxbModelToXMLDumper
implements ModelToXMLDumper {
    public String dumpModelAsXml(CamelContext context, NamedNode definition) throws Exception {
        Document dom;
        JAXBContext jaxbContext = JaxbHelper.getJAXBContext(context);
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        HashMap<String, KeyValueHolder<Integer, String>> locations = new HashMap<String, KeyValueHolder<Integer, String>>();
        if (definition instanceof RouteTemplatesDefinition) {
            List templates = ((RouteTemplatesDefinition)definition).getRouteTemplates();
            for (RouteTemplateDefinition route : templates) {
                JaxbHelper.extractNamespaces(route.getRoute(), namespaces);
                if (context.isDebugging().booleanValue()) {
                    JaxbHelper.extractSourceLocations(route.getRoute(), locations);
                }
                JaxbHelper.resolveEndpointDslUris(route.getRoute());
            }
        } else if (definition instanceof RouteTemplateDefinition) {
            RouteTemplateDefinition template = (RouteTemplateDefinition)definition;
            JaxbHelper.extractNamespaces(template.getRoute(), namespaces);
            if (context.isDebugging().booleanValue()) {
                JaxbHelper.extractSourceLocations(template.getRoute(), locations);
            }
            JaxbHelper.resolveEndpointDslUris(template.getRoute());
        } else if (definition instanceof RoutesDefinition) {
            List routes = ((RoutesDefinition)definition).getRoutes();
            for (RouteTemplateDefinition route : routes) {
                JaxbHelper.extractNamespaces((RouteDefinition)route, namespaces);
                if (context.isDebugging().booleanValue()) {
                    JaxbHelper.extractSourceLocations((RouteDefinition)route, locations);
                }
                JaxbHelper.resolveEndpointDslUris((RouteDefinition)route);
            }
        } else if (definition instanceof RouteDefinition) {
            RouteDefinition route = (RouteDefinition)definition;
            JaxbHelper.extractNamespaces(route, namespaces);
            if (context.isDebugging().booleanValue()) {
                JaxbHelper.extractSourceLocations(route, locations);
            }
            JaxbHelper.resolveEndpointDslUris(route);
        }
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        StringWriter buffer = new StringWriter();
        marshaller.marshal((Object)definition, (Writer)buffer);
        XmlConverter xmlConverter = JaxbHelper.newXmlConverter(context);
        String xml = buffer.toString();
        try {
            dom = xmlConverter.toDOMDocument(xml, null);
        }
        catch (Exception e) {
            throw new TypeConversionException((Object)xml, Document.class, (Throwable)e);
        }
        JaxbModelToXMLDumper.sanitizeXml(dom);
        if (context.isDebugging().booleanValue()) {
            JaxbModelToXMLDumper.enrichLocations(dom, locations);
        }
        Element documentElement = dom.getDocumentElement();
        for (Map.Entry entry : namespaces.entrySet()) {
            String nsPrefix = (String)entry.getKey();
            Object prefix = nsPrefix.equals("xmlns") ? nsPrefix : "xmlns:" + nsPrefix;
            documentElement.setAttribute((String)prefix, (String)entry.getValue());
        }
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        outputProperties.put("encoding", "UTF-8");
        try {
            return xmlConverter.toStringFromDocument(dom, outputProperties);
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Failed converting document object to string", e);
        }
    }

    public String dumpModelAsXml(final CamelContext context, final NamedNode definition, final boolean resolvePlaceholders, final boolean resolveDelegateEndpoints) throws Exception {
        String xml = this.dumpModelAsXml(context, definition);
        if (resolvePlaceholders || resolveDelegateEndpoints) {
            final AtomicBoolean changed = new AtomicBoolean();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
            Document dom = XmlLineNumberParser.parseXml((InputStream)is, (XmlLineNumberParser.XmlTextTransformer)new XmlLineNumberParser.XmlTextTransformer(){
                private String prev;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public String transform(String text) {
                    String after = text;
                    if (resolveDelegateEndpoints && "uri".equals(this.prev)) {
                        try {
                            String uri = context.resolvePropertyPlaceholders(text);
                            Endpoint endpoint = context.hasEndpoint(uri);
                            if (endpoint instanceof DelegateEndpoint) {
                                endpoint = ((DelegateEndpoint)endpoint).getEndpoint();
                                after = endpoint.getEndpointUri();
                            }
                        }
                        catch (Exception uri) {
                            // empty catch block
                        }
                    }
                    if (resolvePlaceholders) {
                        PropertiesComponent pc = context.getPropertiesComponent();
                        Properties prop = new Properties();
                        Iterator it = null;
                        if (definition instanceof RouteDefinition) {
                            it = ObjectHelper.createIterator((Object)definition);
                        } else if (definition instanceof RoutesDefinition) {
                            it = ObjectHelper.createIterator((Object)((RoutesDefinition)definition).getRoutes());
                        }
                        while (it != null && it.hasNext()) {
                            RouteDefinition routeDefinition = (RouteDefinition)it.next();
                            if (routeDefinition.isTemplate() == null || !routeDefinition.isTemplate().booleanValue() || routeDefinition.getTemplateParameters() == null) continue;
                            prop.putAll((Map<?, ?>)routeDefinition.getTemplateParameters());
                        }
                        pc.setLocalProperties(prop);
                        try {
                            after = context.resolvePropertyPlaceholders(after);
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            pc.setLocalProperties(null);
                        }
                    }
                    if (!changed.get()) {
                        changed.set(!text.equals(after));
                    }
                    this.prev = text;
                    return after;
                }
            });
            if (changed.get()) {
                xml = (String)context.getTypeConverter().mandatoryConvertTo(String.class, (Object)dom);
                NamedNode copy = JaxbHelper.modelToXml(context, xml, NamedNode.class);
                xml = PluginHelper.getModelToXMLDumper((CamelContext)context).dumpModelAsXml(context, copy);
            }
        }
        return xml;
    }

    private static void sanitizeXml(Node node) {
        Node att;
        if (node.hasAttributes() && (att = node.getAttributes().getNamedItem("customId")) != null && "false".equals(att.getNodeValue())) {
            node.getAttributes().removeNamedItem("customId");
        }
        if (node.hasChildNodes()) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node child = node.getChildNodes().item(i);
                JaxbModelToXMLDumper.sanitizeXml(child);
            }
        }
    }

    private static void enrichLocations(Node node, Map<String, KeyValueHolder<Integer, String>> locations) {
        if (node instanceof Element) {
            KeyValueHolder<Integer, String> loc;
            Node parent;
            Element el = (Element)node;
            String id = el.getAttribute("id");
            if ("from".equals(el.getNodeName()) && (parent = el.getParentNode()) instanceof Element) {
                id = ((Element)parent).getAttribute("id");
            }
            if (id != null && (loc = locations.get(id)) != null) {
                el.setAttribute("sourceLineNumber", ((Integer)loc.getKey()).toString());
                el.setAttribute("sourceLocation", (String)loc.getValue());
            }
        }
        if (node.hasChildNodes()) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node child = node.getChildNodes().item(i);
                JaxbModelToXMLDumper.enrichLocations(child, locations);
            }
        }
    }
}

