/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.annotations.JdkService;

@JdkService(value="model-jaxbcontext-factory")
public class DefaultModelJAXBContextFactory
implements ModelJAXBContextFactory {
    private final Lock lock = new ReentrantLock();
    private volatile JAXBContext context;

    public JAXBContext newJAXBContext() throws JAXBException {
        if (this.context == null) {
            this.lock.lock();
            try {
                if (this.context == null) {
                    this.context = JAXBContext.newInstance((String)this.getPackages(), (ClassLoader)this.getClassLoader());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.context;
    }

    protected String getPackages() {
        return "org.apache.camel:org.apache.camel.model:org.apache.camel.model.app:org.apache.camel.model.cloud:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.errorhandler:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.model.rest:org.apache.camel.model.transformer:org.apache.camel.model.validator";
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }
}

