/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.xtokenizer;

import java.io.CharArrayWriter;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

class RecordableReader
extends FilterReader {
    private TrimmableCharArrayWriter buf = new TrimmableCharArrayWriter();
    private boolean recording = true;

    RecordableReader(Reader in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c > 0 && this.recording) {
            this.buf.write(c);
        }
        return c;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int n = super.read(cbuf, off, len);
        if (n > 0 && this.recording) {
            this.buf.write(cbuf, off, n);
        }
        return n;
    }

    public String getText(int pos) {
        this.recording = false;
        String t = new String(this.buf.getCharArray(), 0, pos);
        this.buf.trim(pos, 0);
        return t;
    }

    public char[] getChars(int pos) {
        this.recording = false;
        char[] b = this.buf.toCharArray(pos);
        this.buf.trim(pos, 0);
        return b;
    }

    public void record() {
        this.recording = true;
    }

    int size() {
        return this.buf.size();
    }

    private static class TrimmableCharArrayWriter
    extends CharArrayWriter {
        private TrimmableCharArrayWriter() {
        }

        public void trim(int head, int tail) {
            System.arraycopy(this.buf, head, this.buf, 0, this.count - head - tail);
            this.count -= head + tail;
        }

        public char[] toCharArray(int len) {
            char[] b = new char[len];
            System.arraycopy(this.buf, 0, b, 0, len);
            return b;
        }

        char[] getCharArray() {
            return this.buf;
        }
    }
}

