/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt.saxon;

import java.io.Writer;
import java.util.Properties;
import java.util.function.Consumer;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import net.sf.saxon.jaxp.TemplatesImpl;
import net.sf.saxon.jaxp.TransformerImpl;
import net.sf.saxon.lib.StandardMessageHandler;
import net.sf.saxon.str.UnicodeWriter;
import net.sf.saxon.str.UnicodeWriterToWriter;
import org.apache.camel.component.xslt.XmlSourceHandlerFactoryImpl;
import org.apache.camel.component.xslt.XsltBuilder;
import org.apache.camel.component.xslt.XsltMessageLogger;
import org.apache.camel.component.xslt.saxon.SaxonXmlSourceHandlerFactoryImpl;
import org.apache.camel.support.builder.xml.StAX2SAXSource;

public class XsltSaxonBuilder
extends XsltBuilder {
    private boolean allowStAX = true;

    protected Source prepareSource(Source source) {
        if (!this.isAllowStAX() && source instanceof StAXSource) {
            source = new StAX2SAXSource(((StAXSource)source).getXMLStreamReader());
        }
        return source;
    }

    public boolean isAllowStAX() {
        return this.allowStAX;
    }

    public void setAllowStAX(boolean allowStAX) {
        this.allowStAX = allowStAX;
    }

    protected XmlSourceHandlerFactoryImpl createXmlSourceHandlerFactoryImpl() {
        return new SaxonXmlSourceHandlerFactoryImpl();
    }

    protected Templates createTemplates(TransformerFactory factory, Source source) throws TransformerConfigurationException {
        Templates templates = super.createTemplates(factory, source);
        if (templates instanceof TemplatesImpl && this.getXsltMessageLogger() != null) {
            return new MessageDelegatingTemplates((TemplatesImpl)templates, this.getXsltMessageLogger());
        }
        return templates;
    }

    static class MessageDelegatingTemplates
    implements Templates {
        private final TemplatesImpl delegated;
        private final XsltMessageLogger xsltMessageLogger;

        MessageDelegatingTemplates(TemplatesImpl templates, XsltMessageLogger xsltMessageLogger) {
            this.delegated = templates;
            this.xsltMessageLogger = xsltMessageLogger;
        }

        @Override
        public Transformer newTransformer() throws TransformerConfigurationException {
            TransformerImpl transformer = (TransformerImpl)this.delegated.newTransformer();
            StandardMessageHandler standardMessageHandler = new StandardMessageHandler(transformer.getConfiguration());
            UnicodeWriterToWriter writer = new UnicodeWriterToWriter((Writer)new MessageConsumerWriter(this.xsltMessageLogger));
            standardMessageHandler.setUnicodeWriter((UnicodeWriter)writer);
            transformer.getUnderlyingXsltTransformer().setMessageHandler((Consumer)standardMessageHandler);
            return transformer;
        }

        @Override
        public Properties getOutputProperties() {
            return this.delegated.getOutputProperties();
        }
    }

    private static class MessageConsumerWriter
    extends Writer {
        private final XsltMessageLogger xsltMessageLogger;

        public MessageConsumerWriter(XsltMessageLogger xsltMessageLogger) {
            this.xsltMessageLogger = xsltMessageLogger;
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            if (len > 0) {
                this.xsltMessageLogger.accept(String.copyValueOf(cbuf, off, len));
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            this.flush();
        }
    }
}

