/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltUriResolver
implements URIResolver {
    private static final Logger LOG = LoggerFactory.getLogger(XsltUriResolver.class);
    private final CamelContext context;
    private final String location;
    private final String baseScheme;

    public XsltUriResolver(CamelContext context, String location) {
        this.context = context;
        this.location = location;
        this.baseScheme = ResourceHelper.hasScheme((String)location) ? ResourceHelper.getScheme((String)location) : "classpath:";
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        if (ObjectHelper.isEmpty((Object)href)) {
            href = this.location;
        }
        if (ObjectHelper.isEmpty((Object)href)) {
            throw new TransformerException("include href is empty");
        }
        LOG.trace("Resolving URI with href: {} and base: {}", href, (Object)base);
        String scheme = ResourceHelper.getScheme((String)href);
        if (scheme != null) {
            InputStream is;
            String hrefPath = StringHelper.after((String)href, (String)scheme);
            if ("file:".equals(scheme)) {
                href = scheme + FileUtil.compactPath((String)hrefPath);
            } else if ("classpath:".equals(scheme)) {
                href = scheme + FileUtil.compactPath((String)hrefPath, (char)'/');
            }
            LOG.debug("Resolving URI from {}: {}", (Object)scheme, href);
            try {
                is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.context, (String)href);
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
            return new StreamSource(is, (String)href);
        }
        if (((String)href).equals(this.location)) {
            String path = this.baseScheme + (String)href;
            return this.resolve(path, base);
        }
        Object path = FileUtil.onlyPath((String)base);
        if (ObjectHelper.isEmpty((Object)path)) {
            path = this.baseScheme + (String)href;
            return this.resolve((String)path, base);
        }
        path = ResourceHelper.hasScheme((String)path) ? (String)path + "/" + (String)href : this.baseScheme + (String)path + "/" + (String)href;
        return this.resolve((String)path, base);
    }
}

