/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.xslt.ResultHandlerFactory;
import org.apache.camel.component.xslt.TransformerFactoryConfigurationStrategy;
import org.apache.camel.component.xslt.XsltBuilder;
import org.apache.camel.component.xslt.XsltComponent;
import org.apache.camel.component.xslt.XsltOutput;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ProcessorEndpoint;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

@ManagedResource(description="Managed XsltEndpoint")
@UriEndpoint(firstVersion="1.3.0", scheme="xslt", title="XSLT", syntax="xslt:resourceUri", producerOnly=true, label="core,transformation")
public class XsltEndpoint
extends ProcessorEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(XsltEndpoint.class);
    private volatile boolean cacheCleared;
    private volatile XsltBuilder xslt;
    private Map<String, Object> parameters;
    @UriPath
    @Metadata(required=true)
    private String resourceUri;
    @UriParam(defaultValue="true")
    private boolean contentCache = true;
    @UriParam(label="advanced")
    private String transformerFactoryClass;
    @UriParam(label="advanced")
    private TransformerFactory transformerFactory;
    @UriParam(label="advanced")
    private ResultHandlerFactory resultHandlerFactory;
    @UriParam(defaultValue="true")
    private boolean failOnNullBody = true;
    @UriParam(defaultValue="string")
    private XsltOutput output = XsltOutput.string;
    @UriParam(defaultValue="0")
    private int transformerCacheSize;
    @UriParam(label="advanced")
    private ErrorListener errorListener;
    @UriParam(label="advanced")
    private URIResolver uriResolver;
    @UriParam
    private boolean deleteOutputFile;
    @UriParam(label="advanced")
    private EntityResolver entityResolver;
    @UriParam(label="advanced")
    private TransformerFactoryConfigurationStrategy transformerFactoryConfigurationStrategy;

    public XsltEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    @ManagedOperation(description="Clears the cached XSLT stylesheet, forcing to re-load the stylesheet on next request")
    public void clearCachedStylesheet() {
        this.cacheCleared = true;
    }

    @ManagedAttribute(description="Whether the XSLT stylesheet is cached")
    public boolean isCacheStylesheet() {
        return this.contentCache;
    }

    public XsltEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.resourceUri, newResourceUri);
        LOG.trace("Getting endpoint with URI: {}", (Object)newUri);
        return (XsltEndpoint)this.getCamelContext().getEndpoint(newUri, XsltEndpoint.class);
    }

    protected void onExchange(Exchange exchange) throws Exception {
        if (!this.contentCache || this.cacheCleared) {
            this.loadResource(this.resourceUri, this.xslt);
        }
        super.onExchange(exchange);
    }

    public boolean isCacheCleared() {
        return this.cacheCleared;
    }

    public void setCacheCleared(boolean cacheCleared) {
        this.cacheCleared = cacheCleared;
    }

    public XsltBuilder getXslt() {
        return this.xslt;
    }

    public void setXslt(XsltBuilder xslt) {
        this.xslt = xslt;
    }

    @ManagedAttribute(description="Path to the template")
    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }

    public String getTransformerFactoryClass() {
        return this.transformerFactoryClass;
    }

    public void setTransformerFactoryClass(String transformerFactoryClass) {
        this.transformerFactoryClass = transformerFactoryClass;
    }

    public TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public ResultHandlerFactory getResultHandlerFactory() {
        return this.resultHandlerFactory;
    }

    public void setResultHandlerFactory(ResultHandlerFactory resultHandlerFactory) {
        this.resultHandlerFactory = resultHandlerFactory;
    }

    @ManagedAttribute(description="Whether or not to throw an exception if the input body is null")
    public boolean isFailOnNullBody() {
        return this.failOnNullBody;
    }

    public void setFailOnNullBody(boolean failOnNullBody) {
        this.failOnNullBody = failOnNullBody;
    }

    @ManagedAttribute(description="What kind of option to use.")
    public XsltOutput getOutput() {
        return this.output;
    }

    public void setOutput(XsltOutput output) {
        this.output = output;
    }

    public int getTransformerCacheSize() {
        return this.transformerCacheSize;
    }

    public void setTransformerCacheSize(int transformerCacheSize) {
        this.transformerCacheSize = transformerCacheSize;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    @ManagedAttribute(description="Cache for the resource content (the stylesheet file) when it is loaded.")
    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public boolean isDeleteOutputFile() {
        return this.deleteOutputFile;
    }

    public void setDeleteOutputFile(boolean deleteOutputFile) {
        this.deleteOutputFile = deleteOutputFile;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public TransformerFactoryConfigurationStrategy getTransformerFactoryConfigurationStrategy() {
        return this.transformerFactoryConfigurationStrategy;
    }

    public void setTransformerFactoryConfigurationStrategy(TransformerFactoryConfigurationStrategy transformerFactoryConfigurationStrategy) {
        this.transformerFactoryConfigurationStrategy = transformerFactoryConfigurationStrategy;
    }

    protected void loadResource(String resourceUri, XsltBuilder xslt) throws TransformerException, IOException {
        LOG.trace("{} loading schema resource: {}", (Object)this, (Object)resourceUri);
        Source source = xslt.getUriResolver().resolve(resourceUri, null);
        if (source == null) {
            throw new IOException("Cannot load schema resource " + resourceUri);
        }
        xslt.setTransformerSource(source);
        this.cacheCleared = false;
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.setXslt(this.createXsltBuilder());
        if (ResourceHelper.isClasspathUri((String)this.resourceUri)) {
            this.loadResource(this.resourceUri, this.xslt);
        }
        this.setProcessor(this.getXslt());
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!ResourceHelper.isClasspathUri((String)this.resourceUri)) {
            this.loadResource(this.resourceUri, this.xslt);
        }
    }

    protected XsltBuilder createXsltBuilder() throws Exception {
        CamelContext ctx = this.getCamelContext();
        ClassResolver resolver = ctx.getClassResolver();
        Injector injector = ctx.getInjector();
        LOG.debug("{} using schema resource: {}", (Object)this, (Object)this.resourceUri);
        XsltBuilder xslt = (XsltBuilder)injector.newInstance(XsltBuilder.class);
        TransformerFactory factory = this.transformerFactory;
        if (factory == null) {
            String trFactoryClass;
            String string = trFactoryClass = this.transformerFactoryClass != null ? this.transformerFactoryClass : ((XsltComponent)this.getComponent()).getTransformerFactoryClass();
            if (trFactoryClass != null) {
                TransformerFactoryConfigurationStrategy tfConfigStrategy;
                Class factoryClass = resolver.resolveMandatoryClass(trFactoryClass, TransformerFactory.class, XsltComponent.class.getClassLoader());
                LOG.debug("Using TransformerFactoryClass {}", (Object)factoryClass);
                factory = (TransformerFactory)injector.newInstance(factoryClass);
                TransformerFactoryConfigurationStrategy transformerFactoryConfigurationStrategy = tfConfigStrategy = this.transformerFactoryConfigurationStrategy != null ? this.transformerFactoryConfigurationStrategy : ((XsltComponent)this.getComponent()).getTransformerFactoryConfigurationStrategy();
                if (tfConfigStrategy != null) {
                    tfConfigStrategy.configure(factory, this);
                }
            }
        }
        if (factory != null) {
            LOG.debug("Using TransformerFactory {}", (Object)factory);
            xslt.setTransformerFactory(factory);
        }
        if (this.errorListener != null) {
            xslt.errorListener(this.errorListener);
        }
        xslt.setFailOnNullBody(this.failOnNullBody);
        xslt.transformerCacheSize(this.transformerCacheSize);
        xslt.setUriResolver(this.uriResolver);
        xslt.setEntityResolver(this.entityResolver);
        xslt.setDeleteOutputFile(this.deleteOutputFile);
        this.configureOutput(xslt, this.output.name());
        if (this.resultHandlerFactory != null) {
            xslt.setResultHandlerFactory(this.resultHandlerFactory);
        }
        if (this.parameters != null) {
            HashMap<String, Object> copy = new HashMap<String, Object>(this.parameters);
            xslt.setParameters(copy);
        }
        return xslt;
    }

    protected void configureOutput(XsltBuilder xslt, String output) throws Exception {
        if (ObjectHelper.isEmpty((Object)output)) {
            return;
        }
        if ("string".equalsIgnoreCase(output)) {
            xslt.outputString();
        } else if ("bytes".equalsIgnoreCase(output)) {
            xslt.outputBytes();
        } else if ("DOM".equalsIgnoreCase(output)) {
            xslt.outputDOM();
        } else if ("file".equalsIgnoreCase(output)) {
            xslt.outputFile();
        } else {
            throw new IllegalArgumentException("Unknown output type: " + output);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)this.getXslt());
    }
}

