/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxReader;
import com.thoughtworks.xstream.io.xml.StaxWriter;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.camel.Exchange;
import org.apache.camel.converter.jaxp.StaxConverter;
import org.apache.camel.spi.DataFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XStreamDataFormat
implements DataFormat {
    private XStream xstream;
    private StaxConverter staxConverter;

    public XStreamDataFormat() {
    }

    public XStreamDataFormat(XStream xstream) {
        this.setXStream(xstream);
    }

    public static XStreamDataFormat processAnnotations(Iterable<Class<?>> types) {
        XStreamDataFormat answer = new XStreamDataFormat();
        XStream xstream = answer.getXStream();
        for (Class<?> type : types) {
            xstream.processAnnotations(type);
        }
        return answer;
    }

    public static XStreamDataFormat processAnnotations(Class<?> ... types) {
        XStreamDataFormat answer = new XStreamDataFormat();
        XStream xstream = answer.getXStream();
        for (Class<?> type : types) {
            xstream.processAnnotations(type);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        HierarchicalStreamWriter writer = this.createHierarchicalStreamWriter(exchange, body, stream);
        try {
            this.getXStream().marshal(body, writer);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        HierarchicalStreamReader reader = this.createHierarchicalStreamReader(exchange, stream);
        try {
            Object object = this.getXStream().unmarshal(reader);
            return object;
        }
        finally {
            reader.close();
        }
    }

    public XStream getXStream() {
        if (this.xstream == null) {
            this.xstream = this.createXStream();
        }
        return this.xstream;
    }

    public void setXStream(XStream xstream) {
        this.xstream = xstream;
    }

    public StaxConverter getStaxConverter() {
        if (this.staxConverter == null) {
            this.staxConverter = new StaxConverter();
        }
        return this.staxConverter;
    }

    public void setStaxConverter(StaxConverter staxConverter) {
        this.staxConverter = staxConverter;
    }

    protected XStream createXStream() {
        return new XStream();
    }

    protected HierarchicalStreamWriter createHierarchicalStreamWriter(Exchange exchange, Object body, OutputStream stream) throws XMLStreamException {
        XMLStreamWriter xmlWriter = this.getStaxConverter().createXMLStreamWriter(stream);
        return new StaxWriter(new QNameMap(), xmlWriter);
    }

    protected HierarchicalStreamReader createHierarchicalStreamReader(Exchange exchange, InputStream stream) throws XMLStreamException {
        XMLStreamReader xmlReader = this.getStaxConverter().createXMLStreamReader(stream);
        return new StaxReader(new QNameMap(), xmlReader);
    }
}

