/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.camel.Exchange;
import org.apache.camel.converter.jaxp.StaxConverter;
import org.apache.camel.spi.DataFormat;

public abstract class AbstractXStreamWrapper
implements DataFormat {
    private XStream xstream;
    private StaxConverter staxConverter;

    public AbstractXStreamWrapper() {
    }

    public AbstractXStreamWrapper(XStream xstream) {
        this.xstream = xstream;
    }

    public XStream getXStream() {
        if (this.xstream == null) {
            this.xstream = this.createXStream();
        }
        return this.xstream;
    }

    public void setXStream(XStream xstream) {
        this.xstream = xstream;
    }

    protected XStream createXStream() {
        return new XStream();
    }

    public StaxConverter getStaxConverter() {
        if (this.staxConverter == null) {
            this.staxConverter = new StaxConverter();
        }
        return this.staxConverter;
    }

    public void setStaxConverter(StaxConverter staxConverter) {
        this.staxConverter = staxConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        HierarchicalStreamWriter writer = this.createHierarchicalStreamWriter(exchange, body, stream);
        try {
            this.getXStream().marshal(body, writer);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        HierarchicalStreamReader reader = this.createHierarchicalStreamReader(exchange, stream);
        try {
            Object object = this.getXStream().unmarshal(reader);
            return object;
        }
        finally {
            reader.close();
        }
    }

    protected abstract HierarchicalStreamWriter createHierarchicalStreamWriter(Exchange var1, Object var2, OutputStream var3) throws XMLStreamException;

    protected abstract HierarchicalStreamReader createHierarchicalStreamReader(Exchange var1, InputStream var2) throws XMLStreamException;
}

