/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxReader;
import com.thoughtworks.xstream.io.xml.StaxWriter;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.xstream.AbstractXStreamWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XStreamDataFormat
extends AbstractXStreamWrapper {
    String encoding;

    public XStreamDataFormat() {
    }

    public XStreamDataFormat(XStream xstream) {
        super(xstream);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public static XStreamDataFormat processAnnotations(Iterable<Class<?>> types) {
        XStreamDataFormat answer = new XStreamDataFormat();
        XStream xstream = answer.getXStream();
        for (Class<?> type : types) {
            xstream.processAnnotations(type);
        }
        return answer;
    }

    public static XStreamDataFormat processAnnotations(Class<?> ... types) {
        XStreamDataFormat answer = new XStreamDataFormat();
        XStream xstream = answer.getXStream();
        for (Class<?> type : types) {
            xstream.processAnnotations(type);
        }
        return answer;
    }

    protected void updateCharactorEncodingInfo(Exchange exchange) {
        if (exchange.getProperty("org.apache.camel.Exchange.CharsetName") == null && this.encoding != null) {
            exchange.setProperty("org.apache.camel.Exchange.CharsetName", (Object)this.encoding);
        }
    }

    @Override
    protected HierarchicalStreamWriter createHierarchicalStreamWriter(Exchange exchange, Object body, OutputStream stream) throws XMLStreamException {
        this.updateCharactorEncodingInfo(exchange);
        XMLStreamWriter xmlWriter = this.getStaxConverter().createXMLStreamWriter(stream, exchange);
        return new StaxWriter(new QNameMap(), xmlWriter);
    }

    @Override
    protected HierarchicalStreamReader createHierarchicalStreamReader(Exchange exchange, InputStream stream) throws XMLStreamException {
        this.updateCharactorEncodingInfo(exchange);
        XMLStreamReader xmlReader = this.getStaxConverter().createXMLStreamReader(stream, exchange);
        return new StaxReader(new QNameMap(), xmlReader);
    }
}

