/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.core.util.CompositeClassLoader;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.security.AnyTypePermission;
import com.thoughtworks.xstream.security.ExplicitTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatContentTypeHeader;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public abstract class AbstractXStreamWrapper
extends ServiceSupport
implements CamelContextAware,
DataFormat,
DataFormatName,
DataFormatContentTypeHeader {
    private static final String PERMISSIONS_PROPERTY_KEY = "org.apache.camel.xstream.permissions";
    private CamelContext camelContext;
    private XStream xstream;
    private HierarchicalStreamDriver xstreamDriver;
    private Map<String, String> converters;
    private Map<String, String> aliases;
    private Map<String, String> omitFields;
    private Map<String, String> implicitCollections;
    private String permissions;
    private String mode;
    private boolean contentTypeHeader = true;

    public AbstractXStreamWrapper() {
    }

    public AbstractXStreamWrapper(XStream xstream) {
        this.xstream = xstream;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public XStream getXStream(ClassResolver resolver) {
        if (this.xstream == null) {
            this.xstream = this.createXStream(resolver, null);
        }
        return this.xstream;
    }

    public XStream getXStream(CamelContext context) {
        if (this.xstream == null) {
            this.xstream = this.createXStream(context.getClassResolver(), context.getApplicationContextClassLoader());
        }
        return this.xstream;
    }

    public void setXStream(XStream xstream) {
        this.xstream = xstream;
    }

    protected XStream createXStream(ClassResolver resolver, ClassLoader classLoader) {
        this.xstream = this.xstreamDriver != null ? new XStream(this.xstreamDriver) : new XStream();
        if (this.mode != null) {
            this.xstream.setMode(this.getModeFromString(this.mode));
        }
        ClassLoader xstreamLoader = this.xstream.getClassLoader();
        if (classLoader != null && xstreamLoader instanceof CompositeClassLoader) {
            ((CompositeClassLoader)xstreamLoader).add(classLoader);
        }
        try {
            String[] values;
            if (this.implicitCollections != null) {
                for (Map.Entry<String, String> entry : this.implicitCollections.entrySet()) {
                    for (String name : values = entry.getValue().split(",")) {
                        this.xstream.addImplicitCollection(resolver.resolveMandatoryClass(entry.getKey()), name);
                    }
                }
            }
            if (this.aliases != null) {
                for (Map.Entry<String, String> entry : this.aliases.entrySet()) {
                    this.xstream.alias(entry.getKey(), resolver.resolveMandatoryClass(entry.getValue()));
                    this.xstream.processAnnotations(resolver.resolveMandatoryClass(entry.getValue()));
                }
            }
            if (this.omitFields != null) {
                for (Map.Entry<String, String> entry : this.omitFields.entrySet()) {
                    for (String name : values = entry.getValue().split(",")) {
                        this.xstream.omitField(resolver.resolveMandatoryClass(entry.getKey()), name);
                    }
                }
            }
            if (this.converters != null) {
                for (Map.Entry<String, String> entry : this.converters.entrySet()) {
                    Converter converter;
                    String fqn = entry.getValue();
                    Class converterClass = resolver.resolveMandatoryClass(fqn, Converter.class);
                    Constructor con = null;
                    try {
                        con = converterClass.getDeclaredConstructor(XStream.class);
                    }
                    catch (Exception name) {
                        // empty catch block
                    }
                    if (con != null) {
                        converter = (Converter)con.newInstance(this.xstream);
                    } else {
                        converter = (Converter)converterClass.newInstance();
                        try {
                            Method method = converterClass.getMethod("setXStream", XStream.class);
                            if (method != null) {
                                org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)converter, (Object[])new Object[]{this.xstream});
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.xstream.registerConverter(converter);
                }
            }
            AbstractXStreamWrapper.addDefaultPermissions(this.xstream);
            if (this.permissions != null) {
                AbstractXStreamWrapper.addPermissions(this.xstream, this.permissions);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to build XStream instance", e);
        }
        return this.xstream;
    }

    private static void addPermissions(XStream xstream, String permissions) {
        for (String pterm : permissions.split(",")) {
            boolean aod;
            if ((pterm = pterm.trim()).startsWith("-")) {
                aod = false;
                pterm = pterm.substring(1);
            } else {
                aod = true;
                if (pterm.startsWith("+")) {
                    pterm = pterm.substring(1);
                }
            }
            TypePermission typePermission = null;
            if ("*".equals(pterm)) {
                typePermission = AnyTypePermission.ANY;
            } else if (pterm.indexOf(42) < 0) {
                typePermission = new ExplicitTypePermission(new String[]{pterm});
            } else if (pterm.length() > 0) {
                typePermission = new WildcardTypePermission(new String[]{pterm});
            }
            if (typePermission == null) continue;
            if (aod) {
                xstream.addPermission(typePermission);
                continue;
            }
            xstream.denyPermission(typePermission);
        }
    }

    private static void addDefaultPermissions(XStream xstream) {
        XStream.setupDefaultSecurity((XStream)xstream);
        String value = System.getProperty(PERMISSIONS_PROPERTY_KEY);
        if (value != null) {
            AbstractXStreamWrapper.addPermissions(xstream, value);
        }
    }

    protected int getModeFromString(String modeString) {
        int result;
        if ("NO_REFERENCES".equalsIgnoreCase(modeString)) {
            result = 1001;
        } else if ("ID_REFERENCES".equalsIgnoreCase(modeString)) {
            result = 1002;
        } else if ("XPATH_RELATIVE_REFERENCES".equalsIgnoreCase(modeString)) {
            result = 1003;
        } else if ("XPATH_ABSOLUTE_REFERENCES".equalsIgnoreCase(modeString)) {
            result = 1004;
        } else if ("SINGLE_NODE_XPATH_RELATIVE_REFERENCES".equalsIgnoreCase(modeString)) {
            result = 1005;
        } else if ("SINGLE_NODE_XPATH_ABSOLUTE_REFERENCES".equalsIgnoreCase(modeString)) {
            result = 1006;
        } else {
            throw new IllegalArgumentException("Unknown mode : " + modeString);
        }
        return result;
    }

    public Map<String, String> getConverters() {
        return this.converters;
    }

    public void setConverters(Map<String, String> converters) {
        this.converters = converters;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public Map<String, String> getOmitFields() {
        return this.omitFields;
    }

    public void setOmitFields(Map<String, String> omitFields) {
        this.omitFields = omitFields;
    }

    public Map<String, String> getImplicitCollections() {
        return this.implicitCollections;
    }

    public void setImplicitCollections(Map<String, String> implicitCollections) {
        this.implicitCollections = implicitCollections;
    }

    public HierarchicalStreamDriver getXstreamDriver() {
        return this.xstreamDriver;
    }

    public void setXstreamDriver(HierarchicalStreamDriver xstreamDriver) {
        this.xstreamDriver = xstreamDriver;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean isContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public void setContentTypeHeader(boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public XStream getXstream() {
        return this.xstream;
    }

    public void setXstream(XStream xstream) {
        this.xstream = xstream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        try (HierarchicalStreamWriter writer = this.createHierarchicalStreamWriter(exchange, body, stream);){
            this.getXStream(exchange.getContext()).marshal(body, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        try (HierarchicalStreamReader reader = this.createHierarchicalStreamReader(exchange, stream);){
            Object object = this.getXStream(exchange.getContext()).unmarshal(reader);
            return object;
        }
    }

    protected abstract HierarchicalStreamWriter createHierarchicalStreamWriter(Exchange var1, Object var2, OutputStream var3) throws XMLStreamException;

    protected abstract HierarchicalStreamReader createHierarchicalStreamReader(Exchange var1, InputStream var2) throws XMLStreamException;

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        if (this.xstream == null) {
            this.xstream = this.createXStream(this.camelContext.getClassResolver(), this.camelContext.getApplicationContextClassLoader());
        }
    }

    protected void doStop() throws Exception {
    }
}

