/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Ordered;
import org.apache.camel.Service;
import org.apache.camel.dsl.yaml.common.YamlDeserializationMode;
import org.apache.camel.dsl.yaml.common.YamlDeserializerResolver;
import org.apache.camel.dsl.yaml.common.YamlSupport;
import org.apache.camel.dsl.yaml.common.exception.UnknownNodeTypeException;
import org.apache.camel.dsl.yaml.common.exception.YamlDeserializationException;
import org.apache.camel.spi.Resource;
import org.apache.camel.util.ObjectHelper;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.constructor.StandardConstructor;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.nodes.ScalarNode;

public class YamlDeserializationContext
extends StandardConstructor
implements CamelContextAware,
Service {
    private final Set<YamlDeserializerResolver> resolvers = new TreeSet<YamlDeserializerResolver>(Comparator.comparing(Ordered::getOrder));
    private final Map<String, ConstructNode> constructors = new HashMap<String, ConstructNode>();
    private YamlDeserializationMode deserializationMode = YamlDeserializationMode.CLASSIC;
    private ExtendedCamelContext camelContext;
    private Resource resource;

    public YamlDeserializationContext(LoadSettings settings) {
        super(settings);
    }

    public void addResolver(YamlDeserializerResolver resolver) {
        this.resolvers.add(resolver);
    }

    public void addResolvers(YamlDeserializerResolver ... resolvers) {
        this.addResolvers(Arrays.asList(resolvers));
    }

    public void addResolvers(Collection<YamlDeserializerResolver> resolvers) {
        this.resolvers.addAll(resolvers);
    }

    public void setDeserializationMode(YamlDeserializationMode deserializationMode) {
        this.deserializationMode = deserializationMode;
    }

    public YamlDeserializationMode getDeserializationMode() {
        return this.deserializationMode;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = (ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class);
    }

    public Object constructDocument(Node node) {
        return super.construct(node);
    }

    protected Optional<ConstructNode> findConstructorFor(Node node) {
        ConstructNode ctor = this.resolve(node);
        if (ctor != null) {
            return Optional.of(ctor);
        }
        return super.findConstructorFor(node);
    }

    public void start() {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camel context");
        this.resolvers.addAll(this.getCamelContext().getRegistry().findByType(YamlDeserializerResolver.class));
    }

    public void stop() {
        this.constructors.clear();
    }

    public Object construct(String key, Node val) {
        return this.mandatoryResolve(key).construct(val);
    }

    public <T> T construct(String key, Node val, Class<T> type) {
        Object result = this.construct(key, val);
        if (result == null) {
            return null;
        }
        return type.cast(result);
    }

    public Object construct(Node key, Node val) {
        return this.mandatoryResolve(key).construct(val);
    }

    public <T> T construct(Node key, Node val, Class<T> type) {
        Object result = this.construct(key, val);
        if (result == null) {
            return null;
        }
        return type.cast(result);
    }

    public <T> T construct(Node node, Class<T> type) {
        ConstructNode constructor = this.resolve(type);
        if (constructor == null) {
            throw new YamlDeserializationException("Unable to find constructor for node: " + node);
        }
        Object result = constructor.construct(node);
        if (result == null) {
            return null;
        }
        return type.cast(result);
    }

    public ConstructNode resolve(Class<?> type) {
        final ConstructNode answer = this.resolve(type.getName());
        return (ConstructNode)CamelContextAware.trySetCamelContext((Object)new ConstructNode(){

            public Object construct(Node node) {
                Node n = YamlSupport.setProperty(node, YamlDeserializationContext.class.getName(), (Object)YamlDeserializationContext.this);
                return answer.construct(n);
            }
        }, (CamelContext)this.camelContext);
    }

    public ConstructNode mandatoryResolve(Node node) {
        ConstructNode constructor = this.resolve(node);
        if (constructor == null) {
            throw new YamlDeserializationException("Unable to find constructor for node: " + node);
        }
        return constructor;
    }

    public ConstructNode resolve(Node node) {
        if (node.getNodeType() != NodeType.MAPPING) {
            return null;
        }
        MappingNode mn = (MappingNode)node;
        if (mn.getValue().size() != 1) {
            return null;
        }
        Node key = ((NodeTuple)mn.getValue().get(0)).getKeyNode();
        if (key.getNodeType() != NodeType.SCALAR) {
            return null;
        }
        String id = ((ScalarNode)key).getValue();
        final ConstructNode answer = this.resolve(id);
        return (ConstructNode)CamelContextAware.trySetCamelContext((Object)new ConstructNode(){

            public Object construct(Node node) {
                Node n = YamlSupport.setProperty(node, YamlDeserializationContext.class.getName(), (Object)YamlDeserializationContext.this);
                return answer.construct(((NodeTuple)((MappingNode)n).getValue().get(0)).getValueNode());
            }
        }, (CamelContext)this.camelContext);
    }

    public ConstructNode mandatoryResolve(String id) {
        ConstructNode constructor = this.resolve(id);
        if (constructor == null) {
            throw new YamlDeserializationException("Unable to find constructor for id: " + id);
        }
        return constructor;
    }

    public ConstructNode resolve(final String id) {
        return this.constructors.computeIfAbsent(id, new Function<String, ConstructNode>(){

            @Override
            public ConstructNode apply(String s) {
                YamlDeserializerResolver resolver;
                ConstructNode answer = null;
                Iterator<YamlDeserializerResolver> iterator = YamlDeserializationContext.this.resolvers.iterator();
                while (iterator.hasNext() && (answer = (resolver = iterator.next()).resolve(id)) == null) {
                }
                if (answer == null) {
                    throw new UnknownNodeTypeException(id);
                }
                return answer;
            }
        });
    }
}

