/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.common;

import java.util.Locale;
import org.apache.camel.LineNumberAware;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.util.StringHelper;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.nodes.ScalarNode;

public abstract class YamlDeserializerBase<T>
extends YamlDeserializerSupport
implements ConstructNode {
    private final Class<T> type;

    public YamlDeserializerBase(Class<T> type) {
        this.type = type;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Object construct(Node node) {
        T target;
        ScalarNode mn;
        int line = -1;
        if (node.getStartMark().isPresent()) {
            line = ((Mark)node.getStartMark().get()).getLine();
        }
        if (node.getNodeType() == NodeType.SCALAR) {
            mn = (ScalarNode)node;
            target = this.newInstance(mn.getValue());
            if (line != -1) {
                ++line;
            }
        } else if (node.getNodeType() == NodeType.MAPPING) {
            mn = (MappingNode)node;
            target = this.newInstance();
            this.setProperties(target, (MappingNode)mn);
        } else {
            throw new IllegalArgumentException("Unsupported node type: " + node);
        }
        if (target instanceof LineNumberAware && line != -1) {
            LineNumberAware lna = (LineNumberAware)target;
            lna.setLineNumber(line);
            YamlDeserializationContext ctx = YamlDeserializerBase.getDeserializationContext(node);
            if (ctx != null) {
                lna.setLocation(ctx.getResource().getLocation());
            }
        }
        return target;
    }

    protected abstract T newInstance();

    protected T newInstance(String value) {
        throw new IllegalArgumentException("Unsupported " + value);
    }

    protected boolean setProperty(T target, String propertyKey, String propertyName, Node value) {
        return false;
    }

    protected void setProperties(T target, MappingNode node) {
        YamlDeserializationContext dc = YamlDeserializerBase.getDeserializationContext((Node)node);
        for (NodeTuple tuple : node.getValue()) {
            ScalarNode key = (ScalarNode)tuple.getKeyNode();
            String propertyName = StringHelper.camelCaseToDash((String)key.getValue()).toLowerCase(Locale.US);
            Node val = tuple.getValueNode();
            YamlDeserializerBase.setDeserializationContext(val, dc);
            if (this.setProperty(target, propertyName, key.getValue(), val)) continue;
            this.handleUnknownProperty(target, propertyName, key.getValue(), val);
        }
    }

    protected void handleUnknownProperty(T target, String propertyKey, String propertyName, Node value) {
        throw new IllegalArgumentException("Unsupported field: " + propertyName + " on " + target.getClass().getName());
    }
}

