/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.common;

import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.common.exception.UnsupportedNodeTypeException;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

public final class YamlSupport {
    private YamlSupport() {
    }

    public static void setPropertiesOnTarget(CamelContext context, Object target, Map<String, Object> properties) {
        ObjectHelper.notNull((Object)context, (String)"context");
        ObjectHelper.notNull((Object)target, (String)"target");
        ObjectHelper.notNull(properties, (String)"properties");
        if (target instanceof CamelContext) {
            throw new UnsupportedOperationException("Configuring the Camel Context is not supported");
        }
        PropertyConfigurer configurer = null;
        if (target instanceof Component) {
            ServiceHelper.initService((Object)target);
            configurer = ((Component)target).getComponentPropertyConfigurer();
        }
        if (configurer == null) {
            configurer = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getConfigurerResolver().resolvePropertyConfigurer(target.getClass().getSimpleName(), context);
        }
        try {
            PropertyBindingSupport.build().withMandatory(true).withRemoveParameters(false).withConfigurer(configurer).withIgnoreCase(true).withFlattenProperties(true).bind(context, target, properties);
        }
        catch (PropertyBindingException e) {
            String key = e.getOptionKey();
            if (key == null) {
                String prefix = e.getOptionPrefix();
                if (prefix != null && !prefix.endsWith(".")) {
                    prefix = "." + prefix;
                }
                key = prefix != null ? prefix + "." + e.getPropertyName() : e.getPropertyName();
            }
            throw new PropertyBindingException(e.getTarget(), e.getPropertyName(), e.getValue(), null, key, e.getCause());
        }
    }

    public static CamelContextCustomizer customizer(final Collection<CamelContextCustomizer> customizers) {
        return new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                for (CamelContextCustomizer customizer : customizers) {
                    customizer.configure(camelContext);
                }
            }
        };
    }

    public static String createEndpointUri(CamelContext context, String uri, Map<String, Object> parameters) {
        String answer = uri;
        if (parameters == null || parameters.isEmpty()) {
            return answer;
        }
        if (uri.indexOf(63) != -1) {
            throw new IllegalArgumentException("Uri should not contains query params (uri: " + uri + ")");
        }
        String scheme = uri.contains(":") ? StringHelper.before((String)uri, (String)":") : uri;
        EndpointUriFactory factory = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getEndpointUriFactory(scheme);
        try {
            if (factory != null && factory.isEnabled(scheme)) {
                if (scheme.equals(uri)) {
                    answer = factory.buildUri(scheme, parameters, false);
                } else {
                    TreeMap<String, Object> options = new TreeMap<String, Object>(parameters);
                    for (String secretParameter : factory.secretPropertyNames()) {
                        String newVal;
                        Object val = options.get(secretParameter);
                        if (!(val instanceof String) || (newVal = (String)val).startsWith("#") || newVal.startsWith("RAW(")) continue;
                        options.put(secretParameter, "RAW(" + val + ")");
                    }
                    answer = answer + "?" + URISupport.createQueryString(options, (boolean)false);
                }
            } else {
                answer = answer + "?" + URISupport.createQueryString(parameters, (boolean)false);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return answer;
    }

    public static Node setProperty(Node node, String key, Object value) {
        block3: {
            block2: {
                node.setProperty(key, value);
                if (!(node instanceof MappingNode)) break block2;
                for (NodeTuple item : ((MappingNode)node).getValue()) {
                    item.getValueNode().setProperty(key, value);
                }
                break block3;
            }
            if (!(node instanceof SequenceNode)) break block3;
            for (Node item : ((SequenceNode)node).getValue()) {
                item.setProperty(key, value);
            }
        }
        return node;
    }

    public static String creteEndpointUri(Node node, BiFunction<String, Node, String> endpointResolver) {
        String answer = null;
        if (node.getNodeType() == NodeType.SCALAR) {
            answer = YamlDeserializerSupport.asText(node);
        } else if (node.getNodeType() == NodeType.MAPPING) {
            MappingNode mn = (MappingNode)node;
            YamlDeserializationContext dc = YamlDeserializerSupport.getDeserializationContext(node);
            String uri = null;
            Map<String, Object> properties = null;
            block8: for (NodeTuple tuple : mn.getValue()) {
                String key = YamlDeserializerSupport.asText(tuple.getKeyNode());
                Node val = tuple.getValueNode();
                YamlDeserializerSupport.setDeserializationContext(val, dc);
                switch (key) {
                    case "uri": {
                        if (answer != null) {
                            throw new IllegalArgumentException("uri and properties are not supported when using Endpoint DSL ");
                        }
                        uri = YamlDeserializerSupport.asText(val);
                        continue block8;
                    }
                    case "properties": {
                        if (answer != null) {
                            throw new IllegalArgumentException("uri and properties are not supported when using Endpoint DSL ");
                        }
                        properties = YamlDeserializerSupport.asScalarMap(tuple.getValueNode());
                        continue block8;
                    }
                }
                String endpointUri = endpointResolver.apply(key, val);
                if (endpointUri != null) {
                    if (uri != null || properties != null) {
                        throw new IllegalArgumentException("uri and properties are not supported when using Endpoint DSL ");
                    }
                    answer = endpointUri;
                    continue;
                }
                throw new IllegalArgumentException("Unsupported field: " + key);
            }
            if (answer == null) {
                ObjectHelper.notNull(uri, (String)"The uri must set");
                answer = YamlSupport.createEndpointUri(dc.getCamelContext(), uri, properties);
            }
        }
        return answer;
    }

    public static String creteEndpointUri(String scheme, Node node) {
        switch (node.getNodeType()) {
            case SCALAR: {
                return scheme + ':' + YamlDeserializerSupport.asText(node);
            }
            case MAPPING: {
                YamlDeserializationContext dc = YamlDeserializerSupport.getDeserializationContext(node);
                MappingNode bn = YamlDeserializerSupport.asMappingNode(node);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                for (NodeTuple tuple : bn.getValue()) {
                    String key = YamlDeserializerSupport.asText(tuple.getKeyNode());
                    Node val = tuple.getValueNode();
                    if (val.getNodeType() == NodeType.SCALAR) {
                        parameters.put(StringHelper.dashToCamelCase((String)key), YamlDeserializerSupport.asText(val));
                        continue;
                    }
                    throw new UnsupportedNodeTypeException(node);
                }
                return YamlSupport.createEndpointUri(dc.getCamelContext(), scheme, parameters);
            }
        }
        throw new UnsupportedNodeTypeException(node);
    }

    public static <T> T creteEndpoint(String scheme, Node node, Function<String, T> constructor) {
        return constructor.apply(YamlSupport.creteEndpointUri(scheme, node));
    }

    public static ConstructNode creteEndpointConstructor(String scheme, Function<String, Object> constructor) {
        return node -> YamlSupport.creteEndpoint(scheme, node, constructor);
    }
}

