/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.common;

import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.common.exception.InvalidEndpointException;
import org.apache.camel.dsl.yaml.common.exception.InvalidNodeTypeException;
import org.apache.camel.dsl.yaml.common.exception.UnsupportedFieldException;
import org.apache.camel.dsl.yaml.common.exception.UnsupportedNodeTypeException;
import org.apache.camel.model.Block;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

public final class YamlSupport {
    private YamlSupport() {
    }

    public static CamelContextCustomizer customizer(final Collection<CamelContextCustomizer> customizers) {
        return new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                for (CamelContextCustomizer customizer : customizers) {
                    customizer.configure(camelContext);
                }
            }
        };
    }

    public static String createEndpointUri(CamelContext context, Node node, String uri, Map<String, Object> parameters) {
        Object answer = uri;
        if (parameters == null || parameters.isEmpty()) {
            return answer;
        }
        if (uri.indexOf(63) != -1) {
            throw new InvalidEndpointException(node, "Uri should not contains query parameters (uri: " + uri + ")");
        }
        String scheme = uri.contains(":") ? StringHelper.before((String)uri, (String)":") : uri;
        EndpointUriFactory factory = context.getCamelContextExtension().getEndpointUriFactory(scheme);
        try {
            if (factory != null && factory.isEnabled(scheme)) {
                if (scheme.equals(uri)) {
                    answer = factory.buildUri(scheme, parameters, false);
                } else {
                    TreeMap<String, Object> options = new TreeMap<String, Object>(parameters);
                    for (String secretParameter : factory.secretPropertyNames()) {
                        String newVal;
                        Object val = options.get(secretParameter);
                        if (!(val instanceof String) || (newVal = (String)val).startsWith("#") || newVal.startsWith("RAW(")) continue;
                        options.put(secretParameter, "RAW(" + val + ")");
                    }
                    answer = (String)answer + "?" + URISupport.createQueryString(options, (boolean)false);
                }
            } else {
                answer = (String)answer + "?" + URISupport.createQueryString(parameters, (boolean)false);
            }
        }
        catch (URISyntaxException e) {
            throw new InvalidEndpointException(node, "Error creating query", e);
        }
        return answer;
    }

    public static Node setProperty(Node node, String key, Object value) {
        block3: {
            block2: {
                node.setProperty(key, value);
                if (!(node instanceof MappingNode)) break block2;
                for (NodeTuple item : ((MappingNode)node).getValue()) {
                    item.getValueNode().setProperty(key, value);
                }
                break block3;
            }
            if (!(node instanceof SequenceNode)) break block3;
            for (Node item : ((SequenceNode)node).getValue()) {
                item.setProperty(key, value);
            }
        }
        return node;
    }

    public static String creteEndpointUri(Node node, RouteDefinition route) {
        String answer = null;
        if (node.getNodeType() == NodeType.SCALAR) {
            answer = YamlDeserializerSupport.asText(node);
        } else if (node.getNodeType() == NodeType.MAPPING) {
            MappingNode mn = (MappingNode)node;
            YamlDeserializationContext dc = YamlDeserializerSupport.getDeserializationContext(node);
            String uri = null;
            Map<String, Object> parameters = null;
            block14: for (NodeTuple tuple : mn.getValue()) {
                String key = YamlDeserializerSupport.asText(tuple.getKeyNode());
                Node val = tuple.getValueNode();
                YamlDeserializerSupport.setDeserializationContext(val, dc);
                switch (key) {
                    case "id": {
                        continue block14;
                    }
                    case "description": {
                        continue block14;
                    }
                    case "uri": {
                        uri = YamlDeserializerSupport.asText(val);
                        continue block14;
                    }
                    case "parameters": {
                        parameters = YamlDeserializerSupport.parseParameters(tuple);
                        continue block14;
                    }
                    case "steps": {
                        YamlDeserializerSupport.setSteps((Block)route, val);
                        continue block14;
                    }
                }
                throw new UnsupportedFieldException(val, key);
            }
            answer = YamlSupport.createEndpointUri(dc.getCamelContext(), node, uri, parameters);
        }
        return answer;
    }

    public static String creteEndpointUri(String scheme, Node node) {
        switch (node.getNodeType()) {
            case SCALAR: {
                return scheme + ":" + YamlDeserializerSupport.asText(node);
            }
            case MAPPING: {
                YamlDeserializationContext dc = YamlDeserializerSupport.getDeserializationContext(node);
                MappingNode bn = YamlDeserializerSupport.asMappingNode(node);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                for (NodeTuple tuple : bn.getValue()) {
                    String key = YamlDeserializerSupport.asText(tuple.getKeyNode());
                    Node val = tuple.getValueNode();
                    if (val.getNodeType() == NodeType.SCALAR) {
                        parameters.put(StringHelper.dashToCamelCase((String)key), YamlDeserializerSupport.asText(val));
                        continue;
                    }
                    throw new InvalidNodeTypeException(node, NodeType.SCALAR);
                }
                return YamlSupport.createEndpointUri(dc.getCamelContext(), node, scheme, parameters);
            }
        }
        throw new UnsupportedNodeTypeException(node);
    }

    public static <T> T creteEndpoint(String scheme, Node node, Function<String, T> constructor) {
        return constructor.apply(YamlSupport.creteEndpointUri(scheme, node));
    }

    public static ConstructNode creteEndpointConstructor(String scheme, Function<String, Object> constructor) {
        return node -> YamlSupport.creteEndpoint(scheme, node, constructor);
    }
}

