/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.Iterator;
import org.apache.camel.CamelContext;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.NoErrorHandlerBuilder;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.common.exception.UnsupportedFieldException;
import org.apache.camel.dsl.yaml.common.exception.YamlDeserializationException;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.annotations.YamlIn;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@YamlIn
@YamlType(nodes={"error-handler"}, types={ErrorHandlerBuilderRef.class}, order=0, properties={@YamlProperty(name="ref", type="string"), @YamlProperty(name="none", type="object:org.apache.camel.builder.NoErrorHandlerBuilder"), @YamlProperty(name="log", type="object:org.apache.camel.builder.DefaultErrorHandlerBuilder"), @YamlProperty(name="dead-letter-channel", type="object:org.apache.camel.builder.DeadLetterChannelBuilder")})
public class ErrorHandlerBuilderDeserializer
implements ConstructNode {
    private static CamelContextCustomizer customizer(final ErrorHandlerBuilder builder) {
        return new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).setErrorHandlerFactory((ErrorHandlerFactory)builder);
            }
        };
    }

    public Object construct(Node node) {
        MappingNode bn = YamlDeserializerSupport.asMappingNode((Node)node);
        YamlDeserializationContext dc = YamlDeserializerSupport.getDeserializationContext((Node)node);
        Iterator iterator = bn.getValue().iterator();
        if (iterator.hasNext()) {
            NodeTuple tuple = (NodeTuple)iterator.next();
            String key = YamlDeserializerSupport.asText((Node)tuple.getKeyNode());
            Node val = tuple.getValueNode();
            YamlDeserializerSupport.setDeserializationContext((Node)val, (YamlDeserializationContext)dc);
            switch (key) {
                case "ref": {
                    return ErrorHandlerBuilderDeserializer.customizer((ErrorHandlerBuilder)YamlDeserializerSupport.asType((Node)val, ErrorHandlerBuilderRef.class));
                }
                case "none": {
                    return ErrorHandlerBuilderDeserializer.customizer((ErrorHandlerBuilder)YamlDeserializerSupport.asType((Node)val, NoErrorHandlerBuilder.class));
                }
                case "dead-letter-channel": {
                    return ErrorHandlerBuilderDeserializer.customizer((ErrorHandlerBuilder)YamlDeserializerSupport.asType((Node)val, DeadLetterChannelBuilder.class));
                }
                case "log": {
                    return ErrorHandlerBuilderDeserializer.customizer((ErrorHandlerBuilder)YamlDeserializerSupport.asType((Node)val, DefaultErrorHandlerBuilder.class));
                }
            }
            throw new UnsupportedFieldException(val, key);
        }
        throw new YamlDeserializationException("Unable to determine the error handler type");
    }
}

