/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerBase;
import org.apache.camel.dsl.yaml.common.YamlSupport;
import org.apache.camel.dsl.yaml.deserializers.EndpointConsumerDeserializersResolver;
import org.apache.camel.dsl.yaml.deserializers.OutputAwareFromDefinition;
import org.apache.camel.model.Block;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.apache.camel.util.ObjectHelper;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@YamlType(types={OutputAwareFromDefinition.class}, order=0, properties={@YamlProperty(name="uri", type="string", required=true), @YamlProperty(name="parameters", type="object"), @YamlProperty(name="steps", type="array:org.apache.camel.model.ProcessorDefinition", required=true)})
public class OutputAwareFromDefinitionDeserializer
extends YamlDeserializerBase<OutputAwareFromDefinition> {
    public OutputAwareFromDefinitionDeserializer() {
        super(OutputAwareFromDefinition.class);
    }

    protected OutputAwareFromDefinition newInstance() {
        return new OutputAwareFromDefinition();
    }

    protected OutputAwareFromDefinition newInstance(String value) {
        return new OutputAwareFromDefinition(value);
    }

    protected void setProperties(OutputAwareFromDefinition target, MappingNode node) {
        YamlDeserializationContext dc = OutputAwareFromDefinitionDeserializer.getDeserializationContext((Node)node);
        String uri = null;
        Map properties = null;
        block10: for (NodeTuple tuple : node.getValue()) {
            String key = OutputAwareFromDefinitionDeserializer.asText((Node)tuple.getKeyNode());
            Node val = tuple.getValueNode();
            OutputAwareFromDefinitionDeserializer.setDeserializationContext((Node)val, (YamlDeserializationContext)dc);
            switch (key) {
                case "steps": {
                    OutputAwareFromDefinitionDeserializer.setSteps((Block)target, (Node)val);
                    continue block10;
                }
                case "uri": {
                    uri = OutputAwareFromDefinitionDeserializer.asText((Node)val);
                    continue block10;
                }
                case "parameters": {
                    properties = OutputAwareFromDefinitionDeserializer.asScalarMap((Node)tuple.getValueNode());
                    continue block10;
                }
            }
            String endpointUri = EndpointConsumerDeserializersResolver.resolveEndpointUri(key, val);
            if (endpointUri != null) {
                if (uri != null || properties != null) {
                    throw new IllegalArgumentException("uri and properties are not supported when using Endpoint DSL ");
                }
                target.setDelegate(new FromDefinition(endpointUri));
                continue;
            }
            throw new IllegalArgumentException("Unsupported field: " + key);
        }
        if (target.getDelegate() == null) {
            ObjectHelper.notNull((Object)"uri", (String)"The uri must set");
            target.setDelegate(new FromDefinition(YamlSupport.createEndpointUri((CamelContext)dc.getCamelContext(), uri, properties)));
        }
    }
}

