/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.Iterator;
import org.apache.camel.CamelContext;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.common.exception.UnsupportedFieldException;
import org.apache.camel.dsl.yaml.common.exception.YamlDeserializationException;
import org.apache.camel.model.errorhandler.DeadLetterChannelDefinition;
import org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.ErrorHandlerRefDefinition;
import org.apache.camel.model.errorhandler.NoErrorHandlerDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.annotations.YamlIn;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@YamlIn
@YamlType(nodes={"error-handler", "errorHandler"}, order=0, properties={@YamlProperty(name="ref", type="string"), @YamlProperty(name="none", type="object:org.apache.camel.model.errorhandler.NoErrorHandlerDefinition"), @YamlProperty(name="log", type="object:org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition"), @YamlProperty(name="dead-letter-channel", type="object:org.apache.camel.model.errorhandler.DeadLetterChannelDefinition")})
public class ErrorHandlerBuilderDeserializer
implements ConstructNode {
    private static CamelContextCustomizer customizer(final ErrorHandlerFactory builder) {
        return new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).setErrorHandlerFactory(builder);
            }
        };
    }

    public Object construct(Node node) {
        MappingNode bn = YamlDeserializerSupport.asMappingNode((Node)node);
        YamlDeserializationContext dc = YamlDeserializerSupport.getDeserializationContext((Node)node);
        Iterator iterator = bn.getValue().iterator();
        if (iterator.hasNext()) {
            NodeTuple tuple = (NodeTuple)iterator.next();
            String key = YamlDeserializerSupport.asText((Node)tuple.getKeyNode());
            Node val = tuple.getValueNode();
            YamlDeserializerSupport.setDeserializationContext((Node)val, (YamlDeserializationContext)dc);
            switch (key) {
                case "ref": {
                    ErrorHandlerRefDefinition def = new ErrorHandlerRefDefinition(YamlDeserializerSupport.asText((Node)val));
                    return ErrorHandlerBuilderDeserializer.customizer((ErrorHandlerFactory)def);
                }
                case "none": {
                    return ErrorHandlerBuilderDeserializer.customizer((ErrorHandlerFactory)YamlDeserializerSupport.asType((Node)val, NoErrorHandlerDefinition.class));
                }
                case "dead-letter-channel": {
                    return ErrorHandlerBuilderDeserializer.customizer((ErrorHandlerFactory)YamlDeserializerSupport.asType((Node)val, DeadLetterChannelDefinition.class));
                }
                case "log": {
                    return ErrorHandlerBuilderDeserializer.customizer((ErrorHandlerFactory)YamlDeserializerSupport.asType((Node)val, DefaultErrorHandlerDefinition.class));
                }
            }
            throw new UnsupportedFieldException(val, key);
        }
        throw new YamlDeserializationException(node, "Unable to determine the error handler type for the node");
    }
}

