/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.common.YamlSupport;
import org.apache.camel.dsl.yaml.common.exception.UnsupportedFieldException;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.annotations.YamlType;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

@YamlType(nodes={"beans"}, order=0)
public class BeansDeserializer
extends YamlDeserializerSupport
implements ConstructNode {
    public Object construct(Node node) {
        SequenceNode sn = BeansDeserializer.asSequenceNode((Node)node);
        ArrayList<CamelContextCustomizer> customizers = new ArrayList<CamelContextCustomizer>();
        for (Node item : sn.getValue()) {
            customizers.add(BeansDeserializer.createCustomizer(item));
        }
        return YamlSupport.customizer(customizers);
    }

    private static CamelContextCustomizer createCustomizer(Node node) {
        MappingNode bn = BeansDeserializer.asMappingNode((Node)node);
        String name = null;
        String type = null;
        Map properties = null;
        block10: for (NodeTuple tuple : bn.getValue()) {
            String key = BeansDeserializer.asText((Node)tuple.getKeyNode());
            Node val = tuple.getValueNode();
            switch (key) {
                case "name": {
                    name = BeansDeserializer.asText((Node)val);
                    continue block10;
                }
                case "type": {
                    type = BeansDeserializer.asText((Node)val);
                    if (type.startsWith("#class:")) continue block10;
                    type = "#class:" + type;
                    continue block10;
                }
                case "properties": {
                    properties = BeansDeserializer.asMap((Node)val);
                    continue block10;
                }
            }
            throw new UnsupportedFieldException(val, key);
        }
        ObjectHelper.notNull(name, (String)"The bean name must be set");
        ObjectHelper.notNull(type, (String)"The bean type must be set");
        return BeansDeserializer.createCustomizer(name, type, properties);
    }

    private static CamelContextCustomizer createCustomizer(final String name, final String type, final Map<String, Object> properties) {
        return new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                try {
                    Object target = PropertyBindingSupport.resolveBean((CamelContext)camelContext, (Object)type);
                    if (properties != null && !properties.isEmpty()) {
                        YamlSupport.setPropertiesOnTarget((CamelContext)camelContext, (Object)target, (Map)properties);
                    }
                    camelContext.getRegistry().bind(name, target);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

