/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerBase;
import org.apache.camel.dsl.yaml.common.YamlSupport;
import org.apache.camel.dsl.yaml.deserializers.EndpointConsumerDeserializersResolver;
import org.apache.camel.dsl.yaml.deserializers.model.OutputAwareFromDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.annotations.YamlIn;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.apache.camel.util.ObjectHelper;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@YamlIn
@YamlType(nodes={"from"}, types={OutputAwareFromDefinition.class}, order=0, properties={@YamlProperty(name="uri", type="string", required=true), @YamlProperty(name="properties", type="object"), @YamlProperty(name="steps", type="array:org.apache.camel.model.ProcessorDefinition", required=true)})
public class RouteFromDefinitionDeserializer
extends YamlDeserializerBase<OutputAwareFromDefinition> {
    public RouteFromDefinitionDeserializer() {
        super(OutputAwareFromDefinition.class);
    }

    protected OutputAwareFromDefinition newInstance() {
        return new OutputAwareFromDefinition();
    }

    protected OutputAwareFromDefinition newInstance(String value) {
        return new OutputAwareFromDefinition(value);
    }

    protected void setProperties(OutputAwareFromDefinition target, MappingNode node) {
        YamlDeserializationContext dc = RouteFromDefinitionDeserializer.getDeserializationContext((Node)node);
        String uri = null;
        Map properties = null;
        block10: for (NodeTuple tuple : node.getValue()) {
            String key = RouteFromDefinitionDeserializer.asText((Node)tuple.getKeyNode());
            Node val = tuple.getValueNode();
            RouteFromDefinitionDeserializer.setDeserializationContext((Node)val, (YamlDeserializationContext)dc);
            switch (key) {
                case "steps": {
                    for (ProcessorDefinition definition : RouteFromDefinitionDeserializer.asFlatList((Node)val, ProcessorDefinition.class)) {
                        target.addOutput(definition);
                    }
                    continue block10;
                }
                case "uri": {
                    uri = RouteFromDefinitionDeserializer.asText((Node)val);
                    break;
                }
                case "properties": {
                    properties = RouteFromDefinitionDeserializer.asScalarMap((Node)tuple.getValueNode());
                    break;
                }
                default: {
                    String endpointUri = EndpointConsumerDeserializersResolver.resolveEndpointUri(key, val);
                    if (endpointUri != null) {
                        if (uri != null || properties != null) {
                            throw new IllegalArgumentException("uri and properties are not supported when using Endpoint DSL ");
                        }
                        target.setDelegate(new FromDefinition(endpointUri));
                        break;
                    }
                    throw new IllegalArgumentException("Unsupported field: " + key);
                }
            }
        }
        if (target.getDelegate() == null) {
            ObjectHelper.notNull((Object)"uri", (String)"The uri must set");
            target.setDelegate(new FromDefinition(YamlSupport.createEndpointUri((CamelContext)dc.getCamelContext(), uri, properties)));
        }
    }
}

