/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import org.apache.camel.dsl.yaml.common.YamlDeserializerResolver;
import org.apache.camel.dsl.yaml.deserializers.ModelDeserializers;
import org.snakeyaml.engine.v2.api.ConstructNode;

public final class ModelDeserializersResolver
implements YamlDeserializerResolver {
    public int getOrder() {
        return 2147482646;
    }

    public ConstructNode resolve(String id) {
        switch (id) {
            case "asn1": {
                return new ModelDeserializers.ASN1DataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.ASN1DataFormat": {
                return new ModelDeserializers.ASN1DataFormatDeserializer();
            }
            case "aggregate": {
                return new ModelDeserializers.AggregateDefinitionDeserializer();
            }
            case "org.apache.camel.model.AggregateDefinition": {
                return new ModelDeserializers.AggregateDefinitionDeserializer();
            }
            case "api-key": {
                return new ModelDeserializers.ApiKeyDefinitionDeserializer();
            }
            case "apiKey": {
                return new ModelDeserializers.ApiKeyDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.ApiKeyDefinition": {
                return new ModelDeserializers.ApiKeyDefinitionDeserializer();
            }
            case "avro": {
                return new ModelDeserializers.AvroDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.AvroDataFormat": {
                return new ModelDeserializers.AvroDataFormatDeserializer();
            }
            case "barcode": {
                return new ModelDeserializers.BarcodeDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.BarcodeDataFormat": {
                return new ModelDeserializers.BarcodeDataFormatDeserializer();
            }
            case "base64": {
                return new ModelDeserializers.Base64DataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.Base64DataFormat": {
                return new ModelDeserializers.Base64DataFormatDeserializer();
            }
            case "basic-auth": {
                return new ModelDeserializers.BasicAuthDefinitionDeserializer();
            }
            case "basicAuth": {
                return new ModelDeserializers.BasicAuthDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.BasicAuthDefinition": {
                return new ModelDeserializers.BasicAuthDefinitionDeserializer();
            }
            case "batch-config": {
                return new ModelDeserializers.BatchResequencerConfigDeserializer();
            }
            case "batchConfig": {
                return new ModelDeserializers.BatchResequencerConfigDeserializer();
            }
            case "org.apache.camel.model.config.BatchResequencerConfig": {
                return new ModelDeserializers.BatchResequencerConfigDeserializer();
            }
            case "org.apache.camel.model.app.BeanConstructorDefinition": {
                return new ModelDeserializers.BeanConstructorDefinitionDeserializer();
            }
            case "org.apache.camel.model.app.BeanConstructorsDefinition": {
                return new ModelDeserializers.BeanConstructorsDefinitionDeserializer();
            }
            case "bean": {
                return new ModelDeserializers.BeanDefinitionDeserializer();
            }
            case "org.apache.camel.model.BeanDefinition": {
                return new ModelDeserializers.BeanDefinitionDeserializer();
            }
            case "org.apache.camel.model.app.BeanPropertiesDefinition": {
                return new ModelDeserializers.BeanPropertiesDefinitionDeserializer();
            }
            case "org.apache.camel.model.app.BeanPropertyDefinition": {
                return new ModelDeserializers.BeanPropertyDefinitionDeserializer();
            }
            case "bearer-token": {
                return new ModelDeserializers.BearerTokenDefinitionDeserializer();
            }
            case "bearerToken": {
                return new ModelDeserializers.BearerTokenDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.BearerTokenDefinition": {
                return new ModelDeserializers.BearerTokenDefinitionDeserializer();
            }
            case "bindy": {
                return new ModelDeserializers.BindyDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.BindyDataFormat": {
                return new ModelDeserializers.BindyDataFormatDeserializer();
            }
            case "blacklist-service-filter": {
                return new ModelDeserializers.BlacklistServiceCallServiceFilterConfigurationDeserializer();
            }
            case "blacklistServiceFilter": {
                return new ModelDeserializers.BlacklistServiceCallServiceFilterConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.BlacklistServiceCallServiceFilterConfiguration": {
                return new ModelDeserializers.BlacklistServiceCallServiceFilterConfigurationDeserializer();
            }
            case "cbor": {
                return new ModelDeserializers.CBORDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.CBORDataFormat": {
                return new ModelDeserializers.CBORDataFormatDeserializer();
            }
            case "csimple": {
                return new ModelDeserializers.CSimpleExpressionDeserializer();
            }
            case "org.apache.camel.model.language.CSimpleExpression": {
                return new ModelDeserializers.CSimpleExpressionDeserializer();
            }
            case "caching-service-discovery": {
                return new ModelDeserializers.CachingServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "cachingServiceDiscovery": {
                return new ModelDeserializers.CachingServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.CachingServiceCallServiceDiscoveryConfiguration": {
                return new ModelDeserializers.CachingServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "do-catch": {
                return new ModelDeserializers.CatchDefinitionDeserializer();
            }
            case "doCatch": {
                return new ModelDeserializers.CatchDefinitionDeserializer();
            }
            case "org.apache.camel.model.CatchDefinition": {
                return new ModelDeserializers.CatchDefinitionDeserializer();
            }
            case "choice": {
                return new ModelDeserializers.ChoiceDefinitionDeserializer();
            }
            case "org.apache.camel.model.ChoiceDefinition": {
                return new ModelDeserializers.ChoiceDefinitionDeserializer();
            }
            case "circuit-breaker": {
                return new ModelDeserializers.CircuitBreakerDefinitionDeserializer();
            }
            case "circuitBreaker": {
                return new ModelDeserializers.CircuitBreakerDefinitionDeserializer();
            }
            case "org.apache.camel.model.CircuitBreakerDefinition": {
                return new ModelDeserializers.CircuitBreakerDefinitionDeserializer();
            }
            case "claim-check": {
                return new ModelDeserializers.ClaimCheckDefinitionDeserializer();
            }
            case "claimCheck": {
                return new ModelDeserializers.ClaimCheckDefinitionDeserializer();
            }
            case "org.apache.camel.model.ClaimCheckDefinition": {
                return new ModelDeserializers.ClaimCheckDefinitionDeserializer();
            }
            case "combined-service-discovery": {
                return new ModelDeserializers.CombinedServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "combinedServiceDiscovery": {
                return new ModelDeserializers.CombinedServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.CombinedServiceCallServiceDiscoveryConfiguration": {
                return new ModelDeserializers.CombinedServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "combined-service-filter": {
                return new ModelDeserializers.CombinedServiceCallServiceFilterConfigurationDeserializer();
            }
            case "combinedServiceFilter": {
                return new ModelDeserializers.CombinedServiceCallServiceFilterConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.CombinedServiceCallServiceFilterConfiguration": {
                return new ModelDeserializers.CombinedServiceCallServiceFilterConfigurationDeserializer();
            }
            case "org.apache.camel.model.app.ComponentScanDefinition": {
                return new ModelDeserializers.ComponentScanDefinitionDeserializer();
            }
            case "constant": {
                return new ModelDeserializers.ConstantExpressionDeserializer();
            }
            case "org.apache.camel.model.language.ConstantExpression": {
                return new ModelDeserializers.ConstantExpressionDeserializer();
            }
            case "consul-service-discovery": {
                return new ModelDeserializers.ConsulServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "consulServiceDiscovery": {
                return new ModelDeserializers.ConsulServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.ConsulServiceCallServiceDiscoveryConfiguration": {
                return new ModelDeserializers.ConsulServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "context-scan": {
                return new ModelDeserializers.ContextScanDefinitionDeserializer();
            }
            case "contextScan": {
                return new ModelDeserializers.ContextScanDefinitionDeserializer();
            }
            case "org.apache.camel.model.ContextScanDefinition": {
                return new ModelDeserializers.ContextScanDefinitionDeserializer();
            }
            case "convert-body-to": {
                return new ModelDeserializers.ConvertBodyDefinitionDeserializer();
            }
            case "convertBodyTo": {
                return new ModelDeserializers.ConvertBodyDefinitionDeserializer();
            }
            case "org.apache.camel.model.ConvertBodyDefinition": {
                return new ModelDeserializers.ConvertBodyDefinitionDeserializer();
            }
            case "convert-header-to": {
                return new ModelDeserializers.ConvertHeaderDefinitionDeserializer();
            }
            case "convertHeaderTo": {
                return new ModelDeserializers.ConvertHeaderDefinitionDeserializer();
            }
            case "org.apache.camel.model.ConvertHeaderDefinition": {
                return new ModelDeserializers.ConvertHeaderDefinitionDeserializer();
            }
            case "crypto": {
                return new ModelDeserializers.CryptoDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.CryptoDataFormat": {
                return new ModelDeserializers.CryptoDataFormatDeserializer();
            }
            case "csv": {
                return new ModelDeserializers.CsvDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.CsvDataFormat": {
                return new ModelDeserializers.CsvDataFormatDeserializer();
            }
            case "custom": {
                return new ModelDeserializers.CustomDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.CustomDataFormat": {
                return new ModelDeserializers.CustomDataFormatDeserializer();
            }
            case "custom-load-balancer": {
                return new ModelDeserializers.CustomLoadBalancerDefinitionDeserializer();
            }
            case "customLoadBalancer": {
                return new ModelDeserializers.CustomLoadBalancerDefinitionDeserializer();
            }
            case "org.apache.camel.model.loadbalancer.CustomLoadBalancerDefinition": {
                return new ModelDeserializers.CustomLoadBalancerDefinitionDeserializer();
            }
            case "custom-service-filter": {
                return new ModelDeserializers.CustomServiceCallServiceFilterConfigurationDeserializer();
            }
            case "customServiceFilter": {
                return new ModelDeserializers.CustomServiceCallServiceFilterConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.CustomServiceCallServiceFilterConfiguration": {
                return new ModelDeserializers.CustomServiceCallServiceFilterConfigurationDeserializer();
            }
            case "org.apache.camel.model.transformer.CustomTransformerDefinition": {
                return new ModelDeserializers.CustomTransformerDefinitionDeserializer();
            }
            case "org.apache.camel.model.validator.CustomValidatorDefinition": {
                return new ModelDeserializers.CustomValidatorDefinitionDeserializer();
            }
            case "org.apache.camel.model.DataFormatDefinition": {
                return new ModelDeserializers.DataFormatDefinitionDeserializer();
            }
            case "org.apache.camel.model.transformer.DataFormatTransformerDefinition": {
                return new ModelDeserializers.DataFormatTransformerDefinitionDeserializer();
            }
            case "data-formats": {
                return new ModelDeserializers.DataFormatsDefinitionDeserializer();
            }
            case "dataFormats": {
                return new ModelDeserializers.DataFormatsDefinitionDeserializer();
            }
            case "org.apache.camel.model.dataformat.DataFormatsDefinition": {
                return new ModelDeserializers.DataFormatsDefinitionDeserializer();
            }
            case "datasonnet": {
                return new ModelDeserializers.DatasonnetExpressionDeserializer();
            }
            case "org.apache.camel.model.language.DatasonnetExpression": {
                return new ModelDeserializers.DatasonnetExpressionDeserializer();
            }
            case "dead-letter-channel": {
                return new ModelDeserializers.DeadLetterChannelDefinitionDeserializer();
            }
            case "deadLetterChannel": {
                return new ModelDeserializers.DeadLetterChannelDefinitionDeserializer();
            }
            case "org.apache.camel.model.errorhandler.DeadLetterChannelDefinition": {
                return new ModelDeserializers.DeadLetterChannelDefinitionDeserializer();
            }
            case "default-error-handler": {
                return new ModelDeserializers.DefaultErrorHandlerDefinitionDeserializer();
            }
            case "defaultErrorHandler": {
                return new ModelDeserializers.DefaultErrorHandlerDefinitionDeserializer();
            }
            case "org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition": {
                return new ModelDeserializers.DefaultErrorHandlerDefinitionDeserializer();
            }
            case "default-load-balancer": {
                return new ModelDeserializers.DefaultServiceCallServiceLoadBalancerConfigurationDeserializer();
            }
            case "defaultLoadBalancer": {
                return new ModelDeserializers.DefaultServiceCallServiceLoadBalancerConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.DefaultServiceCallServiceLoadBalancerConfiguration": {
                return new ModelDeserializers.DefaultServiceCallServiceLoadBalancerConfigurationDeserializer();
            }
            case "delay": {
                return new ModelDeserializers.DelayDefinitionDeserializer();
            }
            case "org.apache.camel.model.DelayDefinition": {
                return new ModelDeserializers.DelayDefinitionDeserializer();
            }
            case "delete": {
                return new ModelDeserializers.DeleteDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.DeleteDefinition": {
                return new ModelDeserializers.DeleteDefinitionDeserializer();
            }
            case "dns-service-discovery": {
                return new ModelDeserializers.DnsServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "dnsServiceDiscovery": {
                return new ModelDeserializers.DnsServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.DnsServiceCallServiceDiscoveryConfiguration": {
                return new ModelDeserializers.DnsServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "dynamic-router": {
                return new ModelDeserializers.DynamicRouterDefinitionDeserializer();
            }
            case "dynamicRouter": {
                return new ModelDeserializers.DynamicRouterDefinitionDeserializer();
            }
            case "org.apache.camel.model.DynamicRouterDefinition": {
                return new ModelDeserializers.DynamicRouterDefinitionDeserializer();
            }
            case "org.apache.camel.model.transformer.EndpointTransformerDefinition": {
                return new ModelDeserializers.EndpointTransformerDefinitionDeserializer();
            }
            case "org.apache.camel.model.validator.EndpointValidatorDefinition": {
                return new ModelDeserializers.EndpointValidatorDefinitionDeserializer();
            }
            case "enrich": {
                return new ModelDeserializers.EnrichDefinitionDeserializer();
            }
            case "org.apache.camel.model.EnrichDefinition": {
                return new ModelDeserializers.EnrichDefinitionDeserializer();
            }
            case "error-handler": {
                return new ModelDeserializers.ErrorHandlerDefinitionDeserializer();
            }
            case "errorHandler": {
                return new ModelDeserializers.ErrorHandlerDefinitionDeserializer();
            }
            case "org.apache.camel.model.ErrorHandlerDefinition": {
                return new ModelDeserializers.ErrorHandlerDefinitionDeserializer();
            }
            case "exchange-property": {
                return new ModelDeserializers.ExchangePropertyExpressionDeserializer();
            }
            case "exchangeProperty": {
                return new ModelDeserializers.ExchangePropertyExpressionDeserializer();
            }
            case "org.apache.camel.model.language.ExchangePropertyExpression": {
                return new ModelDeserializers.ExchangePropertyExpressionDeserializer();
            }
            case "failover": {
                return new ModelDeserializers.FailoverLoadBalancerDefinitionDeserializer();
            }
            case "org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition": {
                return new ModelDeserializers.FailoverLoadBalancerDefinitionDeserializer();
            }
            case "fault-tolerance-configuration": {
                return new ModelDeserializers.FaultToleranceConfigurationDefinitionDeserializer();
            }
            case "faultToleranceConfiguration": {
                return new ModelDeserializers.FaultToleranceConfigurationDefinitionDeserializer();
            }
            case "org.apache.camel.model.FaultToleranceConfigurationDefinition": {
                return new ModelDeserializers.FaultToleranceConfigurationDefinitionDeserializer();
            }
            case "fhir-json": {
                return new ModelDeserializers.FhirJsonDataFormatDeserializer();
            }
            case "fhirJson": {
                return new ModelDeserializers.FhirJsonDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.FhirJsonDataFormat": {
                return new ModelDeserializers.FhirJsonDataFormatDeserializer();
            }
            case "fhir-xml": {
                return new ModelDeserializers.FhirXmlDataFormatDeserializer();
            }
            case "fhirXml": {
                return new ModelDeserializers.FhirXmlDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.FhirXmlDataFormat": {
                return new ModelDeserializers.FhirXmlDataFormatDeserializer();
            }
            case "filter": {
                return new ModelDeserializers.FilterDefinitionDeserializer();
            }
            case "org.apache.camel.model.FilterDefinition": {
                return new ModelDeserializers.FilterDefinitionDeserializer();
            }
            case "do-finally": {
                return new ModelDeserializers.FinallyDefinitionDeserializer();
            }
            case "doFinally": {
                return new ModelDeserializers.FinallyDefinitionDeserializer();
            }
            case "org.apache.camel.model.FinallyDefinition": {
                return new ModelDeserializers.FinallyDefinitionDeserializer();
            }
            case "flatpack": {
                return new ModelDeserializers.FlatpackDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.FlatpackDataFormat": {
                return new ModelDeserializers.FlatpackDataFormatDeserializer();
            }
            case "get": {
                return new ModelDeserializers.GetDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.GetDefinition": {
                return new ModelDeserializers.GetDefinitionDeserializer();
            }
            case "global-option": {
                return new ModelDeserializers.GlobalOptionDefinitionDeserializer();
            }
            case "globalOption": {
                return new ModelDeserializers.GlobalOptionDefinitionDeserializer();
            }
            case "org.apache.camel.model.GlobalOptionDefinition": {
                return new ModelDeserializers.GlobalOptionDefinitionDeserializer();
            }
            case "global-options": {
                return new ModelDeserializers.GlobalOptionsDefinitionDeserializer();
            }
            case "globalOptions": {
                return new ModelDeserializers.GlobalOptionsDefinitionDeserializer();
            }
            case "org.apache.camel.model.GlobalOptionsDefinition": {
                return new ModelDeserializers.GlobalOptionsDefinitionDeserializer();
            }
            case "grok": {
                return new ModelDeserializers.GrokDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.GrokDataFormat": {
                return new ModelDeserializers.GrokDataFormatDeserializer();
            }
            case "groovy": {
                return new ModelDeserializers.GroovyExpressionDeserializer();
            }
            case "org.apache.camel.model.language.GroovyExpression": {
                return new ModelDeserializers.GroovyExpressionDeserializer();
            }
            case "gzip-deflater": {
                return new ModelDeserializers.GzipDeflaterDataFormatDeserializer();
            }
            case "gzipDeflater": {
                return new ModelDeserializers.GzipDeflaterDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.GzipDeflaterDataFormat": {
                return new ModelDeserializers.GzipDeflaterDataFormatDeserializer();
            }
            case "hl7": {
                return new ModelDeserializers.HL7DataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.HL7DataFormat": {
                return new ModelDeserializers.HL7DataFormatDeserializer();
            }
            case "head": {
                return new ModelDeserializers.HeadDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.HeadDefinition": {
                return new ModelDeserializers.HeadDefinitionDeserializer();
            }
            case "header": {
                return new ModelDeserializers.HeaderExpressionDeserializer();
            }
            case "org.apache.camel.model.language.HeaderExpression": {
                return new ModelDeserializers.HeaderExpressionDeserializer();
            }
            case "healthy-service-filter": {
                return new ModelDeserializers.HealthyServiceCallServiceFilterConfigurationDeserializer();
            }
            case "healthyServiceFilter": {
                return new ModelDeserializers.HealthyServiceCallServiceFilterConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.HealthyServiceCallServiceFilterConfiguration": {
                return new ModelDeserializers.HealthyServiceCallServiceFilterConfigurationDeserializer();
            }
            case "hl7terser": {
                return new ModelDeserializers.Hl7TerserExpressionDeserializer();
            }
            case "org.apache.camel.model.language.Hl7TerserExpression": {
                return new ModelDeserializers.Hl7TerserExpressionDeserializer();
            }
            case "ical": {
                return new ModelDeserializers.IcalDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.IcalDataFormat": {
                return new ModelDeserializers.IcalDataFormatDeserializer();
            }
            case "idempotent-consumer": {
                return new ModelDeserializers.IdempotentConsumerDefinitionDeserializer();
            }
            case "idempotentConsumer": {
                return new ModelDeserializers.IdempotentConsumerDefinitionDeserializer();
            }
            case "org.apache.camel.model.IdempotentConsumerDefinition": {
                return new ModelDeserializers.IdempotentConsumerDefinitionDeserializer();
            }
            case "input-type": {
                return new ModelDeserializers.InputTypeDefinitionDeserializer();
            }
            case "inputType": {
                return new ModelDeserializers.InputTypeDefinitionDeserializer();
            }
            case "org.apache.camel.model.InputTypeDefinition": {
                return new ModelDeserializers.InputTypeDefinitionDeserializer();
            }
            case "intercept": {
                return new ModelDeserializers.InterceptDefinitionDeserializer();
            }
            case "org.apache.camel.model.InterceptDefinition": {
                return new ModelDeserializers.InterceptDefinitionDeserializer();
            }
            case "intercept-from": {
                return new ModelDeserializers.InterceptFromDefinitionDeserializer();
            }
            case "interceptFrom": {
                return new ModelDeserializers.InterceptFromDefinitionDeserializer();
            }
            case "org.apache.camel.model.InterceptFromDefinition": {
                return new ModelDeserializers.InterceptFromDefinitionDeserializer();
            }
            case "intercept-send-to-endpoint": {
                return new ModelDeserializers.InterceptSendToEndpointDefinitionDeserializer();
            }
            case "interceptSendToEndpoint": {
                return new ModelDeserializers.InterceptSendToEndpointDefinitionDeserializer();
            }
            case "org.apache.camel.model.InterceptSendToEndpointDefinition": {
                return new ModelDeserializers.InterceptSendToEndpointDefinitionDeserializer();
            }
            case "jackson-xml": {
                return new ModelDeserializers.JacksonXMLDataFormatDeserializer();
            }
            case "jacksonXml": {
                return new ModelDeserializers.JacksonXMLDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.JacksonXMLDataFormat": {
                return new ModelDeserializers.JacksonXMLDataFormatDeserializer();
            }
            case "java": {
                return new ModelDeserializers.JavaExpressionDeserializer();
            }
            case "org.apache.camel.model.language.JavaExpression": {
                return new ModelDeserializers.JavaExpressionDeserializer();
            }
            case "js": {
                return new ModelDeserializers.JavaScriptExpressionDeserializer();
            }
            case "org.apache.camel.model.language.JavaScriptExpression": {
                return new ModelDeserializers.JavaScriptExpressionDeserializer();
            }
            case "jaxb": {
                return new ModelDeserializers.JaxbDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.JaxbDataFormat": {
                return new ModelDeserializers.JaxbDataFormatDeserializer();
            }
            case "joor": {
                return new ModelDeserializers.JoorExpressionDeserializer();
            }
            case "org.apache.camel.model.language.JoorExpression": {
                return new ModelDeserializers.JoorExpressionDeserializer();
            }
            case "jq": {
                return new ModelDeserializers.JqExpressionDeserializer();
            }
            case "org.apache.camel.model.language.JqExpression": {
                return new ModelDeserializers.JqExpressionDeserializer();
            }
            case "json-api": {
                return new ModelDeserializers.JsonApiDataFormatDeserializer();
            }
            case "jsonApi": {
                return new ModelDeserializers.JsonApiDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.JsonApiDataFormat": {
                return new ModelDeserializers.JsonApiDataFormatDeserializer();
            }
            case "json": {
                return new ModelDeserializers.JsonDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.JsonDataFormat": {
                return new ModelDeserializers.JsonDataFormatDeserializer();
            }
            case "jsonpath": {
                return new ModelDeserializers.JsonPathExpressionDeserializer();
            }
            case "org.apache.camel.model.language.JsonPathExpression": {
                return new ModelDeserializers.JsonPathExpressionDeserializer();
            }
            case "jta-transaction-error-handler": {
                return new ModelDeserializers.JtaTransactionErrorHandlerDefinitionDeserializer();
            }
            case "jtaTransactionErrorHandler": {
                return new ModelDeserializers.JtaTransactionErrorHandlerDefinitionDeserializer();
            }
            case "org.apache.camel.model.errorhandler.JtaTransactionErrorHandlerDefinition": {
                return new ModelDeserializers.JtaTransactionErrorHandlerDefinitionDeserializer();
            }
            case "kubernetes-service-discovery": {
                return new ModelDeserializers.KubernetesServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "kubernetesServiceDiscovery": {
                return new ModelDeserializers.KubernetesServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.KubernetesServiceCallServiceDiscoveryConfiguration": {
                return new ModelDeserializers.KubernetesServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "lzf": {
                return new ModelDeserializers.LZFDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.LZFDataFormat": {
                return new ModelDeserializers.LZFDataFormatDeserializer();
            }
            case "language": {
                return new ModelDeserializers.LanguageExpressionDeserializer();
            }
            case "org.apache.camel.model.language.LanguageExpression": {
                return new ModelDeserializers.LanguageExpressionDeserializer();
            }
            case "load-balance": {
                return new ModelDeserializers.LoadBalanceDefinitionDeserializer();
            }
            case "loadBalance": {
                return new ModelDeserializers.LoadBalanceDefinitionDeserializer();
            }
            case "org.apache.camel.model.LoadBalanceDefinition": {
                return new ModelDeserializers.LoadBalanceDefinitionDeserializer();
            }
            case "org.apache.camel.model.transformer.LoadTransformerDefinition": {
                return new ModelDeserializers.LoadTransformerDefinitionDeserializer();
            }
            case "log": {
                return new ModelDeserializers.LogDefinitionDeserializer();
            }
            case "org.apache.camel.model.LogDefinition": {
                return new ModelDeserializers.LogDefinitionDeserializer();
            }
            case "loop": {
                return new ModelDeserializers.LoopDefinitionDeserializer();
            }
            case "org.apache.camel.model.LoopDefinition": {
                return new ModelDeserializers.LoopDefinitionDeserializer();
            }
            case "marshal": {
                return new ModelDeserializers.MarshalDefinitionDeserializer();
            }
            case "org.apache.camel.model.MarshalDefinition": {
                return new ModelDeserializers.MarshalDefinitionDeserializer();
            }
            case "method": {
                return new ModelDeserializers.MethodCallExpressionDeserializer();
            }
            case "org.apache.camel.model.language.MethodCallExpression": {
                return new ModelDeserializers.MethodCallExpressionDeserializer();
            }
            case "mime-multipart": {
                return new ModelDeserializers.MimeMultipartDataFormatDeserializer();
            }
            case "mimeMultipart": {
                return new ModelDeserializers.MimeMultipartDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.MimeMultipartDataFormat": {
                return new ModelDeserializers.MimeMultipartDataFormatDeserializer();
            }
            case "multicast": {
                return new ModelDeserializers.MulticastDefinitionDeserializer();
            }
            case "org.apache.camel.model.MulticastDefinition": {
                return new ModelDeserializers.MulticastDefinitionDeserializer();
            }
            case "mutual-tls": {
                return new ModelDeserializers.MutualTLSDefinitionDeserializer();
            }
            case "mutualTLS": {
                return new ModelDeserializers.MutualTLSDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.MutualTLSDefinition": {
                return new ModelDeserializers.MutualTLSDefinitionDeserializer();
            }
            case "mvel": {
                return new ModelDeserializers.MvelExpressionDeserializer();
            }
            case "org.apache.camel.model.language.MvelExpression": {
                return new ModelDeserializers.MvelExpressionDeserializer();
            }
            case "no-error-handler": {
                return new ModelDeserializers.NoErrorHandlerDefinitionDeserializer();
            }
            case "noErrorHandler": {
                return new ModelDeserializers.NoErrorHandlerDefinitionDeserializer();
            }
            case "org.apache.camel.model.errorhandler.NoErrorHandlerDefinition": {
                return new ModelDeserializers.NoErrorHandlerDefinitionDeserializer();
            }
            case "oauth2": {
                return new ModelDeserializers.OAuth2DefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.OAuth2Definition": {
                return new ModelDeserializers.OAuth2DefinitionDeserializer();
            }
            case "ognl": {
                return new ModelDeserializers.OgnlExpressionDeserializer();
            }
            case "org.apache.camel.model.language.OgnlExpression": {
                return new ModelDeserializers.OgnlExpressionDeserializer();
            }
            case "on-completion": {
                return new ModelDeserializers.OnCompletionDefinitionDeserializer();
            }
            case "onCompletion": {
                return new ModelDeserializers.OnCompletionDefinitionDeserializer();
            }
            case "org.apache.camel.model.OnCompletionDefinition": {
                return new ModelDeserializers.OnCompletionDefinitionDeserializer();
            }
            case "on-exception": {
                return new ModelDeserializers.OnExceptionDefinitionDeserializer();
            }
            case "onException": {
                return new ModelDeserializers.OnExceptionDefinitionDeserializer();
            }
            case "org.apache.camel.model.OnExceptionDefinition": {
                return new ModelDeserializers.OnExceptionDefinitionDeserializer();
            }
            case "on-fallback": {
                return new ModelDeserializers.OnFallbackDefinitionDeserializer();
            }
            case "onFallback": {
                return new ModelDeserializers.OnFallbackDefinitionDeserializer();
            }
            case "org.apache.camel.model.OnFallbackDefinition": {
                return new ModelDeserializers.OnFallbackDefinitionDeserializer();
            }
            case "open-id-connect": {
                return new ModelDeserializers.OpenIdConnectDefinitionDeserializer();
            }
            case "openIdConnect": {
                return new ModelDeserializers.OpenIdConnectDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.OpenIdConnectDefinition": {
                return new ModelDeserializers.OpenIdConnectDefinitionDeserializer();
            }
            case "optimistic-lock-retry-policy": {
                return new ModelDeserializers.OptimisticLockRetryPolicyDefinitionDeserializer();
            }
            case "optimisticLockRetryPolicy": {
                return new ModelDeserializers.OptimisticLockRetryPolicyDefinitionDeserializer();
            }
            case "org.apache.camel.model.OptimisticLockRetryPolicyDefinition": {
                return new ModelDeserializers.OptimisticLockRetryPolicyDefinitionDeserializer();
            }
            case "otherwise": {
                return new ModelDeserializers.OtherwiseDefinitionDeserializer();
            }
            case "org.apache.camel.model.OtherwiseDefinition": {
                return new ModelDeserializers.OtherwiseDefinitionDeserializer();
            }
            case "org.apache.camel.model.OutputDefinition": {
                return new ModelDeserializers.OutputDefinitionDeserializer();
            }
            case "output-type": {
                return new ModelDeserializers.OutputTypeDefinitionDeserializer();
            }
            case "outputType": {
                return new ModelDeserializers.OutputTypeDefinitionDeserializer();
            }
            case "org.apache.camel.model.OutputTypeDefinition": {
                return new ModelDeserializers.OutputTypeDefinitionDeserializer();
            }
            case "pgp": {
                return new ModelDeserializers.PGPDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.PGPDataFormat": {
                return new ModelDeserializers.PGPDataFormatDeserializer();
            }
            case "package-scan": {
                return new ModelDeserializers.PackageScanDefinitionDeserializer();
            }
            case "packageScan": {
                return new ModelDeserializers.PackageScanDefinitionDeserializer();
            }
            case "org.apache.camel.model.PackageScanDefinition": {
                return new ModelDeserializers.PackageScanDefinitionDeserializer();
            }
            case "param": {
                return new ModelDeserializers.ParamDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.ParamDefinition": {
                return new ModelDeserializers.ParamDefinitionDeserializer();
            }
            case "parquet-avro": {
                return new ModelDeserializers.ParquetAvroDataFormatDeserializer();
            }
            case "parquetAvro": {
                return new ModelDeserializers.ParquetAvroDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.ParquetAvroDataFormat": {
                return new ModelDeserializers.ParquetAvroDataFormatDeserializer();
            }
            case "pass-through-service-filter": {
                return new ModelDeserializers.PassThroughServiceCallServiceFilterConfigurationDeserializer();
            }
            case "passThroughServiceFilter": {
                return new ModelDeserializers.PassThroughServiceCallServiceFilterConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.PassThroughServiceCallServiceFilterConfiguration": {
                return new ModelDeserializers.PassThroughServiceCallServiceFilterConfigurationDeserializer();
            }
            case "patch": {
                return new ModelDeserializers.PatchDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.PatchDefinition": {
                return new ModelDeserializers.PatchDefinitionDeserializer();
            }
            case "pausable": {
                return new ModelDeserializers.PausableDefinitionDeserializer();
            }
            case "org.apache.camel.model.PausableDefinition": {
                return new ModelDeserializers.PausableDefinitionDeserializer();
            }
            case "pipeline": {
                return new ModelDeserializers.PipelineDefinitionDeserializer();
            }
            case "org.apache.camel.model.PipelineDefinition": {
                return new ModelDeserializers.PipelineDefinitionDeserializer();
            }
            case "policy": {
                return new ModelDeserializers.PolicyDefinitionDeserializer();
            }
            case "org.apache.camel.model.PolicyDefinition": {
                return new ModelDeserializers.PolicyDefinitionDeserializer();
            }
            case "poll-enrich": {
                return new ModelDeserializers.PollEnrichDefinitionDeserializer();
            }
            case "pollEnrich": {
                return new ModelDeserializers.PollEnrichDefinitionDeserializer();
            }
            case "org.apache.camel.model.PollEnrichDefinition": {
                return new ModelDeserializers.PollEnrichDefinitionDeserializer();
            }
            case "post": {
                return new ModelDeserializers.PostDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.PostDefinition": {
                return new ModelDeserializers.PostDefinitionDeserializer();
            }
            case "org.apache.camel.model.validator.PredicateValidatorDefinition": {
                return new ModelDeserializers.PredicateValidatorDefinitionDeserializer();
            }
            case "process": {
                return new ModelDeserializers.ProcessDefinitionDeserializer();
            }
            case "org.apache.camel.model.ProcessDefinition": {
                return new ModelDeserializers.ProcessDefinitionDeserializer();
            }
            case "property": {
                return new ModelDeserializers.PropertyDefinitionDeserializer();
            }
            case "org.apache.camel.model.PropertyDefinition": {
                return new ModelDeserializers.PropertyDefinitionDeserializer();
            }
            case "property-expression": {
                return new ModelDeserializers.PropertyExpressionDefinitionDeserializer();
            }
            case "propertyExpression": {
                return new ModelDeserializers.PropertyExpressionDefinitionDeserializer();
            }
            case "org.apache.camel.model.PropertyExpressionDefinition": {
                return new ModelDeserializers.PropertyExpressionDefinitionDeserializer();
            }
            case "protobuf": {
                return new ModelDeserializers.ProtobufDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.ProtobufDataFormat": {
                return new ModelDeserializers.ProtobufDataFormatDeserializer();
            }
            case "put": {
                return new ModelDeserializers.PutDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.PutDefinition": {
                return new ModelDeserializers.PutDefinitionDeserializer();
            }
            case "python": {
                return new ModelDeserializers.PythonExpressionDeserializer();
            }
            case "org.apache.camel.model.language.PythonExpression": {
                return new ModelDeserializers.PythonExpressionDeserializer();
            }
            case "random": {
                return new ModelDeserializers.RandomLoadBalancerDefinitionDeserializer();
            }
            case "org.apache.camel.model.loadbalancer.RandomLoadBalancerDefinition": {
                return new ModelDeserializers.RandomLoadBalancerDefinitionDeserializer();
            }
            case "recipient-list": {
                return new ModelDeserializers.RecipientListDefinitionDeserializer();
            }
            case "recipientList": {
                return new ModelDeserializers.RecipientListDefinitionDeserializer();
            }
            case "org.apache.camel.model.RecipientListDefinition": {
                return new ModelDeserializers.RecipientListDefinitionDeserializer();
            }
            case "redelivery-policy": {
                return new ModelDeserializers.RedeliveryPolicyDefinitionDeserializer();
            }
            case "redeliveryPolicy": {
                return new ModelDeserializers.RedeliveryPolicyDefinitionDeserializer();
            }
            case "org.apache.camel.model.RedeliveryPolicyDefinition": {
                return new ModelDeserializers.RedeliveryPolicyDefinitionDeserializer();
            }
            case "ref-error-handler": {
                return new ModelDeserializers.RefErrorHandlerDefinitionDeserializer();
            }
            case "refErrorHandler": {
                return new ModelDeserializers.RefErrorHandlerDefinitionDeserializer();
            }
            case "org.apache.camel.model.errorhandler.RefErrorHandlerDefinition": {
                return new ModelDeserializers.RefErrorHandlerDefinitionDeserializer();
            }
            case "ref": {
                return new ModelDeserializers.RefExpressionDeserializer();
            }
            case "org.apache.camel.model.language.RefExpression": {
                return new ModelDeserializers.RefExpressionDeserializer();
            }
            case "org.apache.camel.model.app.RegistryBeanDefinition": {
                return new ModelDeserializers.RegistryBeanDefinitionDeserializer();
            }
            case "remove-header": {
                return new ModelDeserializers.RemoveHeaderDefinitionDeserializer();
            }
            case "removeHeader": {
                return new ModelDeserializers.RemoveHeaderDefinitionDeserializer();
            }
            case "org.apache.camel.model.RemoveHeaderDefinition": {
                return new ModelDeserializers.RemoveHeaderDefinitionDeserializer();
            }
            case "remove-headers": {
                return new ModelDeserializers.RemoveHeadersDefinitionDeserializer();
            }
            case "removeHeaders": {
                return new ModelDeserializers.RemoveHeadersDefinitionDeserializer();
            }
            case "org.apache.camel.model.RemoveHeadersDefinition": {
                return new ModelDeserializers.RemoveHeadersDefinitionDeserializer();
            }
            case "remove-properties": {
                return new ModelDeserializers.RemovePropertiesDefinitionDeserializer();
            }
            case "removeProperties": {
                return new ModelDeserializers.RemovePropertiesDefinitionDeserializer();
            }
            case "org.apache.camel.model.RemovePropertiesDefinition": {
                return new ModelDeserializers.RemovePropertiesDefinitionDeserializer();
            }
            case "remove-property": {
                return new ModelDeserializers.RemovePropertyDefinitionDeserializer();
            }
            case "removeProperty": {
                return new ModelDeserializers.RemovePropertyDefinitionDeserializer();
            }
            case "org.apache.camel.model.RemovePropertyDefinition": {
                return new ModelDeserializers.RemovePropertyDefinitionDeserializer();
            }
            case "resequence": {
                return new ModelDeserializers.ResequenceDefinitionDeserializer();
            }
            case "org.apache.camel.model.ResequenceDefinition": {
                return new ModelDeserializers.ResequenceDefinitionDeserializer();
            }
            case "resilience4j-configuration": {
                return new ModelDeserializers.Resilience4jConfigurationDefinitionDeserializer();
            }
            case "resilience4jConfiguration": {
                return new ModelDeserializers.Resilience4jConfigurationDefinitionDeserializer();
            }
            case "org.apache.camel.model.Resilience4jConfigurationDefinition": {
                return new ModelDeserializers.Resilience4jConfigurationDefinitionDeserializer();
            }
            case "response-header": {
                return new ModelDeserializers.ResponseHeaderDefinitionDeserializer();
            }
            case "responseHeader": {
                return new ModelDeserializers.ResponseHeaderDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.ResponseHeaderDefinition": {
                return new ModelDeserializers.ResponseHeaderDefinitionDeserializer();
            }
            case "response-message": {
                return new ModelDeserializers.ResponseMessageDefinitionDeserializer();
            }
            case "responseMessage": {
                return new ModelDeserializers.ResponseMessageDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.ResponseMessageDefinition": {
                return new ModelDeserializers.ResponseMessageDefinitionDeserializer();
            }
            case "rest-binding": {
                return new ModelDeserializers.RestBindingDefinitionDeserializer();
            }
            case "restBinding": {
                return new ModelDeserializers.RestBindingDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.RestBindingDefinition": {
                return new ModelDeserializers.RestBindingDefinitionDeserializer();
            }
            case "rest-configuration": {
                return new ModelDeserializers.RestConfigurationDefinitionDeserializer();
            }
            case "restConfiguration": {
                return new ModelDeserializers.RestConfigurationDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.RestConfigurationDefinition": {
                return new ModelDeserializers.RestConfigurationDefinitionDeserializer();
            }
            case "rest-context-ref": {
                return new ModelDeserializers.RestContextRefDefinitionDeserializer();
            }
            case "restContextRef": {
                return new ModelDeserializers.RestContextRefDefinitionDeserializer();
            }
            case "org.apache.camel.model.RestContextRefDefinition": {
                return new ModelDeserializers.RestContextRefDefinitionDeserializer();
            }
            case "rest": {
                return new ModelDeserializers.RestDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.RestDefinition": {
                return new ModelDeserializers.RestDefinitionDeserializer();
            }
            case "rest-property": {
                return new ModelDeserializers.RestPropertyDefinitionDeserializer();
            }
            case "restProperty": {
                return new ModelDeserializers.RestPropertyDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.RestPropertyDefinition": {
                return new ModelDeserializers.RestPropertyDefinitionDeserializer();
            }
            case "security-definitions": {
                return new ModelDeserializers.RestSecuritiesDefinitionDeserializer();
            }
            case "securityDefinitions": {
                return new ModelDeserializers.RestSecuritiesDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.RestSecuritiesDefinition": {
                return new ModelDeserializers.RestSecuritiesDefinitionDeserializer();
            }
            case "rests": {
                return new ModelDeserializers.RestsDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.RestsDefinition": {
                return new ModelDeserializers.RestsDefinitionDeserializer();
            }
            case "resumable": {
                return new ModelDeserializers.ResumableDefinitionDeserializer();
            }
            case "org.apache.camel.model.ResumableDefinition": {
                return new ModelDeserializers.ResumableDefinitionDeserializer();
            }
            case "rollback": {
                return new ModelDeserializers.RollbackDefinitionDeserializer();
            }
            case "org.apache.camel.model.RollbackDefinition": {
                return new ModelDeserializers.RollbackDefinitionDeserializer();
            }
            case "round-robin": {
                return new ModelDeserializers.RoundRobinLoadBalancerDefinitionDeserializer();
            }
            case "roundRobin": {
                return new ModelDeserializers.RoundRobinLoadBalancerDefinitionDeserializer();
            }
            case "org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition": {
                return new ModelDeserializers.RoundRobinLoadBalancerDefinitionDeserializer();
            }
            case "route-builder": {
                return new ModelDeserializers.RouteBuilderDefinitionDeserializer();
            }
            case "routeBuilder": {
                return new ModelDeserializers.RouteBuilderDefinitionDeserializer();
            }
            case "org.apache.camel.model.RouteBuilderDefinition": {
                return new ModelDeserializers.RouteBuilderDefinitionDeserializer();
            }
            case "route-configuration-context-ref": {
                return new ModelDeserializers.RouteConfigurationContextRefDefinitionDeserializer();
            }
            case "routeConfigurationContextRef": {
                return new ModelDeserializers.RouteConfigurationContextRefDefinitionDeserializer();
            }
            case "org.apache.camel.model.RouteConfigurationContextRefDefinition": {
                return new ModelDeserializers.RouteConfigurationContextRefDefinitionDeserializer();
            }
            case "route-context-ref": {
                return new ModelDeserializers.RouteContextRefDefinitionDeserializer();
            }
            case "routeContextRef": {
                return new ModelDeserializers.RouteContextRefDefinitionDeserializer();
            }
            case "org.apache.camel.model.RouteContextRefDefinition": {
                return new ModelDeserializers.RouteContextRefDefinitionDeserializer();
            }
            case "route": {
                return new ModelDeserializers.RouteDefinitionDeserializer();
            }
            case "org.apache.camel.model.RouteDefinition": {
                return new ModelDeserializers.RouteDefinitionDeserializer();
            }
            case "template-parameter": {
                return new ModelDeserializers.RouteTemplateParameterDefinitionDeserializer();
            }
            case "templateParameter": {
                return new ModelDeserializers.RouteTemplateParameterDefinitionDeserializer();
            }
            case "org.apache.camel.model.RouteTemplateParameterDefinition": {
                return new ModelDeserializers.RouteTemplateParameterDefinitionDeserializer();
            }
            case "routing-slip": {
                return new ModelDeserializers.RoutingSlipDefinitionDeserializer();
            }
            case "routingSlip": {
                return new ModelDeserializers.RoutingSlipDefinitionDeserializer();
            }
            case "org.apache.camel.model.RoutingSlipDefinition": {
                return new ModelDeserializers.RoutingSlipDefinitionDeserializer();
            }
            case "rss": {
                return new ModelDeserializers.RssDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.RssDataFormat": {
                return new ModelDeserializers.RssDataFormatDeserializer();
            }
            case "org.apache.camel.model.SagaActionUriDefinition": {
                return new ModelDeserializers.SagaActionUriDefinitionDeserializer();
            }
            case "saga": {
                return new ModelDeserializers.SagaDefinitionDeserializer();
            }
            case "org.apache.camel.model.SagaDefinition": {
                return new ModelDeserializers.SagaDefinitionDeserializer();
            }
            case "sample": {
                return new ModelDeserializers.SamplingDefinitionDeserializer();
            }
            case "org.apache.camel.model.SamplingDefinition": {
                return new ModelDeserializers.SamplingDefinitionDeserializer();
            }
            case "script": {
                return new ModelDeserializers.ScriptDefinitionDeserializer();
            }
            case "org.apache.camel.model.ScriptDefinition": {
                return new ModelDeserializers.ScriptDefinitionDeserializer();
            }
            case "security": {
                return new ModelDeserializers.SecurityDefinitionDeserializer();
            }
            case "org.apache.camel.model.rest.SecurityDefinition": {
                return new ModelDeserializers.SecurityDefinitionDeserializer();
            }
            case "service-call-configuration": {
                return new ModelDeserializers.ServiceCallConfigurationDefinitionDeserializer();
            }
            case "serviceCallConfiguration": {
                return new ModelDeserializers.ServiceCallConfigurationDefinitionDeserializer();
            }
            case "org.apache.camel.model.cloud.ServiceCallConfigurationDefinition": {
                return new ModelDeserializers.ServiceCallConfigurationDefinitionDeserializer();
            }
            case "service-call": {
                return new ModelDeserializers.ServiceCallDefinitionDeserializer();
            }
            case "serviceCall": {
                return new ModelDeserializers.ServiceCallDefinitionDeserializer();
            }
            case "org.apache.camel.model.cloud.ServiceCallDefinition": {
                return new ModelDeserializers.ServiceCallDefinitionDeserializer();
            }
            case "service-expression": {
                return new ModelDeserializers.ServiceCallExpressionConfigurationDeserializer();
            }
            case "serviceExpression": {
                return new ModelDeserializers.ServiceCallExpressionConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.ServiceCallExpressionConfiguration": {
                return new ModelDeserializers.ServiceCallExpressionConfigurationDeserializer();
            }
            case "service-chooser-configuration": {
                return new ModelDeserializers.ServiceCallServiceChooserConfigurationDeserializer();
            }
            case "serviceChooserConfiguration": {
                return new ModelDeserializers.ServiceCallServiceChooserConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.ServiceCallServiceChooserConfiguration": {
                return new ModelDeserializers.ServiceCallServiceChooserConfigurationDeserializer();
            }
            case "service-discovery-configuration": {
                return new ModelDeserializers.ServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "serviceDiscoveryConfiguration": {
                return new ModelDeserializers.ServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.ServiceCallServiceDiscoveryConfiguration": {
                return new ModelDeserializers.ServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "service-filter-configuration": {
                return new ModelDeserializers.ServiceCallServiceFilterConfigurationDeserializer();
            }
            case "serviceFilterConfiguration": {
                return new ModelDeserializers.ServiceCallServiceFilterConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.ServiceCallServiceFilterConfiguration": {
                return new ModelDeserializers.ServiceCallServiceFilterConfigurationDeserializer();
            }
            case "load-balancer-configuration": {
                return new ModelDeserializers.ServiceCallServiceLoadBalancerConfigurationDeserializer();
            }
            case "loadBalancerConfiguration": {
                return new ModelDeserializers.ServiceCallServiceLoadBalancerConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.ServiceCallServiceLoadBalancerConfiguration": {
                return new ModelDeserializers.ServiceCallServiceLoadBalancerConfigurationDeserializer();
            }
            case "set-body": {
                return new ModelDeserializers.SetBodyDefinitionDeserializer();
            }
            case "setBody": {
                return new ModelDeserializers.SetBodyDefinitionDeserializer();
            }
            case "org.apache.camel.model.SetBodyDefinition": {
                return new ModelDeserializers.SetBodyDefinitionDeserializer();
            }
            case "set-exchange-pattern": {
                return new ModelDeserializers.SetExchangePatternDefinitionDeserializer();
            }
            case "setExchangePattern": {
                return new ModelDeserializers.SetExchangePatternDefinitionDeserializer();
            }
            case "org.apache.camel.model.SetExchangePatternDefinition": {
                return new ModelDeserializers.SetExchangePatternDefinitionDeserializer();
            }
            case "set-header": {
                return new ModelDeserializers.SetHeaderDefinitionDeserializer();
            }
            case "setHeader": {
                return new ModelDeserializers.SetHeaderDefinitionDeserializer();
            }
            case "org.apache.camel.model.SetHeaderDefinition": {
                return new ModelDeserializers.SetHeaderDefinitionDeserializer();
            }
            case "set-headers": {
                return new ModelDeserializers.SetHeadersDefinitionDeserializer();
            }
            case "setHeaders": {
                return new ModelDeserializers.SetHeadersDefinitionDeserializer();
            }
            case "org.apache.camel.model.SetHeadersDefinition": {
                return new ModelDeserializers.SetHeadersDefinitionDeserializer();
            }
            case "set-property": {
                return new ModelDeserializers.SetPropertyDefinitionDeserializer();
            }
            case "setProperty": {
                return new ModelDeserializers.SetPropertyDefinitionDeserializer();
            }
            case "org.apache.camel.model.SetPropertyDefinition": {
                return new ModelDeserializers.SetPropertyDefinitionDeserializer();
            }
            case "simple": {
                return new ModelDeserializers.SimpleExpressionDeserializer();
            }
            case "org.apache.camel.model.language.SimpleExpression": {
                return new ModelDeserializers.SimpleExpressionDeserializer();
            }
            case "soap": {
                return new ModelDeserializers.SoapDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.SoapDataFormat": {
                return new ModelDeserializers.SoapDataFormatDeserializer();
            }
            case "sort": {
                return new ModelDeserializers.SortDefinitionDeserializer();
            }
            case "org.apache.camel.model.SortDefinition": {
                return new ModelDeserializers.SortDefinitionDeserializer();
            }
            case "spel": {
                return new ModelDeserializers.SpELExpressionDeserializer();
            }
            case "org.apache.camel.model.language.SpELExpression": {
                return new ModelDeserializers.SpELExpressionDeserializer();
            }
            case "split": {
                return new ModelDeserializers.SplitDefinitionDeserializer();
            }
            case "org.apache.camel.model.SplitDefinition": {
                return new ModelDeserializers.SplitDefinitionDeserializer();
            }
            case "spring-transaction-error-handler": {
                return new ModelDeserializers.SpringTransactionErrorHandlerDefinitionDeserializer();
            }
            case "springTransactionErrorHandler": {
                return new ModelDeserializers.SpringTransactionErrorHandlerDefinitionDeserializer();
            }
            case "org.apache.camel.model.errorhandler.SpringTransactionErrorHandlerDefinition": {
                return new ModelDeserializers.SpringTransactionErrorHandlerDefinitionDeserializer();
            }
            case "static-service-discovery": {
                return new ModelDeserializers.StaticServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "staticServiceDiscovery": {
                return new ModelDeserializers.StaticServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.StaticServiceCallServiceDiscoveryConfiguration": {
                return new ModelDeserializers.StaticServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "step": {
                return new ModelDeserializers.StepDefinitionDeserializer();
            }
            case "org.apache.camel.model.StepDefinition": {
                return new ModelDeserializers.StepDefinitionDeserializer();
            }
            case "sticky": {
                return new ModelDeserializers.StickyLoadBalancerDefinitionDeserializer();
            }
            case "org.apache.camel.model.loadbalancer.StickyLoadBalancerDefinition": {
                return new ModelDeserializers.StickyLoadBalancerDefinitionDeserializer();
            }
            case "stop": {
                return new ModelDeserializers.StopDefinitionDeserializer();
            }
            case "org.apache.camel.model.StopDefinition": {
                return new ModelDeserializers.StopDefinitionDeserializer();
            }
            case "stream-config": {
                return new ModelDeserializers.StreamResequencerConfigDeserializer();
            }
            case "streamConfig": {
                return new ModelDeserializers.StreamResequencerConfigDeserializer();
            }
            case "org.apache.camel.model.config.StreamResequencerConfig": {
                return new ModelDeserializers.StreamResequencerConfigDeserializer();
            }
            case "swift-mt": {
                return new ModelDeserializers.SwiftMtDataFormatDeserializer();
            }
            case "swiftMt": {
                return new ModelDeserializers.SwiftMtDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.SwiftMtDataFormat": {
                return new ModelDeserializers.SwiftMtDataFormatDeserializer();
            }
            case "swift-mx": {
                return new ModelDeserializers.SwiftMxDataFormatDeserializer();
            }
            case "swiftMx": {
                return new ModelDeserializers.SwiftMxDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.SwiftMxDataFormat": {
                return new ModelDeserializers.SwiftMxDataFormatDeserializer();
            }
            case "syslog": {
                return new ModelDeserializers.SyslogDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.SyslogDataFormat": {
                return new ModelDeserializers.SyslogDataFormatDeserializer();
            }
            case "tar-file": {
                return new ModelDeserializers.TarFileDataFormatDeserializer();
            }
            case "tarFile": {
                return new ModelDeserializers.TarFileDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.TarFileDataFormat": {
                return new ModelDeserializers.TarFileDataFormatDeserializer();
            }
            case "templated-route-parameter": {
                return new ModelDeserializers.TemplatedRouteParameterDefinitionDeserializer();
            }
            case "templatedRouteParameter": {
                return new ModelDeserializers.TemplatedRouteParameterDefinitionDeserializer();
            }
            case "org.apache.camel.model.TemplatedRouteParameterDefinition": {
                return new ModelDeserializers.TemplatedRouteParameterDefinitionDeserializer();
            }
            case "thread-pool-profile": {
                return new ModelDeserializers.ThreadPoolProfileDefinitionDeserializer();
            }
            case "threadPoolProfile": {
                return new ModelDeserializers.ThreadPoolProfileDefinitionDeserializer();
            }
            case "org.apache.camel.model.ThreadPoolProfileDefinition": {
                return new ModelDeserializers.ThreadPoolProfileDefinitionDeserializer();
            }
            case "threads": {
                return new ModelDeserializers.ThreadsDefinitionDeserializer();
            }
            case "org.apache.camel.model.ThreadsDefinition": {
                return new ModelDeserializers.ThreadsDefinitionDeserializer();
            }
            case "thrift": {
                return new ModelDeserializers.ThriftDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.ThriftDataFormat": {
                return new ModelDeserializers.ThriftDataFormatDeserializer();
            }
            case "throttle": {
                return new ModelDeserializers.ThrottleDefinitionDeserializer();
            }
            case "org.apache.camel.model.ThrottleDefinition": {
                return new ModelDeserializers.ThrottleDefinitionDeserializer();
            }
            case "throw-exception": {
                return new ModelDeserializers.ThrowExceptionDefinitionDeserializer();
            }
            case "throwException": {
                return new ModelDeserializers.ThrowExceptionDefinitionDeserializer();
            }
            case "org.apache.camel.model.ThrowExceptionDefinition": {
                return new ModelDeserializers.ThrowExceptionDefinitionDeserializer();
            }
            case "tidy-markup": {
                return new ModelDeserializers.TidyMarkupDataFormatDeserializer();
            }
            case "tidyMarkup": {
                return new ModelDeserializers.TidyMarkupDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.TidyMarkupDataFormat": {
                return new ModelDeserializers.TidyMarkupDataFormatDeserializer();
            }
            case "to": {
                return new ModelDeserializers.ToDefinitionDeserializer();
            }
            case "org.apache.camel.model.ToDefinition": {
                return new ModelDeserializers.ToDefinitionDeserializer();
            }
            case "to-d": {
                return new ModelDeserializers.ToDynamicDefinitionDeserializer();
            }
            case "toD": {
                return new ModelDeserializers.ToDynamicDefinitionDeserializer();
            }
            case "org.apache.camel.model.ToDynamicDefinition": {
                return new ModelDeserializers.ToDynamicDefinitionDeserializer();
            }
            case "tokenize": {
                return new ModelDeserializers.TokenizerExpressionDeserializer();
            }
            case "org.apache.camel.model.language.TokenizerExpression": {
                return new ModelDeserializers.TokenizerExpressionDeserializer();
            }
            case "topic": {
                return new ModelDeserializers.TopicLoadBalancerDefinitionDeserializer();
            }
            case "org.apache.camel.model.loadbalancer.TopicLoadBalancerDefinition": {
                return new ModelDeserializers.TopicLoadBalancerDefinitionDeserializer();
            }
            case "transacted": {
                return new ModelDeserializers.TransactedDefinitionDeserializer();
            }
            case "org.apache.camel.model.TransactedDefinition": {
                return new ModelDeserializers.TransactedDefinitionDeserializer();
            }
            case "transform": {
                return new ModelDeserializers.TransformDefinitionDeserializer();
            }
            case "org.apache.camel.model.TransformDefinition": {
                return new ModelDeserializers.TransformDefinitionDeserializer();
            }
            case "transformers": {
                return new ModelDeserializers.TransformersDefinitionDeserializer();
            }
            case "org.apache.camel.model.transformer.TransformersDefinition": {
                return new ModelDeserializers.TransformersDefinitionDeserializer();
            }
            case "do-try": {
                return new ModelDeserializers.TryDefinitionDeserializer();
            }
            case "doTry": {
                return new ModelDeserializers.TryDefinitionDeserializer();
            }
            case "org.apache.camel.model.TryDefinition": {
                return new ModelDeserializers.TryDefinitionDeserializer();
            }
            case "univocity-csv": {
                return new ModelDeserializers.UniVocityCsvDataFormatDeserializer();
            }
            case "univocityCsv": {
                return new ModelDeserializers.UniVocityCsvDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.UniVocityCsvDataFormat": {
                return new ModelDeserializers.UniVocityCsvDataFormatDeserializer();
            }
            case "univocity-fixed": {
                return new ModelDeserializers.UniVocityFixedDataFormatDeserializer();
            }
            case "univocityFixed": {
                return new ModelDeserializers.UniVocityFixedDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.UniVocityFixedDataFormat": {
                return new ModelDeserializers.UniVocityFixedDataFormatDeserializer();
            }
            case "univocity-header": {
                return new ModelDeserializers.UniVocityHeaderDeserializer();
            }
            case "univocityHeader": {
                return new ModelDeserializers.UniVocityHeaderDeserializer();
            }
            case "org.apache.camel.model.dataformat.UniVocityHeader": {
                return new ModelDeserializers.UniVocityHeaderDeserializer();
            }
            case "univocity-tsv": {
                return new ModelDeserializers.UniVocityTsvDataFormatDeserializer();
            }
            case "univocityTsv": {
                return new ModelDeserializers.UniVocityTsvDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.UniVocityTsvDataFormat": {
                return new ModelDeserializers.UniVocityTsvDataFormatDeserializer();
            }
            case "unmarshal": {
                return new ModelDeserializers.UnmarshalDefinitionDeserializer();
            }
            case "org.apache.camel.model.UnmarshalDefinition": {
                return new ModelDeserializers.UnmarshalDefinitionDeserializer();
            }
            case "validate": {
                return new ModelDeserializers.ValidateDefinitionDeserializer();
            }
            case "org.apache.camel.model.ValidateDefinition": {
                return new ModelDeserializers.ValidateDefinitionDeserializer();
            }
            case "validators": {
                return new ModelDeserializers.ValidatorsDefinitionDeserializer();
            }
            case "org.apache.camel.model.validator.ValidatorsDefinition": {
                return new ModelDeserializers.ValidatorsDefinitionDeserializer();
            }
            case "value": {
                return new ModelDeserializers.ValueDefinitionDeserializer();
            }
            case "org.apache.camel.model.ValueDefinition": {
                return new ModelDeserializers.ValueDefinitionDeserializer();
            }
            case "weighted": {
                return new ModelDeserializers.WeightedLoadBalancerDefinitionDeserializer();
            }
            case "org.apache.camel.model.loadbalancer.WeightedLoadBalancerDefinition": {
                return new ModelDeserializers.WeightedLoadBalancerDefinitionDeserializer();
            }
            case "when": {
                return new ModelDeserializers.WhenDefinitionDeserializer();
            }
            case "org.apache.camel.model.WhenDefinition": {
                return new ModelDeserializers.WhenDefinitionDeserializer();
            }
            case "when-skip-send-to-endpoint": {
                return new ModelDeserializers.WhenSkipSendToEndpointDefinitionDeserializer();
            }
            case "whenSkipSendToEndpoint": {
                return new ModelDeserializers.WhenSkipSendToEndpointDefinitionDeserializer();
            }
            case "org.apache.camel.model.WhenSkipSendToEndpointDefinition": {
                return new ModelDeserializers.WhenSkipSendToEndpointDefinitionDeserializer();
            }
            case "wire-tap": {
                return new ModelDeserializers.WireTapDefinitionDeserializer();
            }
            case "wireTap": {
                return new ModelDeserializers.WireTapDefinitionDeserializer();
            }
            case "org.apache.camel.model.WireTapDefinition": {
                return new ModelDeserializers.WireTapDefinitionDeserializer();
            }
            case "xml-security": {
                return new ModelDeserializers.XMLSecurityDataFormatDeserializer();
            }
            case "xmlSecurity": {
                return new ModelDeserializers.XMLSecurityDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.XMLSecurityDataFormat": {
                return new ModelDeserializers.XMLSecurityDataFormatDeserializer();
            }
            case "xtokenize": {
                return new ModelDeserializers.XMLTokenizerExpressionDeserializer();
            }
            case "org.apache.camel.model.language.XMLTokenizerExpression": {
                return new ModelDeserializers.XMLTokenizerExpressionDeserializer();
            }
            case "xpath": {
                return new ModelDeserializers.XPathExpressionDeserializer();
            }
            case "org.apache.camel.model.language.XPathExpression": {
                return new ModelDeserializers.XPathExpressionDeserializer();
            }
            case "xquery": {
                return new ModelDeserializers.XQueryExpressionDeserializer();
            }
            case "org.apache.camel.model.language.XQueryExpression": {
                return new ModelDeserializers.XQueryExpressionDeserializer();
            }
            case "yaml": {
                return new ModelDeserializers.YAMLDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.YAMLDataFormat": {
                return new ModelDeserializers.YAMLDataFormatDeserializer();
            }
            case "type-filter": {
                return new ModelDeserializers.YAMLTypeFilterDefinitionDeserializer();
            }
            case "typeFilter": {
                return new ModelDeserializers.YAMLTypeFilterDefinitionDeserializer();
            }
            case "org.apache.camel.model.dataformat.YAMLTypeFilterDefinition": {
                return new ModelDeserializers.YAMLTypeFilterDefinitionDeserializer();
            }
            case "zip-deflater": {
                return new ModelDeserializers.ZipDeflaterDataFormatDeserializer();
            }
            case "zipDeflater": {
                return new ModelDeserializers.ZipDeflaterDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.ZipDeflaterDataFormat": {
                return new ModelDeserializers.ZipDeflaterDataFormatDeserializer();
            }
            case "zip-file": {
                return new ModelDeserializers.ZipFileDataFormatDeserializer();
            }
            case "zipFile": {
                return new ModelDeserializers.ZipFileDataFormatDeserializer();
            }
            case "org.apache.camel.model.dataformat.ZipFileDataFormat": {
                return new ModelDeserializers.ZipFileDataFormatDeserializer();
            }
            case "zookeeper-service-discovery": {
                return new ModelDeserializers.ZooKeeperServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "zookeeperServiceDiscovery": {
                return new ModelDeserializers.ZooKeeperServiceCallServiceDiscoveryConfigurationDeserializer();
            }
            case "org.apache.camel.model.cloud.ZooKeeperServiceCallServiceDiscoveryConfiguration": {
                return new ModelDeserializers.ZooKeeperServiceCallServiceDiscoveryConfigurationDeserializer();
            }
        }
        return null;
    }
}

