/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.model.Model;
import org.apache.camel.model.app.RegistryBeanDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.spi.annotations.YamlIn;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

@YamlIn
@YamlType(nodes={"beans"}, order=0, properties={@YamlProperty(name="__extends", type="array:org.apache.camel.model.app.RegistryBeanDefinition")})
public class BeansDeserializer
extends YamlDeserializerSupport
implements ConstructNode {
    public static final Logger LOG = LoggerFactory.getLogger(BeansDeserializer.class);
    private final Set<String> beanCache = new HashSet<String>();
    private final Map<String, KeyValueHolder<Object, String>> beansToDestroy = new LinkedHashMap<String, KeyValueHolder<Object, String>>();

    public Object construct(Node node) {
        BeansCustomizer answer = new BeansCustomizer();
        SequenceNode sn = BeansDeserializer.asSequenceNode((Node)node);
        YamlDeserializationContext dc = BeansDeserializer.getDeserializationContext((Node)node);
        for (Node item : sn.getValue()) {
            String key;
            boolean duplicate;
            BeansDeserializer.setDeserializationContext((Node)item, (YamlDeserializationContext)dc);
            RegistryBeanDefinition bean = (RegistryBeanDefinition)BeansDeserializer.asType((Node)item, RegistryBeanDefinition.class);
            if (dc != null) {
                bean.setResource(dc.getResource());
            }
            ObjectHelper.notNull((Object)bean.getName(), (String)"The bean name must be set");
            ObjectHelper.notNull((Object)bean.getType(), (String)"The bean type must be set");
            if (!bean.getType().startsWith("#class:")) {
                bean.setType("#class:" + bean.getType());
            }
            if (bean.getScriptLanguage() != null || bean.getScript() != null) {
                ObjectHelper.notNull((Object)bean.getScriptLanguage(), (String)"The bean script language must be set");
                ObjectHelper.notNull((Object)bean.getScript(), (String)"The bean script must be set");
            }
            if (duplicate = this.beanCache.contains(key = bean.getName() + ":" + bean.getType())) continue;
            answer.addBean(bean);
            this.beanCache.add(key);
        }
        return answer;
    }

    public void clearCache() {
        this.beanCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object newInstance(RegistryBeanDefinition def, CamelContext context) throws Exception {
        Object target;
        Object type = def.getType();
        if (def.getScriptLanguage() != null && def.getScript() != null) {
            Language lan = context.resolveLanguage(def.getScriptLanguage());
            ScriptingLanguage slan = lan instanceof ScriptingLanguage ? (ScriptingLanguage)lan : null;
            String fqn = def.getType();
            if (fqn.startsWith("#class:")) {
                fqn = fqn.substring(7);
            }
            Class clazz = context.getClassResolver().resolveMandatoryClass(fqn);
            if (slan != null) {
                HashMap<String, CamelContext> bindings = new HashMap<String, CamelContext>();
                bindings.put("context", context);
                target = slan.evaluate(def.getScript(), bindings, clazz);
            } else {
                ExchangeFactory ef = context.getCamelContextExtension().getExchangeFactory();
                Exchange dummy = ef.create(false);
                try {
                    String text = ScriptHelper.resolveOptionalExternalScript((CamelContext)context, (Exchange)dummy, (String)def.getScript());
                    Expression exp = lan.createExpression(text);
                    target = exp.evaluate(dummy, clazz);
                }
                finally {
                    ef.release(dummy);
                }
            }
            if (target == null) {
                throw new NoSuchBeanException(def.getName(), "Creating bean using script returned null");
            }
        } else if (def.getBuilderClass() != null) {
            Class clazz = context.getClassResolver().resolveMandatoryClass(def.getBuilderClass());
            Object builder = context.getInjector().newInstance(clazz);
            String bm = def.getBuilderMethod() != null ? def.getBuilderMethod() : "build";
            target = PropertyBindingSupport.build().withCamelContext(context).withTarget(builder).withRemoveParameters(true).withProperties(def.getProperties()).build(Object.class, bm);
        } else {
            if (def.getFactoryBean() != null && def.getFactoryMethod() != null) {
                type = (String)type + "#" + def.getFactoryBean() + ":" + def.getFactoryMethod();
            } else if (def.getFactoryMethod() != null) {
                type = (String)type + "#" + def.getFactoryMethod();
            }
            StringJoiner ctr = new StringJoiner(", ");
            if (def.getConstructors() != null && !def.getConstructors().isEmpty()) {
                TreeMap sorted = new TreeMap(def.getConstructors());
                for (Object val : sorted.values()) {
                    Object text = val.toString();
                    if (!StringHelper.isQuoted((String)text)) {
                        text = "\"" + (String)text + "\"";
                    }
                    ctr.add((CharSequence)text);
                }
                type = (String)type + "(" + String.valueOf(ctr) + ")";
            }
            target = PropertyBindingSupport.resolveBean((CamelContext)context, (Object)type);
        }
        if (def.getProperties() != null && !def.getProperties().isEmpty()) {
            PropertyBindingSupport.setPropertiesOnTarget((CamelContext)context, (Object)target, (Map)def.getProperties());
        }
        return target;
    }

    protected void registerBean(CamelContext camelContext, List<RegistryBeanDefinition> delayedRegistrations, RegistryBeanDefinition def, boolean delayIfFailed) {
        String name = def.getName();
        String type = def.getType();
        try {
            Object target = this.newInstance(def, camelContext);
            this.bindBean(camelContext, def, name, target);
        }
        catch (Exception e) {
            if (delayIfFailed) {
                delayedRegistrations.add(def);
            }
            String msg = name != null ? "Error creating bean: " + name + " of type: " + type : "Error creating bean: " + type;
            throw new RuntimeException(msg, e);
        }
    }

    protected void bindBean(CamelContext camelContext, RegistryBeanDefinition def, String name, Object target) throws Exception {
        this.destroyBean(name, true);
        camelContext.getRegistry().unbind(name);
        String initMethod = def.getInitMethod();
        if (initMethod != null) {
            org.apache.camel.support.ObjectHelper.invokeMethodSafe((String)initMethod, (Object)target, (Object[])new Object[0]);
        }
        camelContext.getRegistry().bind(name, target);
        if (def.getDestroyMethod() != null) {
            this.beansToDestroy.put(name, (KeyValueHolder<Object, String>)new KeyValueHolder(target, (Object)def.getDestroyMethod()));
        }
        Model model = (Model)camelContext.getCamelContextExtension().getContextPlugin(Model.class);
        model.addRegistryBean(def);
    }

    protected void destroyBean(String name, boolean remove) {
        KeyValueHolder<Object, String> holder;
        KeyValueHolder<Object, String> keyValueHolder = holder = remove ? this.beansToDestroy.remove(name) : this.beansToDestroy.get(name);
        if (holder != null) {
            String destroyMethod = (String)holder.getValue();
            Object target = holder.getKey();
            try {
                org.apache.camel.support.ObjectHelper.invokeMethodSafe((String)destroyMethod, (Object)target, (Object[])new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Error invoking destroy method: {} on bean: {} due to: {}. This exception is ignored.", new Object[]{destroyMethod, target, e.getMessage(), e});
            }
        }
    }

    public void stop() throws Exception {
        for (String name : this.beansToDestroy.keySet()) {
            this.destroyBean(name, false);
        }
        this.beansToDestroy.clear();
    }

    private class BeansCustomizer
    implements CamelContextCustomizer {
        private final List<RegistryBeanDefinition> delayedRegistrations = new ArrayList<RegistryBeanDefinition>();
        private final List<RegistryBeanDefinition> beans = new ArrayList<RegistryBeanDefinition>();

        private BeansCustomizer() {
        }

        public void addBean(RegistryBeanDefinition bean) {
            this.beans.add(bean);
        }

        public void configure(CamelContext camelContext) {
            for (RegistryBeanDefinition bean : this.beans) {
                BeansDeserializer.this.registerBean(camelContext, this.delayedRegistrations, bean, true);
            }
            this.beans.clear();
            for (RegistryBeanDefinition bean : this.delayedRegistrations) {
                BeansDeserializer.this.registerBean(camelContext, this.delayedRegistrations, bean, false);
            }
            this.delayedRegistrations.clear();
        }
    }
}

