/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.dsl.yaml;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.maven.dsl.yaml.GenerateYamlSupportMojo;
import org.apache.camel.maven.dsl.yaml.support.ToolingSupport;
import org.apache.camel.maven.dsl.yaml.support.TypeSpecHolder;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.util.StringHelper;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.Node;

@Mojo(name="generate-yaml-deserializers", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateYamlDeserializersMojo
extends GenerateYamlSupportMojo {
    @Parameter(defaultValue="org.apache.camel.dsl.yaml.deserializers")
    protected String packageName;
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File sourcesOutputDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;

    @Override
    protected void generate() throws MojoFailureException {
        try {
            this.write(this.generateExpressionDeserializers());
            this.write(this.generateEndpointProducer());
            this.write(this.generateEndpointConsumer());
            this.write(this.generateDeserializers());
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void write(TypeSpec ... specs) throws Exception {
        this.write(Arrays.asList(specs));
    }

    private void write(Collection<TypeSpec> specs) throws Exception {
        for (TypeSpec typeSpec : specs) {
            StringWriter sw = new StringWriter();
            JavaFile.builder((String)this.packageName, (TypeSpec)typeSpec).addFileComment("Generated by camel-yaml-dsl-maven-plugin - do NOT edit this file!", new Object[0]).indent("    ").build().writeTo((Appendable)sw);
            Path outputDirectory = this.sourcesOutputDir.toPath();
            if (!this.packageName.isEmpty()) {
                for (String packageComponent : this.packageName.split("\\.")) {
                    outputDirectory = outputDirectory.resolve(packageComponent);
                }
                Files.createDirectories(outputDirectory, new FileAttribute[0]);
            }
            FileUtil.updateFile((Path)outputDirectory.resolve(typeSpec.name + ".java"), (String)sw.toString());
        }
    }

    private TypeSpec generateExpressionDeserializers() {
        TypeSpec.Builder type = TypeSpec.classBuilder((String)"ExpressionDeserializers");
        type.addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.FINAL});
        type.superclass((TypeName)CN_DESERIALIZER_SUPPORT);
        type.addMethod(MethodSpec.constructorBuilder().addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PRIVATE}).build());
        type.addMethod(MethodSpec.methodBuilder((String)"constructExpressionType").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC}).addParameter(Node.class, "node", new javax.lang.model.element.Modifier[0]).returns((TypeName)CN_EXPRESSION_DEFINITION).addCode(CodeBlock.builder().addStatement("$T mn = asMappingNode(node)", new Object[]{CN_MAPPING_NODE}).beginControlFlow("if (mn.getValue().size() != 1)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("$T nt = mn.getValue().get(0)", new Object[]{CN_NODE_TUPLE}).addStatement("$T dc = getDeserializationContext(node)", new Object[]{CN_DESERIALIZATION_CONTEXT}).addStatement("String key = asText(nt.getKeyNode())", new Object[0]).addStatement("$T val = setDeserializationContext(nt.getValueNode(), dc)", new Object[]{CN_NODE}).addStatement("return constructExpressionType(key, val)", new Object[0]).build()).build());
        CodeBlock.Builder cb = CodeBlock.builder();
        cb.beginControlFlow("switch(id)", new Object[0]);
        this.elementsOf(EXPRESSION_DEFINITION_CLASS).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
            cb.beginControlFlow("case $S:", new Object[]{e.getKey()});
            cb.addStatement("return asType(node, $L.class)", new Object[]{((ClassInfo)e.getValue()).name().toString()});
            cb.endControlFlow();
            if (!((String)e.getKey()).equals(StringHelper.camelCaseToDash((String)((String)e.getKey())))) {
                cb.beginControlFlow("case $S:", new Object[]{StringHelper.camelCaseToDash((String)((String)e.getKey()))});
                cb.addStatement("return asType(node, $L.class)", new Object[]{((ClassInfo)e.getValue()).name().toString()});
                cb.endControlFlow();
            }
        });
        cb.beginControlFlow("case \"expression\":", new Object[0]);
        cb.addStatement("return constructExpressionType(node)", new Object[0]);
        cb.endControlFlow();
        cb.beginControlFlow("case \"expression-type\":", new Object[0]);
        cb.addStatement("return constructExpressionType(node)", new Object[0]);
        cb.endControlFlow();
        cb.beginControlFlow("case \"expressionType\":", new Object[0]);
        cb.addStatement("return constructExpressionType(node)", new Object[0]);
        cb.endControlFlow();
        cb.endControlFlow();
        cb.addStatement("return null", new Object[0]);
        type.addMethod(MethodSpec.methodBuilder((String)"constructExpressionType").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC}).addParameter(String.class, "id", new javax.lang.model.element.Modifier[0]).addParameter(Node.class, "node", new javax.lang.model.element.Modifier[0]).returns((TypeName)CN_EXPRESSION_DEFINITION).addCode(cb.build()).build());
        AnnotationSpec.Builder edAnnotation = AnnotationSpec.builder((ClassName)CN_YAML_TYPE);
        edAnnotation.addMember("types", "org.apache.camel.model.language.ExpressionDefinition.class", new Object[0]);
        edAnnotation.addMember("order", "org.apache.camel.dsl.yaml.common.YamlDeserializerResolver.ORDER_LOWEST - 1", new Object[0]);
        this.elementsOf(EXPRESSION_DEFINITION_CLASS).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
            edAnnotation.addMember("properties", "$L", new Object[]{GenerateYamlDeserializersMojo.yamlPropertyWithSubtype((String)e.getKey(), "object", ((ClassInfo)e.getValue()).name().toString())});
            if (!((String)e.getKey()).equals(StringHelper.camelCaseToDash((String)((String)e.getKey())))) {
                edAnnotation.addMember("properties", "$L", new Object[]{GenerateYamlDeserializersMojo.yamlPropertyWithSubtype(StringHelper.camelCaseToDash((String)((String)e.getKey())), "object", ((ClassInfo)e.getValue()).name().toString())});
            }
        });
        type.addType(TypeSpec.classBuilder((String)"ExpressionDefinitionDeserializers").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC}).addSuperinterface(ConstructNode.class).addAnnotation(edAnnotation.build()).addMethod(MethodSpec.methodBuilder((String)"construct").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Node.class, "node", new javax.lang.model.element.Modifier[0]).returns(Object.class).addStatement("return constructExpressionType(node)", new Object[0]).build()).build());
        AnnotationSpec.Builder esdAnnotation = AnnotationSpec.builder((ClassName)CN_YAML_TYPE);
        esdAnnotation.addMember("types", "org.apache.camel.model.ExpressionSubElementDefinition.class", new Object[0]);
        esdAnnotation.addMember("order", "org.apache.camel.dsl.yaml.common.YamlDeserializerResolver.ORDER_LOWEST - 1", new Object[0]);
        this.elementsOf(EXPRESSION_DEFINITION_CLASS).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
            esdAnnotation.addMember("properties", "$L", new Object[]{GenerateYamlDeserializersMojo.yamlPropertyWithSubtype((String)e.getKey(), "object", ((ClassInfo)e.getValue()).name().toString())});
            if (!((String)e.getKey()).equals(StringHelper.camelCaseToDash((String)((String)e.getKey())))) {
                esdAnnotation.addMember("properties", "$L", new Object[]{GenerateYamlDeserializersMojo.yamlPropertyWithSubtype(StringHelper.camelCaseToDash((String)((String)e.getKey())), "object", ((ClassInfo)e.getValue()).name().toString())});
            }
        });
        type.addType(TypeSpec.classBuilder((String)"ExpressionSubElementDefinitionDeserializers").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC}).addSuperinterface(ConstructNode.class).addAnnotation(esdAnnotation.build()).addMethod(MethodSpec.methodBuilder((String)"construct").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Node.class, "node", new javax.lang.model.element.Modifier[0]).returns(Object.class).addStatement("$T val = constructExpressionType(node)", new Object[]{CN_EXPRESSION_DEFINITION}).addStatement("return new org.apache.camel.model.ExpressionSubElementDefinition(val)", new Object[0]).build()).build());
        return type.build();
    }

    private Collection<TypeSpec> generateDeserializers() {
        TypeSpec.Builder deserializers = TypeSpec.classBuilder((String)"ModelDeserializers");
        deserializers.addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.FINAL});
        deserializers.superclass((TypeName)CN_DESERIALIZER_SUPPORT);
        deserializers.addMethod(MethodSpec.constructorBuilder().addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PRIVATE}).build());
        CodeBlock.Builder constructors = CodeBlock.builder();
        constructors.beginControlFlow("switch(id)", new Object[0]);
        this.all().filter(ci -> !ci.name().equals((Object)EXPRESSION_DEFINITION_CLASS) && !ci.name().equals((Object)EXPRESSION_SUBELEMENT_DEFINITION_CLASS)).map(this::generateParser).sorted(Comparator.comparing(o -> o.type.name)).collect(Collectors.toList()).forEach(holder -> {
            deserializers.addType(holder.type);
            if (holder.attributes.containsKey("node")) {
                holder.attributes.get("node").forEach(node -> constructors.addStatement("case $S: return new ModelDeserializers.$L()", new Object[]{node, holder.type.name}));
            }
            if (holder.attributes.containsKey("type")) {
                holder.attributes.get("type").forEach(type -> constructors.addStatement("case $S: return new ModelDeserializers.$L()", new Object[]{type, holder.type.name}));
            }
        });
        constructors.endControlFlow();
        constructors.addStatement("return null", new Object[0]);
        TypeSpec.Builder resolver = TypeSpec.classBuilder((String)"ModelDeserializersResolver");
        resolver.addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.FINAL});
        resolver.addSuperinterface((TypeName)CN_DESERIALIZER_RESOLVER);
        resolver.addMethod(MethodSpec.methodBuilder((String)"getOrder").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addAnnotation(Override.class).returns(Integer.TYPE).addStatement("return YamlDeserializerResolver.ORDER_LOWEST - 1", new Object[0]).build());
        resolver.addMethod(MethodSpec.methodBuilder((String)"resolve").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(String.class, "id", new javax.lang.model.element.Modifier[0]).returns(ConstructNode.class).addCode(constructors.build()).build());
        return Arrays.asList(deserializers.build(), resolver.build());
    }

    public final Collection<TypeSpec> generateEndpointConsumer() {
        return this.generateEndpoint("EndpointConsumerDeserializers", component -> !component.isProducerOnly(), (TypeName)ClassName.get((String)"org.apache.camel.model", (String)"FromDefinition", (String[])new String[0]));
    }

    public final Collection<TypeSpec> generateEndpointProducer() {
        return this.generateEndpoint("EndpointProducerDeserializers", component -> !component.isConsumerOnly(), (TypeName)ClassName.get((String)"org.apache.camel.model", (String)"ToDefinition", (String[])new String[0]));
    }

    public final Collection<TypeSpec> generateEndpoint(String className, Predicate<ComponentModel> componentFilter, TypeName superClass) {
        TypeSpec.Builder resolver = TypeSpec.classBuilder((String)(className + "Resolver"));
        resolver.addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.FINAL});
        resolver.addSuperinterface((TypeName)CN_DESERIALIZER_RESOLVER);
        CodeBlock.Builder sw = CodeBlock.builder();
        sw.beginControlFlow("switch(id)", new Object[0]);
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        catalog.findComponentNames().stream().map(arg_0 -> ((CamelCatalog)catalog).componentModel(arg_0)).filter(componentFilter).flatMap(component -> ToolingSupport.combine(component.getScheme(), component.getAlternativeSchemes())).sorted().distinct().forEach(scheme -> sw.add("case $S:\n", new Object[]{scheme}));
        sw.addStatement("return org.apache.camel.dsl.yaml.common.YamlSupport.creteEndpointUri(id, node)", new Object[]{superClass});
        sw.endControlFlow();
        sw.addStatement("return null", new Object[0]);
        resolver.addMethod(MethodSpec.methodBuilder((String)"getOrder").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addAnnotation(Override.class).returns(Integer.TYPE).addStatement("return YamlDeserializerResolver.ORDER_LOWEST", new Object[0]).build());
        resolver.addMethod(MethodSpec.methodBuilder((String)"resolveEndpointUri").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC}).addParameter(String.class, "id", new javax.lang.model.element.Modifier[0]).addParameter(Node.class, "node", new javax.lang.model.element.Modifier[0]).returns(String.class).addCode(sw.build()).build());
        resolver.addMethod(MethodSpec.methodBuilder((String)"resolve").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(String.class, "id", new javax.lang.model.element.Modifier[0]).returns(ConstructNode.class).addStatement("return node -> org.apache.camel.dsl.yaml.common.YamlSupport.creteEndpoint(id, node, $L::new)", new Object[]{superClass}).build());
        return Arrays.asList(resolver.build());
    }

    private TypeSpecHolder generateParser(ClassInfo info) {
        ClassName targetType = ClassName.get((String)info.name().prefix().toString(), (String)info.name().withoutPackagePrefix(), (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)(info.simpleName() + "Deserializer"));
        HashMap<String, Set<String>> attributes = new HashMap<String, Set<String>>();
        ArrayList<AnnotationSpec> properties = new ArrayList<AnnotationSpec>();
        AnnotationSpec.Builder yamlTypeAnnotation = AnnotationSpec.builder((ClassName)CN_YAML_TYPE);
        builder.addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC});
        if (this.extendsType(info, SEND_DEFINITION_CLASS) || this.extendsType(info, TO_DYNAMIC_DEFINITION_CLASS)) {
            builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)CN_ENDPOINT_AWARE_DESERIALIZER_BASE, (TypeName[])new TypeName[]{targetType}));
        } else {
            builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)CN_DESERIALIZER_BASE, (TypeName[])new TypeName[]{targetType}));
        }
        TypeSpecHolder.put(attributes, "type", info.name().toString());
        if (info.name().toString().equals("org.apache.camel.model.OnExceptionDefinition")) {
            builder.addAnnotation(CN_YAML_IN);
        }
        if (info.name().toString().equals("org.apache.camel.model.rest.RestDefinition")) {
            builder.addAnnotation(CN_YAML_IN);
        }
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addStatement("super($L.class)", new Object[]{info.simpleName()}).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"newInstance").addAnnotation(AnnotationSpec.builder(Override.class).build()).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PROTECTED}).returns((TypeName)targetType).addCode(CodeBlock.builder().addStatement("return new $L()", new Object[]{info.simpleName()}).build()).build());
        for (MethodInfo ctor : info.constructors()) {
            if (ctor.parameters().size() != 1 || !((Type)ctor.parameters().get(0)).name().equals((Object)STRING_CLASS)) continue;
            if ((ctor.flags() & 1) == 0) break;
            yamlTypeAnnotation.addMember("inline", "true", new Object[0]);
            builder.addMethod(MethodSpec.methodBuilder((String)"newInstance").addAnnotation(AnnotationSpec.builder(Override.class).build()).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PROTECTED}).addParameter(String.class, "value", new javax.lang.model.element.Modifier[0]).returns((TypeName)targetType).addCode(CodeBlock.builder().addStatement("return new $L(value)", new Object[]{info.simpleName()}).build()).build());
            break;
        }
        boolean caseAdded = false;
        CodeBlock.Builder setProperty = CodeBlock.builder();
        setProperty.beginControlFlow("switch(propertyKey)", new Object[0]);
        if (this.implementType(info, ERROR_HANDLER_BUILDER_CLASS)) {
            List methods = this.methods(info).stream().filter(mi -> Modifier.isPublic(mi.flags())).filter(mi -> mi.name().matches("^set[1-9A-Z].*$")).filter(mi -> mi.parameters().size() == 1).filter(mi -> PRIMITIVE_CLASSES.contains(((Type)mi.parameters().get(0)).name().toString())).filter(mi -> mi.returnType().kind() == Type.Kind.VOID).collect(Collectors.toList());
            for (MethodInfo method : methods) {
                if (!this.generateSetValue(setProperty, method, properties)) continue;
                caseAdded = true;
            }
        } else {
            for (FieldInfo field : this.fields(info)) {
                if (!this.generateSetValue(setProperty, field, properties)) continue;
                caseAdded = true;
            }
        }
        if (this.implementType(info, ID_AWARE_CLASS)) {
            setProperty.beginControlFlow("case $S:", new Object[]{"id"});
            setProperty.addStatement("String val = asText(node)", new Object[0]);
            setProperty.addStatement("target.setId(val)", new Object[0]);
            setProperty.addStatement("break", new Object[0]);
            setProperty.endControlFlow();
            setProperty.beginControlFlow("case $S:", new Object[]{"description"});
            setProperty.addStatement("org.apache.camel.model.DescriptionDefinition val = asType(node, org.apache.camel.model.DescriptionDefinition.class)", new Object[0]);
            setProperty.addStatement("target.setDescription(val)", new Object[0]);
            setProperty.addStatement("break", new Object[0]);
            setProperty.endControlFlow();
        }
        if (this.implementType(info, OUTPUT_NODE_CLASS)) {
            caseAdded = true;
            setProperty.beginControlFlow("case \"steps\":", new Object[0]);
            setProperty.addStatement("setSteps(target, node);", new Object[0]);
            setProperty.addStatement("break", new Object[0]);
            setProperty.endControlFlow();
            properties.add(GenerateYamlDeserializersMojo.yamlProperty("steps", "array:org.apache.camel.model.ProcessorDefinition"));
        }
        if (this.extendsType(info, SEND_DEFINITION_CLASS) || this.extendsType(info, TO_DYNAMIC_DEFINITION_CLASS)) {
            setProperty.beginControlFlow("default:", new Object[0]);
            setProperty.addStatement("String uri = EndpointProducerDeserializersResolver.resolveEndpointUri(propertyKey, node)", new Object[0]);
            setProperty.beginControlFlow("if (uri == null)", new Object[0]);
            setProperty.addStatement("return false", new Object[0]);
            setProperty.endControlFlow();
            setProperty.beginControlFlow("if (target.getUri() != null)", new Object[0]);
            setProperty.addStatement("throw new IllegalStateException(\"url must not be set when using Endpoint DSL\")", new Object[0]);
            setProperty.endControlFlow();
            setProperty.addStatement("target.setUri(uri)", new Object[0]);
            setProperty.endControlFlow();
            properties.add(GenerateYamlDeserializersMojo.yamlProperty("parameters", "object"));
            builder.addMethod(MethodSpec.methodBuilder((String)"setEndpointUri").addAnnotation(AnnotationSpec.builder(Override.class).build()).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PROTECTED}).addParameter(CamelContext.class, "camelContext", new javax.lang.model.element.Modifier[0]).addParameter((TypeName)targetType, "target", new javax.lang.model.element.Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Object.class)}), "parameters", new javax.lang.model.element.Modifier[0]).addCode(CodeBlock.builder().addStatement("target.setUri(org.apache.camel.dsl.yaml.common.YamlSupport.createEndpointUri(camelContext, target.getUri(), parameters))", new Object[0]).build()).build());
        } else if (this.implementType(info, HAS_EXPRESSION_TYPE_CLASS)) {
            setProperty.beginControlFlow("default:", new Object[0]);
            setProperty.addStatement("$T ed = target.getExpressionType()", new Object[]{CN_EXPRESSION_DEFINITION});
            setProperty.beginControlFlow("if (ed != null)", new Object[0]);
            setProperty.addStatement("throw new org.apache.camel.dsl.yaml.common.exception.UnsupportedFieldException(propertyName, \"an expression has already been configured (\" + ed + \")\")", new Object[0]);
            setProperty.endControlFlow();
            setProperty.addStatement("ed = ExpressionDeserializers.constructExpressionType(propertyKey, node)", new Object[0]);
            setProperty.beginControlFlow("if (ed != null)", new Object[0]);
            setProperty.addStatement("target.setExpressionType(ed)", new Object[0]);
            setProperty.nextControlFlow("else", new Object[0]);
            setProperty.addStatement("return false", new Object[0]);
            setProperty.endControlFlow();
            setProperty.endControlFlow();
            if (!this.extendsType(info, EXPRESSION_DEFINITION_CLASS)) {
                properties.add(GenerateYamlDeserializersMojo.yamlProperty("__extends", "object:org.apache.camel.model.language.ExpressionDefinition"));
            }
        } else {
            setProperty.beginControlFlow("default:", new Object[0]);
            setProperty.addStatement("return false", new Object[0]);
            setProperty.endControlFlow();
        }
        setProperty.endControlFlow();
        if (caseAdded) {
            setProperty.addStatement("return true", new Object[0]);
        }
        builder.addMethod(MethodSpec.methodBuilder((String)"setProperty").addAnnotation(AnnotationSpec.builder(Override.class).build()).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PROTECTED}).addParameter((TypeName)targetType, "target", new javax.lang.model.element.Modifier[0]).addParameter(String.class, "propertyKey", new javax.lang.model.element.Modifier[0]).addParameter(String.class, "propertyName", new javax.lang.model.element.Modifier[0]).addParameter(Node.class, "node", new javax.lang.model.element.Modifier[0]).returns(Boolean.TYPE).addCode(setProperty.build()).build());
        yamlTypeAnnotation.addMember("types", "$L.class", new Object[]{info.name().toString()});
        yamlTypeAnnotation.addMember("order", "org.apache.camel.dsl.yaml.common.YamlDeserializerResolver.ORDER_LOWEST - 1", new Object[]{info.name().toString()});
        GenerateYamlDeserializersMojo.annotationValue(info, XML_ROOT_ELEMENT_ANNOTATION_CLASS, "name").map(AnnotationValue::asString).filter(value -> !"##default".equals(value)).ifPresent(value -> {
            if (!Objects.equals(value, StringHelper.camelCaseToDash((String)value))) {
                yamlTypeAnnotation.addMember("nodes", "$S", new Object[]{StringHelper.camelCaseToDash((String)value)});
                TypeSpecHolder.put(attributes, "node", StringHelper.camelCaseToDash((String)value));
            }
            yamlTypeAnnotation.addMember("nodes", "$S", new Object[]{value});
            TypeSpecHolder.put(attributes, "node", value);
        });
        if (info.name().equals((Object)TO_DYNAMIC_DEFINITION_CLASS)) {
            yamlTypeAnnotation.addMember("nodes", "$S", new Object[]{"tod"});
            TypeSpecHolder.put(attributes, "node", "tod");
        }
        properties.stream().sorted(Comparator.comparing(a -> ((List)a.members.get("name")).toString())).forEach(spec -> yamlTypeAnnotation.addMember("properties", "$L", new Object[]{spec}));
        builder.addAnnotation(yamlTypeAnnotation.build());
        return new TypeSpecHolder(builder.build(), attributes);
    }

    private boolean generateSetValue(CodeBlock.Builder cb, FieldInfo field, Collection<AnnotationSpec> annotations) {
        ParameterizedType parameterized;
        Type parameterized2;
        ClassInfo refType;
        if (GenerateYamlDeserializersMojo.hasAnnotation(field, XML_TRANSIENT_CLASS) && !GenerateYamlDeserializersMojo.hasAnnotation(field, DSL_PROPERTY_ANNOTATION)) {
            return false;
        }
        if (GenerateYamlDeserializersMojo.hasAnnotation(field, XML_ELEMENTS_ANNOTATION_CLASS)) {
            AnnotationInstance[] elements = field.annotation(XML_ELEMENTS_ANNOTATION_CLASS).value().asNestedArray();
            if (elements.length > 1) {
                cb.beginControlFlow("case $S:", new Object[]{StringHelper.camelCaseToDash((String)field.name()).toLowerCase(Locale.US)});
                cb.addStatement("$T val = asMappingNode(node)", new Object[]{CN_MAPPING_NODE});
                cb.addStatement("setProperties(target, val)", new Object[0]);
                cb.addStatement("break", new Object[0]);
                cb.endControlFlow();
            }
            if (field.type().name().equals((Object)LIST_CLASS)) {
                Type parameterized3 = (Type)field.type().asParameterizedType().arguments().get(0);
                for (AnnotationInstance element : elements) {
                    AnnotationValue name = element.value("name");
                    AnnotationValue type = element.value("type");
                    if (name == null || type == null) continue;
                    String fieldName = StringHelper.camelCaseToDash((String)name.asString()).toLowerCase(Locale.US);
                    String paramType = parameterized3.name().toString();
                    cb.beginControlFlow("case $S:", new Object[]{fieldName});
                    cb.addStatement("$L val = asType(node, $L.class)", new Object[]{type.asString(), type.asString()});
                    cb.addStatement("java.util.List<$L> existing = target.get$L()", new Object[]{paramType, StringHelper.capitalize((String)field.name())});
                    cb.beginControlFlow("if (existing == null)", new Object[0]);
                    cb.addStatement("existing = new java.util.ArrayList<>()", new Object[0]);
                    cb.endControlFlow();
                    cb.addStatement("existing.add(val)", new Object[0]);
                    cb.addStatement("target.set$L(existing)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    cb.endControlFlow();
                    annotations.add(GenerateYamlDeserializersMojo.yamlPropertyWithSubtype(fieldName, "object", type.asString(), this.isRequired(field)));
                }
            } else {
                for (AnnotationInstance element : elements) {
                    AnnotationValue name = element.value("name");
                    AnnotationValue type = element.value("type");
                    if (name == null || type == null) continue;
                    String fieldName = StringHelper.camelCaseToDash((String)name.asString()).toLowerCase(Locale.US);
                    cb.beginControlFlow("case $S:", new Object[]{fieldName});
                    cb.addStatement("$L val = asType(node, $L.class)", new Object[]{type.asString(), type.asString()});
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    cb.endControlFlow();
                    annotations.add(GenerateYamlDeserializersMojo.yamlPropertyWithSubtype(fieldName, "object", type.asString(), this.isRequired(field)));
                }
            }
            return true;
        }
        if (GenerateYamlDeserializersMojo.hasAnnotation(field, XML_ELEMENT_REF_ANNOTATION_CLASS) && field.type().name().equals((Object)LIST_CLASS) && this.extendsType(refType = this.view.getClassByName((parameterized2 = (Type)field.type().asParameterizedType().arguments().get(0)).name()), VERB_DEFINITION_CLASS)) {
            this.implementsOrExtends(parameterized2).forEach(ci -> {
                Optional<String> name = GenerateYamlDeserializersMojo.annotationValue(ci, XML_ROOT_ELEMENT_ANNOTATION_CLASS, "name").map(AnnotationValue::asString).filter(value -> !"##default".equals(value));
                if (!name.isPresent()) {
                    return;
                }
                String fieldName = name.get();
                String fieldType = ci.name().toString();
                cb.beginControlFlow("case $S:", new Object[]{fieldName});
                cb.addStatement("java.util.List<$L> existing = target.get$L()", new Object[]{refType.name().toString(), StringHelper.capitalize((String)field.name())});
                cb.beginControlFlow("if (existing == null)", new Object[0]);
                cb.addStatement("existing = new java.util.ArrayList<>()", new Object[0]);
                cb.endControlFlow();
                cb.addStatement("java.util.List val = asFlatList(node, $L.class)", new Object[]{fieldType});
                cb.addStatement("existing.addAll(val)", new Object[0]);
                cb.addStatement("target.set$L(existing)", new Object[]{StringHelper.capitalize((String)field.name())});
                cb.addStatement("break", new Object[0]);
                cb.endControlFlow();
                annotations.add(GenerateYamlDeserializersMojo.yamlPropertyWithSubtype(fieldName, "array", fieldType, false));
            });
        }
        if (!(GenerateYamlDeserializersMojo.hasAnnotation(field, XML_ATTRIBUTE_ANNOTATION_CLASS) || GenerateYamlDeserializersMojo.hasAnnotation(field, XML_VALUE_ANNOTATION_CLASS) || GenerateYamlDeserializersMojo.hasAnnotation(field, XML_ELEMENT_ANNOTATION_CLASS) || GenerateYamlDeserializersMojo.hasAnnotation(field, XML_ELEMENT_REF_ANNOTATION_CLASS) || GenerateYamlDeserializersMojo.hasAnnotation(field, XML_TRANSIENT_CLASS))) {
            return false;
        }
        String fieldName = StringHelper.camelCaseToDash((String)this.fieldName(field)).toLowerCase(Locale.US);
        if (field.type().kind() == Type.Kind.PARAMETERIZED_TYPE && !(parameterized = field.type().asParameterizedType()).name().equals((Object)CLASS_CLASS) && parameterized.arguments().size() == 1) {
            Type parametrizedType = (Type)parameterized.arguments().get(0);
            if (parametrizedType.name().equals((Object)PROCESSOR_DEFINITION_CLASS)) {
                return false;
            }
            switch (parameterized.name().toString()) {
                case "java.util.List": {
                    if (parametrizedType.name().equals((Object)STRING_CLASS)) {
                        cb.beginControlFlow("case $S:", new Object[]{fieldName});
                        cb.addStatement("java.util.List<String> val = asStringList(node)", new Object[0]);
                        cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                        cb.addStatement("break", new Object[0]);
                        cb.endControlFlow();
                        annotations.add(GenerateYamlDeserializersMojo.yamlPropertyWithSubtype(fieldName, "array", "string", this.isRequired(field)));
                    } else {
                        ClassInfo ci2 = this.view.getClassByName(parametrizedType.name());
                        String name = this.fieldName(ci2, field);
                        cb.beginControlFlow("case $S:", new Object[]{StringHelper.camelCaseToDash((String)name).toLowerCase(Locale.US)});
                        cb.addStatement("java.util.List<$L> val = asFlatList(node, $L.class)", new Object[]{parametrizedType.name().toString(), parametrizedType.name().toString()});
                        cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                        cb.addStatement("break", new Object[0]);
                        cb.endControlFlow();
                        annotations.add(GenerateYamlDeserializersMojo.yamlPropertyWithSubtype(StringHelper.camelCaseToDash((String)name).toLowerCase(Locale.US), "array", parametrizedType.name().toString(), this.isRequired(field)));
                    }
                    return true;
                }
                case "java.util.Set": {
                    if (parametrizedType.name().equals((Object)STRING_CLASS)) {
                        cb.beginControlFlow("case $S:", new Object[]{fieldName});
                        cb.addStatement("java.util.Set<String> val = asStringSet(node)", new Object[0]);
                        cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                        cb.addStatement("break", new Object[0]);
                        cb.endControlFlow();
                        annotations.add(GenerateYamlDeserializersMojo.yamlPropertyWithSubtype(fieldName, "array", "string", this.isRequired(field)));
                    } else {
                        ClassInfo ci3 = this.view.getClassByName(parametrizedType.name());
                        String name = this.fieldName(ci3, field);
                        cb.beginControlFlow("case $S:", new Object[]{StringHelper.camelCaseToDash((String)name).toLowerCase(Locale.US)});
                        cb.addStatement("var val = asFlatSet(node, $L.class)", new Object[]{parametrizedType.name().toString()});
                        cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                        cb.addStatement("break", new Object[0]);
                        cb.endControlFlow();
                        annotations.add(GenerateYamlDeserializersMojo.yamlPropertyWithSubtype(StringHelper.camelCaseToDash((String)name).toLowerCase(Locale.US), "array", parametrizedType.name().toString(), this.isRequired(field)));
                    }
                    return true;
                }
            }
            throw new UnsupportedOperationException("Unable to handle field: " + field.name() + " with type: " + field.type().name());
        }
        cb.beginControlFlow("case $S:", new Object[]{fieldName});
        ClassInfo c = this.view.getClassByName(field.type().name());
        if (c != null && c.isEnum()) {
            cb.addStatement("target.set$L(asEnum(node, $L.class))", new Object[]{StringHelper.capitalize((String)field.name()), field.type().name().toString()});
            cb.addStatement("break", new Object[0]);
            TreeSet<String> values = new TreeSet<String>();
            List fields = c.fields();
            for (int i = 1; i < fields.size(); ++i) {
                values.add(((FieldInfo)fields.get(i)).name());
            }
            AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)CN_YAML_PROPERTY);
            builder.addMember("name", "$S", new Object[]{fieldName});
            builder.addMember("type", "$S", new Object[]{"enum:" + String.join((CharSequence)",", values)});
            if (this.isRequired(field)) {
                builder.addMember("required", "$L", new Object[]{this.isRequired(field)});
            }
            annotations.add(builder.build());
        } else {
            block28 : switch (field.type().name().toString()) {
                case "[B": {
                    cb.addStatement("byte[] val = asByteArray(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlPropertyWithFormat(fieldName, "string", "binary", this.isRequired(field)));
                    break;
                }
                case "Z": 
                case "boolean": {
                    cb.addStatement("boolean val = asBoolean(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlProperty(fieldName, "boolean", this.isRequired(field)));
                    break;
                }
                case "I": 
                case "int": {
                    cb.addStatement("int val = asInt(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlProperty(fieldName, "number", this.isRequired(field)));
                    break;
                }
                case "J": 
                case "long": {
                    cb.addStatement("long val = asLong(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlProperty(fieldName, "number", this.isRequired(field)));
                    break;
                }
                case "D": 
                case "double": {
                    cb.addStatement("double val = asDouble(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlProperty(fieldName, "number", this.isRequired(field)));
                    break;
                }
                case "java.lang.String": {
                    String javaType;
                    cb.addStatement("String val = asText(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    switch (javaType = GenerateYamlDeserializersMojo.annotationValue(field, METADATA_ANNOTATION_CLASS, "javaType").map(AnnotationValue::asString).orElse("string")) {
                        case "java.lang.Boolean": {
                            annotations.add(GenerateYamlDeserializersMojo.yamlProperty(fieldName, "boolean", this.isRequired(field)));
                            break block28;
                        }
                        case "java.lang.Integer": 
                        case "java.lang.Short": 
                        case "java.lang.Long": 
                        case "java.lang.Float": 
                        case "java.lang.Double": {
                            annotations.add(GenerateYamlDeserializersMojo.yamlProperty(fieldName, "number", this.isRequired(field)));
                            break block28;
                        }
                    }
                    annotations.add(GenerateYamlDeserializersMojo.yamlProperty(fieldName, "string", this.isRequired(field)));
                    break;
                }
                case "java.lang.Class": {
                    cb.addStatement("java.lang.Class<?> val = asClass(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlProperty(fieldName, "string", this.isRequired(field)));
                    break;
                }
                case "[Ljava.lang.Class;": {
                    cb.addStatement("java.lang.Class<?>[] val = asClassArray(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    break;
                }
                case "java.lang.Integer": 
                case "java.lang.Short": 
                case "java.lang.Long": 
                case "java.lang.Float": 
                case "java.lang.Double": {
                    cb.addStatement("String val = asText(node)", new Object[0]);
                    cb.addStatement("target.set$L($L.valueOf(val))", new Object[]{StringHelper.capitalize((String)field.name()), field.type().name().toString()});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlProperty(fieldName, "number", this.isRequired(field)));
                    break;
                }
                case "java.lang.Boolean": {
                    cb.addStatement("String val = asText(node)", new Object[0]);
                    cb.addStatement("target.set$L($L.valueOf(val))", new Object[]{StringHelper.capitalize((String)field.name()), field.type().name().toString()});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlProperty(fieldName, "boolean", this.isRequired(field)));
                    break;
                }
                default: {
                    if (field.type().kind() == Type.Kind.CLASS) {
                        cb.addStatement("$L val = asType(node, $L.class)", new Object[]{field.type().name().toString(), field.type().name().toString()});
                        cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                        cb.addStatement("break", new Object[0]);
                        annotations.add(GenerateYamlDeserializersMojo.yamlPropertyWithSubtype(fieldName, "object", field.type().name().toString(), this.isRequired(field)));
                        break;
                    }
                    throw new UnsupportedOperationException("Unable to handle field: " + field.name() + " with type: " + field.type().name());
                }
            }
        }
        cb.endControlFlow();
        return true;
    }

    private boolean generateSetValue(CodeBlock.Builder cb, MethodInfo method, Collection<AnnotationSpec> annotations) {
        String name = StringHelper.camelCaseToDash((String)method.name()).toLowerCase(Locale.US).substring(4);
        Type parameterType = (Type)method.parameters().get(0);
        cb.beginControlFlow("case $S:", new Object[]{name});
        ClassInfo c = this.view.getClassByName(parameterType.name());
        if (c != null && c.isEnum()) {
            cb.addStatement("target.$L(asEnum(node, $L.class))", new Object[]{method.name(), parameterType});
            cb.addStatement("break", new Object[0]);
            TreeSet<String> values = new TreeSet<String>();
            List fields = c.fields();
            for (int i = 1; i < fields.size(); ++i) {
                values.add(((FieldInfo)fields.get(i)).name());
            }
            AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)CN_YAML_PROPERTY);
            builder.addMember("name", "$S", new Object[]{name});
            builder.addMember("type", "$S", new Object[]{"enum:" + String.join((CharSequence)",", values)});
            annotations.add(builder.build());
        } else {
            switch (parameterType.name().toString()) {
                case "[B": {
                    cb.addStatement("byte[] val = asByteArray(node)", new Object[0]);
                    cb.addStatement("target.$L(val)", new Object[]{method.name()});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlPropertyWithFormat(name, "string", "binary"));
                    break;
                }
                case "Z": 
                case "boolean": {
                    cb.addStatement("boolean val = asBoolean(node)", new Object[0]);
                    cb.addStatement("target.$L(val)", new Object[]{method.name()});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlProperty(name, "boolean"));
                    break;
                }
                case "I": 
                case "int": {
                    cb.addStatement("int val = asInt(node)", new Object[0]);
                    cb.addStatement("target.$L(val)", new Object[]{method.name()});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlProperty(name, "number"));
                    break;
                }
                case "J": 
                case "long": {
                    cb.addStatement("long val = asLong(node)", new Object[0]);
                    cb.addStatement("target.$L(val)", new Object[]{method.name()});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlProperty(name, "number"));
                    break;
                }
                case "D": 
                case "double": {
                    cb.addStatement("double val = asDouble(node)", new Object[0]);
                    cb.addStatement("target.$L(val)", new Object[]{method.name()});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlProperty(name, "number"));
                    break;
                }
                case "java.lang.String": {
                    cb.addStatement("String val = asText(node)", new Object[0]);
                    cb.addStatement("target.$L(val)", new Object[]{method.name()});
                    cb.addStatement("break", new Object[0]);
                    break;
                }
                case "java.lang.Class": {
                    cb.addStatement("java.lang.Class<?> val = asClass(node)", new Object[0]);
                    cb.addStatement("target.$L(val)", new Object[]{method.name()});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlProperty(name, "string"));
                    break;
                }
                case "[Ljava.lang.Class;": {
                    cb.addStatement("java.lang.Class<?>[] val = asClassArray(node)", new Object[0]);
                    cb.addStatement("target.$L(val)", new Object[]{method.name()});
                    cb.addStatement("break", new Object[0]);
                    break;
                }
                case "java.lang.Integer": 
                case "java.lang.Short": 
                case "java.lang.Long": 
                case "java.lang.Float": 
                case "java.lang.Double": {
                    cb.addStatement("String val = asText(node)", new Object[0]);
                    cb.addStatement("target.$L($L.valueOf(val))", new Object[]{method.name(), parameterType.toString()});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlProperty(name, "number"));
                    break;
                }
                case "java.lang.Boolean": {
                    cb.addStatement("String val = asText(node)", new Object[0]);
                    cb.addStatement("target.$L($L.valueOf(val))", new Object[]{method.name(), parameterType.toString()});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(GenerateYamlDeserializersMojo.yamlProperty(name, "boolean"));
                    break;
                }
                default: {
                    if (parameterType.kind() == Type.Kind.CLASS) {
                        cb.addStatement("$L val = asType(node, $L.class)", new Object[]{parameterType.toString(), parameterType.toString()});
                        cb.addStatement("target.$L(val)", new Object[]{method.name()});
                        cb.addStatement("break", new Object[0]);
                        annotations.add(GenerateYamlDeserializersMojo.yamlPropertyWithSubtype(name, "object", parameterType.toString()));
                        break;
                    }
                    throw new UnsupportedOperationException("Unable to handle method: " + method.name() + " with type: " + parameterType);
                }
            }
        }
        cb.endControlFlow();
        return true;
    }
}

