/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.dsl.yaml;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.maven.dsl.yaml.GenerateYamlSupportMojo;
import org.apache.camel.maven.dsl.yaml.support.ToolingSupport;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

@Mojo(name="generate-yaml-schema", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true, requiresProject=false)
public class GenerateYamlSchemaMojo
extends GenerateYamlSupportMojo {
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/camel-yaml-dsl.json")
    private File outputFile;
    private ObjectNode items;
    private ObjectNode definitions;
    private ObjectNode step;

    @Override
    protected void generate() throws MojoFailureException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode root = mapper.createObjectNode();
        root.put("$schema", "http://json-schema.org/draft-04/schema#");
        root.put("type", "array");
        this.items = root.putObject("items");
        this.items.put("maxProperties", 1);
        this.definitions = this.items.putObject("definitions");
        this.step = this.definitions.with("org.apache.camel.model.ProcessorDefinition").put("type", "object").put("maxProperties", 1);
        TreeMap types = new TreeMap();
        this.annotated(YAML_TYPE_ANNOTATION).sorted(Comparator.comparingInt(GenerateYamlSupportMojo::getYamlTypeOrder)).forEach(ci -> {
            GenerateYamlSchemaMojo.annotationValue(ci, YAML_TYPE_ANNOTATION, "types").map(AnnotationValue::asStringArray).ifPresent(values -> Stream.of(values).forEach(item -> types.putIfAbsent(item, ci)));
            if (!GenerateYamlSchemaMojo.hasAnnotationValue(ci, YAML_TYPE_ANNOTATION, "types")) {
                types.putIfAbsent(ci.name().toString(), ci);
            }
        });
        for (Map.Entry entry : types.entrySet()) {
            Set nodes = GenerateYamlSchemaMojo.annotationValue((ClassInfo)entry.getValue(), YAML_TYPE_ANNOTATION, "nodes").map(AnnotationValue::asStringArray).map(values -> Stream.of(values).collect(Collectors.toCollection(TreeSet::new))).orElseGet(TreeSet::new);
            if (GenerateYamlSchemaMojo.hasAnnotation((ClassInfo)entry.getValue(), YAML_IN_ANNOTATION)) {
                nodes.forEach(node -> this.items.with("properties").putObject(node).put("$ref", "#/items/definitions/" + (String)entry.getKey()));
            } else {
                DotName name = DotName.createSimple((String)((String)entry.getKey()));
                ClassInfo info = this.view.getClassByName(name);
                if (this.extendsType(info, PROCESSOR_DEFINITION_CLASS)) {
                    nodes.forEach(node -> this.step.with("properties").putObject(node).put("$ref", "#/items/definitions/" + (String)entry.getKey()));
                }
            }
            this.generate((String)entry.getKey(), (ClassInfo)entry.getValue());
        }
        try {
            ToolingSupport.mkparents(this.outputFile);
            StringWriter sw = new StringWriter();
            mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)sw, (Object)root);
            FileUtil.updateFile((Path)this.outputFile.toPath(), (String)sw.toString());
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void generate(String type, ClassInfo info) {
        ObjectNode definition = this.definitions.with(type);
        ArrayList<AnnotationInstance> properties = new ArrayList<AnnotationInstance>();
        ObjectNode objectDefinition = definition;
        if (GenerateYamlSchemaMojo.annotationValue(info, YAML_TYPE_ANNOTATION, "inline").map(AnnotationValue::asBoolean).orElse(false).booleanValue()) {
            ArrayNode anyOf = definition.withArray("oneOf");
            anyOf.addObject().put("type", "string");
            objectDefinition = anyOf.addObject();
        }
        objectDefinition.put("type", "object");
        this.collectYamlProperties(properties, info);
        properties.sort(Comparator.comparing(property -> GenerateYamlSchemaMojo.annotationValue(property, "name").map(AnnotationValue::asString).orElse("")));
        for (AnnotationInstance property2 : properties) {
            String objectRef;
            String propertyName = GenerateYamlSchemaMojo.annotationValue(property2, "name").map(AnnotationValue::asString).orElse("");
            String propertyType = GenerateYamlSchemaMojo.annotationValue(property2, "type").map(AnnotationValue::asString).orElse("");
            boolean propertyRequired = GenerateYamlSchemaMojo.annotationValue(property2, "required").map(AnnotationValue::asBoolean).orElse(false);
            if (propertyName.equals("__extends") && propertyType.startsWith("object:")) {
                objectRef = StringHelper.after((String)propertyType, (String)":");
                definition.withArray("anyOf").addObject().put("$ref", "#/items/definitions/" + objectRef);
                continue;
            }
            if (propertyName.equals("__extends") && propertyType.startsWith("array:")) {
                objectRef = StringHelper.after((String)propertyType, (String)":");
                definition.put("type", "array").with("items").put("$ref", "#/items/definitions/" + objectRef);
                continue;
            }
            if (propertyName.startsWith("__")) continue;
            this.setProperty(objectDefinition, propertyName, propertyType);
            if (!propertyRequired) continue;
            definition.withArray("required").add(propertyName);
        }
    }

    private void setProperty(ObjectNode objectDefinition, String propertyName, String propertyType) {
        if (propertyType.startsWith("object:")) {
            String objectType = StringHelper.after((String)propertyType, (String)":");
            objectDefinition.with("properties").with(propertyName).put("$ref", "#/items/definitions/" + objectType);
        } else if (propertyType.startsWith("array:")) {
            String arrayType = StringHelper.after((String)propertyType, (String)":");
            if (arrayType.contains(".")) {
                objectDefinition.with("properties").with(propertyName).put("type", "array").with("items").put("$ref", "#/items/definitions/" + arrayType);
            } else {
                objectDefinition.with("properties").with(propertyName).put("type", "array").with("items").put("type", arrayType);
            }
        } else if (propertyType.startsWith("enum:")) {
            objectDefinition.with("properties").with(propertyName).put("type", "string");
            String enumValues = StringHelper.after((String)propertyType, (String)":");
            for (String enumValue : enumValues.split(",")) {
                objectDefinition.with("properties").with(propertyName).withArray("enum").add(enumValue);
            }
        } else {
            objectDefinition.with("properties").with(propertyName).put("type", propertyType);
        }
    }

    private void collectYamlProperties(List<AnnotationInstance> annotations, ClassInfo info) {
        if (info == null) {
            return;
        }
        GenerateYamlSchemaMojo.annotationValue(info, YAML_TYPE_ANNOTATION, "properties").map(AnnotationValue::asNestedArray).ifPresent(properties -> {
            for (AnnotationInstance property : properties) {
                String propertyName = GenerateYamlSchemaMojo.annotationValue(property, "name").map(AnnotationValue::asString).orElse("");
                String propertyType = GenerateYamlSchemaMojo.annotationValue(property, "type").map(AnnotationValue::asString).orElse("");
                if (ObjectHelper.isEmpty((Object)propertyName) || ObjectHelper.isEmpty((Object)propertyType)) {
                    this.getLog().warn((CharSequence)("Missing name or type for property + " + property + " on type " + info.name().toString()));
                    return;
                }
                if (propertyName.startsWith("__")) {
                    annotations.add(property);
                } else {
                    boolean matches = annotations.stream().map(p -> GenerateYamlSchemaMojo.annotationValue(p, "name").map(AnnotationValue::asString).orElse("")).anyMatch(propertyName::equals);
                    if (matches) {
                        return;
                    }
                    annotations.add(property);
                }
                DotName superName = info.superName();
                if (superName == null) continue;
                this.collectYamlProperties(annotations, this.view.getClassByName(superName));
            }
        });
    }
}

