/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.dsl.yaml.support;

import com.fasterxml.jackson.databind.JsonNode;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import org.apache.camel.maven.dsl.yaml.GenerateYamlSupportMojo;
import org.apache.camel.tooling.util.Strings;

public final class YamlProperties {
    private YamlProperties() {
    }

    public static AnnotationBuilder annotation(String name, String type) {
        return new AnnotationBuilder().withName(name).withType(type);
    }

    public static class AnnotationBuilder {
        private String name;
        private String displayName;
        private String description;
        private String type;
        private String subType;
        private String format;
        private String defaultValue;
        private boolean required;
        private boolean deprecated;
        private boolean secret;
        private String oneOf;

        public AnnotationBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public AnnotationBuilder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public AnnotationBuilder withDisplayName(JsonNode node) {
            if (node == null) {
                return this;
            }
            if (node.isMissingNode()) {
                return this;
            }
            if (!node.isTextual()) {
                return this;
            }
            return this.withDisplayName(node.asText());
        }

        public AnnotationBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public AnnotationBuilder withDescription(JsonNode node) {
            if (node == null) {
                return this;
            }
            if (node.isMissingNode()) {
                return this;
            }
            if (!node.isTextual()) {
                return this;
            }
            return this.withDescription(node.asText());
        }

        public AnnotationBuilder withType(String type) {
            this.type = type;
            return this;
        }

        public AnnotationBuilder withSubType(String subType) {
            this.subType = subType;
            return this;
        }

        public AnnotationBuilder withFormat(String format) {
            this.format = format;
            return this;
        }

        public AnnotationBuilder withRequired(boolean required) {
            this.required = required;
            return this;
        }

        public AnnotationBuilder withDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public AnnotationBuilder withDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public AnnotationBuilder withDefaultValue(JsonNode node) {
            if (node == null) {
                return this;
            }
            if (node.isMissingNode()) {
                return this;
            }
            if (!node.isTextual()) {
                return this;
            }
            return this.withDefaultValue(node.asText());
        }

        public AnnotationBuilder withIsSecret(boolean secret) {
            this.secret = secret;
            return this;
        }

        public AnnotationBuilder withIsSecret(JsonNode node) {
            if (node == null) {
                return this;
            }
            if (node.isMissingNode()) {
                return this;
            }
            if (!node.isTextual()) {
                return this;
            }
            return this.withIsSecret(node.asBoolean());
        }

        public AnnotationBuilder withOneOf(String oneOf) {
            this.oneOf = oneOf;
            return this;
        }

        public AnnotationSpec build() {
            AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)GenerateYamlSupportMojo.CN_YAML_PROPERTY);
            builder.addMember("name", "$S", new Object[]{this.name});
            if (this.subType == null) {
                builder.addMember("type", "$S", new Object[]{this.type});
            } else {
                builder.addMember("type", "$S", new Object[]{this.type + ":" + this.subType});
            }
            if (this.required) {
                builder.addMember("required", "$L", new Object[]{this.required});
            }
            if (this.deprecated) {
                builder.addMember("deprecated", "$L", new Object[]{this.deprecated});
            }
            if (!Strings.isNullOrEmpty((String)this.format)) {
                builder.addMember("format", "$S", new Object[]{this.format});
            } else if (this.secret) {
                builder.addMember("format", "$S", new Object[]{"password"});
            }
            if (!Strings.isNullOrEmpty((String)this.defaultValue)) {
                builder.addMember("defaultValue", "$S", new Object[]{this.defaultValue});
            }
            if (!Strings.isNullOrEmpty((String)this.description)) {
                builder.addMember("description", "$S", new Object[]{this.description});
            }
            if (!Strings.isNullOrEmpty((String)this.displayName)) {
                builder.addMember("displayName", "$S", new Object[]{this.displayName});
            }
            if (!Strings.isNullOrEmpty((String)this.oneOf)) {
                builder.addMember("oneOf", "$S", new Object[]{this.oneOf});
            }
            return builder.build();
        }
    }
}

