/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dsl.yaml.YamlRoutesBuilderLoaderSupport;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplateParameterDefinition;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@ManagedResource(description="Managed Kamelet RoutesBuilderLoader")
@RoutesLoader(value="kamelet.yaml")
public class KameletRoutesBuilderLoader
extends YamlRoutesBuilderLoaderSupport {
    public static final String EXTENSION = "kamelet.yaml";

    public KameletRoutesBuilderLoader() {
        super(EXTENSION);
    }

    @Override
    protected RouteBuilder builder(Node node) {
        Node template = YamlDeserializerSupport.nodeAt((Node)node, (String)"/spec/template");
        if (template == null) {
            template = YamlDeserializerSupport.nodeAt((Node)node, (String)"/spec/flow");
        }
        if (template == null) {
            throw new IllegalArgumentException("No template defined");
        }
        Set required = YamlDeserializerSupport.asStringSet((Node)YamlDeserializerSupport.nodeAt((Node)node, (String)"/spec/definition/required"));
        if (required == null) {
            required = Collections.emptySet();
        }
        YamlDeserializationContext context = this.getDeserializationContext();
        final RouteTemplateDefinition rtd = (RouteTemplateDefinition)context.construct(template, RouteTemplateDefinition.class);
        rtd.id(YamlDeserializerSupport.asText((Node)YamlDeserializerSupport.nodeAt((Node)node, (String)"/metadata/name")));
        Node properties = YamlDeserializerSupport.nodeAt((Node)node, (String)"/spec/definition/properties");
        if (properties != null) {
            rtd.setTemplateParameters(new ArrayList());
            for (NodeTuple p : YamlDeserializerSupport.asMappingNode((Node)properties).getValue()) {
                String key = YamlDeserializerSupport.asText((Node)p.getKeyNode());
                Node def = YamlDeserializerSupport.nodeAt((Node)p.getValueNode(), (String)"/default");
                RouteTemplateParameterDefinition rtpd = new RouteTemplateParameterDefinition();
                rtpd.setName(key);
                rtpd.setDefaultValue(YamlDeserializerSupport.asText((Node)def));
                rtpd.setRequired(Boolean.valueOf(required.contains(key)));
                rtd.getTemplateParameters().add(rtpd);
            }
        }
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.getRouteTemplateCollection().routeTemplate(rtd);
            }
        };
    }
}

