/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml;

import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dsl.yaml.YamlRoutesBuilderLoaderSupport;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.deserializers.OutputAwareFromDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.snakeyaml.engine.v2.nodes.Node;

@ManagedResource(description="Managed YAML RoutesBuilderLoader")
@RoutesLoader(value="yaml")
public class YamlRoutesBuilderLoader
extends YamlRoutesBuilderLoaderSupport {
    public static final String EXTENSION = "yaml";

    public YamlRoutesBuilderLoader() {
        super(EXTENSION);
    }

    @Override
    protected RouteBuilder builder(final Node root) {
        return new RouteBuilder(){

            public void configure() throws Exception {
                for (Node node : YamlDeserializerSupport.asSequenceNode((Node)root).getValue()) {
                    Object item = YamlRoutesBuilderLoader.this.getDeserializationContext().mandatoryResolve(node).construct(node);
                    if (item instanceof OutputAwareFromDefinition) {
                        RouteDefinition route = new RouteDefinition();
                        route.setInput(((OutputAwareFromDefinition)item).getDelegate());
                        route.setOutputs(((OutputAwareFromDefinition)item).getOutputs());
                        this.getRouteCollection().route(route);
                        continue;
                    }
                    if (item instanceof RouteDefinition) {
                        this.getRouteCollection().route((RouteDefinition)item);
                        continue;
                    }
                    if (item instanceof CamelContextCustomizer) {
                        ((CamelContextCustomizer)item).configure(YamlRoutesBuilderLoader.this.getCamelContext());
                        continue;
                    }
                    if (item instanceof OnExceptionDefinition) {
                        if (!this.getRouteCollection().getRoutes().isEmpty()) {
                            throw new IllegalArgumentException("onException must be defined before any routes in the RouteBuilder");
                        }
                        this.getRouteCollection().getOnExceptions().add((OnExceptionDefinition)item);
                        continue;
                    }
                    if (item instanceof ErrorHandlerBuilder) {
                        if (!this.getRouteCollection().getRoutes().isEmpty()) {
                            throw new IllegalArgumentException("errorHandler must be defined before any routes in the RouteBuilder");
                        }
                        this.errorHandler((ErrorHandlerBuilder)item);
                        continue;
                    }
                    if (item instanceof RouteTemplateDefinition) {
                        this.getRouteTemplateCollection().routeTemplate((RouteTemplateDefinition)item);
                        continue;
                    }
                    if (item instanceof RestDefinition) {
                        RestDefinition definition = (RestDefinition)item;
                        for (VerbDefinition verb : definition.getVerbs()) {
                            verb.setRest(definition);
                        }
                        this.getRestCollection().rest(definition);
                        continue;
                    }
                    if (!(item instanceof RestConfigurationDefinition)) continue;
                    ((RestConfigurationDefinition)item).asRestConfiguration(YamlRoutesBuilderLoader.this.getCamelContext(), YamlRoutesBuilderLoader.this.getCamelContext().getRestConfiguration());
                }
            }
        };
    }
}

