/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dsl.support.RouteBuilderLoaderSupport;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializationMode;
import org.apache.camel.dsl.yaml.common.YamlDeserializerResolver;
import org.apache.camel.dsl.yaml.common.exception.YamlDeserializationException;
import org.apache.camel.dsl.yaml.deserializers.CustomResolver;
import org.apache.camel.dsl.yaml.deserializers.EndpointProducerDeserializersResolver;
import org.apache.camel.dsl.yaml.deserializers.ModelDeserializersResolver;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.api.YamlUnicodeReader;
import org.snakeyaml.engine.v2.composer.Composer;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.parser.Parser;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.scanner.StreamReader;

public abstract class YamlRoutesBuilderLoaderSupport
extends RouteBuilderLoaderSupport {
    public static final String DESERIALIZATION_MODE = "CamelYamlDslDeserializationMode";
    private LoadSettings settings;
    private YamlDeserializationContext deserializationContext;
    private YamlDeserializationMode deserializationMode;

    public YamlRoutesBuilderLoaderSupport(String extension) {
        super(extension);
    }

    public YamlDeserializationMode getDeserializationMode() {
        return this.deserializationMode;
    }

    public void setDeserializationMode(YamlDeserializationMode deserializationMode) {
        this.deserializationMode = deserializationMode;
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        this.settings = LoadSettings.builder().build();
        this.deserializationContext = new YamlDeserializationContext(this.settings);
        this.deserializationContext.setCamelContext(this.getCamelContext());
        this.deserializationContext.addResolvers(new YamlDeserializerResolver[]{new CustomResolver()});
        this.deserializationContext.addResolvers(new YamlDeserializerResolver[]{new ModelDeserializersResolver()});
        this.deserializationContext.addResolvers(new YamlDeserializerResolver[]{new EndpointProducerDeserializersResolver()});
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.deserializationMode == null) {
            Map options = this.getCamelContext().getGlobalOptions();
            String mode = (String)options.get(DESERIALIZATION_MODE);
            if (mode != null) {
                this.deserializationContext.setDeserializationMode(YamlDeserializationMode.valueOf((String)mode.toUpperCase(Locale.US)));
            } else {
                this.deserializationContext.setDeserializationMode(YamlDeserializationMode.FLOW);
            }
        } else {
            this.deserializationContext.setDeserializationMode(this.deserializationMode);
        }
        ServiceHelper.startService((Object)this.deserializationContext);
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)this.deserializationContext);
        this.deserializationContext = null;
        this.settings = null;
    }

    public RouteBuilder doLoadRouteBuilder(Resource resource) throws Exception {
        ObjectHelper.notNull((Object)this.deserializationContext, (String)"constructor");
        ObjectHelper.notNull((Object)this.settings, (String)"settings");
        if (!resource.exists()) {
            throw new FileNotFoundException("Resource not found: " + resource.getLocation());
        }
        try (InputStream is = resource.getInputStream();){
            StreamReader reader = new StreamReader((Reader)new YamlUnicodeReader(is), this.settings);
            ParserImpl parser = new ParserImpl(reader, this.settings);
            Composer composer = new Composer((Parser)parser, this.settings);
            RouteBuilder routeBuilder = composer.getSingleNode().map(this::builder).orElseThrow(() -> new YamlDeserializationException("Unable to deserialize resource"));
            return routeBuilder;
        }
    }

    protected LoadSettings getSettings() {
        return this.settings;
    }

    protected YamlDeserializationContext getDeserializationContext() {
        return this.deserializationContext;
    }

    protected abstract RouteBuilder builder(Node var1);
}

